/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.io;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.Direction;
import edu.berkeley.guir.damask.InteractionElement;
import edu.berkeley.guir.damask.InteractionGraph;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.component.Select;
import edu.berkeley.guir.damask.component.SelectMany;
import edu.berkeley.guir.damask.component.SelectOne;
import edu.berkeley.guir.damask.component.TextInput;
import edu.berkeley.guir.damask.component.Trigger;
import edu.berkeley.guir.damask.connection.NavConnection;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.damask.dialog.TemplateDialog;
import edu.berkeley.guir.damask.userevent.InvokeEvent;
import edu.berkeley.guir.lib.util.StringLib;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.CDATA;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class VoiceXMLWriter {
    private static final Pattern INVALID_ID_CHARS;
    private static XMLOutputter outputter;
    public static final String NOINPUT_DEFAULT_AUDIO = "I'm sorry, I didn't hear you.";
    public static final String NOMATCH_DEFAULT_AUDIO = "I'm sorry, I didn't get that.";
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.io.VoiceXMLWriter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        INVALID_ID_CHARS = Pattern.compile("[^\\.\\w]");
        outputter = new XMLOutputter();
        outputter.setFormat(Format.getPrettyFormat());
    }

    private VoiceXMLWriter() {
    }

    public static void save(InteractionGraph realGraph, OutputStream outStream) throws IOException {
        Document document = VoiceXMLWriter.writeDamask(realGraph);
        outputter.output(document, outStream);
    }

    public static void save(InteractionGraph realGraph, Writer writer) throws IOException {
        Document document = VoiceXMLWriter.writeDamask(realGraph);
        outputter.output(document, writer);
    }

    private static Document writeDamask(InteractionGraph realGraph) {
        Dialog realDialog;
        Document doc = new Document();
        Element root = new Element("vxml");
        root.setAttribute("version", "2.0");
        doc.setRootElement(root);
        Iterator i = realGraph.getTemplates().iterator();
        while (i.hasNext()) {
            TemplateDialog realTemplate = (TemplateDialog)i.next();
            root.addContent(VoiceXMLWriter.writeTemplate(realTemplate));
        }
        Page homePage = realGraph.getHomePage(DeviceType.VOICE);
        Dialog homeDialog = homePage == null ? null : homePage.getDialog();
        Iterator i2 = realGraph.getDialogs().iterator();
        while (i2.hasNext()) {
            realDialog = (Dialog)i2.next();
            if (realDialog != homeDialog) continue;
            root.addContent(VoiceXMLWriter.writeDialog(realDialog));
        }
        i2 = realGraph.getDialogs().iterator();
        while (i2.hasNext()) {
            realDialog = (Dialog)i2.next();
            if (realDialog == homeDialog || !realDialog.isVisibleToDeviceType(DeviceType.VOICE)) continue;
            root.addContent(VoiceXMLWriter.writeDialog(realDialog));
        }
        return doc;
    }

    private static List writeDialog(Dialog realDialog) {
        ArrayList<Element> result = new ArrayList<Element>();
        Iterator i = realDialog.getPages(DeviceType.VOICE).iterator();
        while (i.hasNext()) {
            Element gotoElement;
            Element audio;
            Page realPage = (Page)i.next();
            String realPageId = VoiceXMLWriter.writeId(realPage);
            Element form = new Element("form");
            form.setAttribute("id", "form" + realPageId);
            Element field = new Element("field");
            field.setAttribute("name", realPageId);
            Element block = new Element("block");
            block.setAttribute("name", realPageId);
            Element filled = new Element("filled");
            HashMap<String, Page> ifTable = new HashMap<String, Page>();
            ArrayList<String> utterances = new ArrayList<String>();
            PageRegion realRegion = realPage.getRegion(Direction.CENTER);
            boolean condition = false;
            Iterator j = realRegion.getControls().iterator();
            while (j.hasNext()) {
                NavConnection connection;
                Control realControl = (Control)j.next();
                if (realControl instanceof Content) {
                    Element prompt = new Element("prompt");
                    field.addContent(prompt);
                    audio = new Element("audio");
                    prompt.addContent(audio);
                    audio.addContent(((Content)realControl).getVoicePromptText());
                    audio = new Element("audio");
                    block.addContent(audio);
                    audio.addContent(((Content)realControl).getVoicePromptText());
                } else if (realControl instanceof SelectMany) {
                    if (!$assertionsDisabled && ((SelectMany)realControl).getItems().size() != 1) {
                        throw new AssertionError();
                    }
                    SelectMany.Item item = (SelectMany.Item)((SelectMany)realControl).getItems().get(0);
                    Element prompt = new Element("prompt");
                    field.addContent(prompt);
                    Element audio2 = new Element("audio");
                    prompt.addContent(audio2);
                    audio2.addContent(item.getVoicePromptText());
                }
                if (realControl instanceof Select) {
                    Control nextControl;
                    Control controlToOutput;
                    ArrayList<String> itemTexts = new ArrayList<String>();
                    if (realControl instanceof SelectOne) {
                        controlToOutput = realControl;
                    } else {
                        if (!$assertionsDisabled && ((SelectMany)realControl).getItems().size() != 1) {
                            throw new AssertionError();
                        }
                        controlToOutput = (SelectMany.Item)((SelectMany)realControl).getItems().get(0);
                    }
                    Iterator k = controlToOutput.getVoiceResponseTextList().iterator();
                    while (k.hasNext()) {
                        String text = (String)k.next();
                        if (text.contains(" ")) {
                            itemTexts.add("(" + text.toLowerCase() + ")");
                            continue;
                        }
                        itemTexts.add(text.toLowerCase());
                    }
                    String utteranceString = "[" + StringLib.join(itemTexts) + "]";
                    if (j.hasNext() && (nextControl = (Control)j.next()) instanceof Trigger) {
                        String triggerId = VoiceXMLWriter.writeId(nextControl);
                        utteranceString = String.valueOf(utteranceString) + " {<" + field.getAttributeValue("name") + " \"" + triggerId + "\">}";
                        NavConnection connection2 = ((Trigger)nextControl).getOutConnection(DeviceType.VOICE, new InvokeEvent(nextControl), 0);
                        ifTable.put(String.valueOf(field.getAttributeValue("name")) + " == '" + triggerId + "'", connection2.getDest(DeviceType.VOICE).getPage(DeviceType.VOICE));
                    }
                    utterances.add(utteranceString);
                    continue;
                }
                if (realControl instanceof TextInput) {
                    Control nextControl;
                    if (!j.hasNext() || !((nextControl = (Control)j.next()) instanceof Trigger)) continue;
                    NavConnection connection3 = ((Trigger)nextControl).getOutConnection(DeviceType.VOICE, new InvokeEvent(nextControl), 0);
                    Element nomatch = new Element("nomatch");
                    field.addContent(nomatch);
                    gotoElement = new Element("goto");
                    nomatch.addContent(gotoElement);
                    gotoElement.setAttribute("next", "#form" + VoiceXMLWriter.writeId(connection3.getDest(DeviceType.VOICE).getPage(DeviceType.VOICE)));
                    continue;
                }
                if (!(realControl instanceof Trigger) || (connection = ((Trigger)realControl).getOutConnection(DeviceType.VOICE, new InvokeEvent(realControl), 0)) == null) continue;
                Page destPage = connection.getDest(DeviceType.VOICE).getPage(DeviceType.VOICE);
                Iterator k = realControl.getVoiceResponseTextList().iterator();
                while (k.hasNext()) {
                    String responseOrigText = (String)k.next();
                    String responseText = responseOrigText.toLowerCase();
                    if (responseText.equals("")) {
                        Element gotoElement2 = new Element("goto");
                        block.addContent(gotoElement2);
                        gotoElement2.setAttribute("next", "#form" + VoiceXMLWriter.writeId(destPage));
                        continue;
                    }
                    String utteranceString = responseText.contains(" ") ? "[(" + responseText + ")]" : "[" + responseText + "]";
                    String triggerId = VoiceXMLWriter.writeId(realControl);
                    utteranceString = String.valueOf(utteranceString) + " {<" + field.getAttributeValue("name") + " \"" + triggerId + "\">}";
                    ifTable.put(String.valueOf(field.getAttributeValue("name")) + " == '" + triggerId + "'", destPage);
                    utterances.add(utteranceString);
                }
            }
            if (!utterances.isEmpty()) {
                Element grammar = new Element("grammar");
                grammar.setAttribute("type", "application/x-gsl");
                grammar.setAttribute("mode", "voice");
                utterances.add(0, "[");
                utterances.add("]");
                grammar.addContent(new CDATA(StringLib.join(utterances, "\n")));
                field.addContent(grammar);
            }
            boolean firstEntry = true;
            Element ifElement = new Element("if");
            Iterator k = ifTable.keySet().iterator();
            while (k.hasNext()) {
                String ifCond = (String)k.next();
                if (firstEntry) {
                    ifElement.setAttribute("cond", ifCond);
                    Element gotoElement3 = new Element("goto");
                    ifElement.addContent(gotoElement3);
                    gotoElement3.setAttribute("next", "#form" + VoiceXMLWriter.writeId((Page)ifTable.get(ifCond)));
                    firstEntry = false;
                    continue;
                }
                if (ifCond.equals("")) continue;
                Element elseIfElement = new Element("elseif");
                ifElement.addContent(elseIfElement);
                elseIfElement.setAttribute("cond", ifCond);
                gotoElement = new Element("goto");
                gotoElement.setAttribute("next", "#form" + VoiceXMLWriter.writeId((Page)ifTable.get(ifCond)));
                ifElement.addContent(gotoElement);
            }
            if (ifTable.containsKey("")) {
                Element gotoElement4 = new Element("goto");
                gotoElement4.setAttribute("next", "#form" + VoiceXMLWriter.writeId((Page)ifTable.get("")));
                if (ifElement.getChildren().size() > 0) {
                    ifElement.addContent(new Element("else"));
                    ifElement.addContent(gotoElement4);
                } else {
                    filled.addContent(gotoElement4);
                }
            }
            if (ifElement.getChildren().size() > 0) {
                filled.addContent(ifElement);
            }
            if (filled.getChildren().size() > 0) {
                field.addContent(filled);
            }
            if (block.getChild("goto") != null) {
                form.addContent(block);
            } else if (field.getChildren().size() > 0) {
                Element noinput = new Element("noinput");
                field.addContent(noinput);
                audio = new Element("audio");
                noinput.addContent(audio);
                audio.addContent(NOINPUT_DEFAULT_AUDIO);
                noinput.addContent(new Element("reprompt"));
                if (field.getChild("nomatch") == null) {
                    Element nomatch = new Element("nomatch");
                    field.addContent(nomatch);
                    audio = new Element("audio");
                    nomatch.addContent(audio);
                    audio.addContent(NOMATCH_DEFAULT_AUDIO);
                    nomatch.addContent(new Element("reprompt"));
                }
                form.addContent(field);
            }
            if (form.getChildren().size() <= 0) continue;
            result.add(form);
        }
        return result;
    }

    private static List writeTemplate(TemplateDialog realDialog) {
        ArrayList<Element> result = new ArrayList<Element>();
        Iterator i = realDialog.getPages(DeviceType.VOICE).iterator();
        while (i.hasNext()) {
            Page realPage = (Page)i.next();
            PageRegion realRegion = realPage.getRegion(Direction.CENTER);
            boolean condition = false;
            Iterator j = realRegion.getControls().iterator();
            while (j.hasNext()) {
                Control realControl = (Control)j.next();
                Element linkElement = new Element("link");
                String utteranceString = null;
                if (!(realControl instanceof Content)) {
                    if (realControl instanceof Select) {
                        Control nextControl;
                        Control controlToOutput;
                        ArrayList<String> itemTexts = new ArrayList<String>();
                        if (realControl instanceof SelectOne) {
                            controlToOutput = realControl;
                        } else {
                            if (!$assertionsDisabled && ((SelectMany)realControl).getItems().size() != 1) {
                                throw new AssertionError();
                            }
                            controlToOutput = (SelectMany.Item)((SelectMany)realControl).getItems().get(0);
                        }
                        Iterator k = controlToOutput.getVoiceResponseTextList().iterator();
                        while (k.hasNext()) {
                            String text = (String)k.next();
                            if (text.contains(" ")) {
                                itemTexts.add("(" + text.toLowerCase() + ")");
                                continue;
                            }
                            itemTexts.add(text.toLowerCase());
                        }
                        utteranceString = "[" + StringLib.join(itemTexts) + "]";
                        if (j.hasNext() && (nextControl = (Control)j.next()) instanceof Trigger) {
                            NavConnection connection = ((Trigger)nextControl).getOutConnection(DeviceType.VOICE, new InvokeEvent(nextControl), 0);
                            linkElement.setAttribute("next", "#form" + VoiceXMLWriter.writeId(connection.getDest(DeviceType.VOICE).getPage(DeviceType.VOICE)));
                        }
                    } else if (!(realControl instanceof TextInput) && realControl instanceof Trigger) {
                        String responseText = realControl.getVoiceResponseText(0).toLowerCase();
                        utteranceString = responseText.contains(" ") ? "[(" + responseText + ")]" : "[" + responseText + "]";
                        NavConnection connection = ((Trigger)realControl).getOutConnection(DeviceType.VOICE, new InvokeEvent(realControl), 0);
                        linkElement.setAttribute("next", "#form" + VoiceXMLWriter.writeId(connection.getDest(DeviceType.VOICE).getPage(DeviceType.VOICE)));
                    }
                }
                if (linkElement.getAttributeValue("next") == null) continue;
                Element grammar = new Element("grammar");
                grammar.setAttribute("type", "application/x-gsl");
                grammar.setAttribute("mode", "voice");
                grammar.addContent(new CDATA(utteranceString));
                linkElement.addContent(grammar);
                result.add(linkElement);
            }
        }
        return result;
    }

    private static String writeId(InteractionElement realElement) {
        Matcher matcher = INVALID_ID_CHARS.matcher(realElement.getId().toString());
        return "id" + matcher.replaceAll("_");
    }
}

