/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.io;

import edu.berkeley.guir.damask.Damask;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.InteractionElement;
import edu.berkeley.guir.damask.InteractionGraph;
import edu.berkeley.guir.damask.component.Component;
import edu.berkeley.guir.damask.component.ComponentGroup;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.component.Select;
import edu.berkeley.guir.damask.component.SelectMany;
import edu.berkeley.guir.damask.component.SelectOne;
import edu.berkeley.guir.damask.component.Trigger;
import edu.berkeley.guir.damask.connection.NavConnection;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.damask.io.generated.Border;
import edu.berkeley.guir.damask.io.generated.Borders;
import edu.berkeley.guir.damask.io.generated.Bounds;
import edu.berkeley.guir.damask.io.generated.BoundsAndTransform;
import edu.berkeley.guir.damask.io.generated.BoundsAndTransformInRegion;
import edu.berkeley.guir.damask.io.generated.BoundsAndTransforms;
import edu.berkeley.guir.damask.io.generated.BoundsAndTransformsForGroup;
import edu.berkeley.guir.damask.io.generated.ComponentRef;
import edu.berkeley.guir.damask.io.generated.Components;
import edu.berkeley.guir.damask.io.generated.Connection;
import edu.berkeley.guir.damask.io.generated.ConnectionShape;
import edu.berkeley.guir.damask.io.generated.Connections;
import edu.berkeley.guir.damask.io.generated.Content;
import edu.berkeley.guir.damask.io.generated.ControlRef;
import edu.berkeley.guir.damask.io.generated.Controls;
import edu.berkeley.guir.damask.io.generated.Design;
import edu.berkeley.guir.damask.io.generated.Dialog;
import edu.berkeley.guir.damask.io.generated.Dialogs;
import edu.berkeley.guir.damask.io.generated.DisplayMode;
import edu.berkeley.guir.damask.io.generated.DisplayModes;
import edu.berkeley.guir.damask.io.generated.ElementRef;
import edu.berkeley.guir.damask.io.generated.Group;
import edu.berkeley.guir.damask.io.generated.Groups;
import edu.berkeley.guir.damask.io.generated.HomePage;
import edu.berkeley.guir.damask.io.generated.HomePages;
import edu.berkeley.guir.damask.io.generated.HoverOffEvent;
import edu.berkeley.guir.damask.io.generated.HoverOverEvent;
import edu.berkeley.guir.damask.io.generated.ImageContent;
import edu.berkeley.guir.damask.io.generated.InvokeEvent;
import edu.berkeley.guir.damask.io.generated.Item;
import edu.berkeley.guir.damask.io.generated.Items;
import edu.berkeley.guir.damask.io.generated.Lines;
import edu.berkeley.guir.damask.io.generated.MultiState;
import edu.berkeley.guir.damask.io.generated.ObjectFactory;
import edu.berkeley.guir.damask.io.generated.Page;
import edu.berkeley.guir.damask.io.generated.Pages;
import edu.berkeley.guir.damask.io.generated.PatternInstance;
import edu.berkeley.guir.damask.io.generated.PatternInstances;
import edu.berkeley.guir.damask.io.generated.Point;
import edu.berkeley.guir.damask.io.generated.Polyline;
import edu.berkeley.guir.damask.io.generated.Polylines;
import edu.berkeley.guir.damask.io.generated.Prompt;
import edu.berkeley.guir.damask.io.generated.Region;
import edu.berkeley.guir.damask.io.generated.Regions;
import edu.berkeley.guir.damask.io.generated.Response;
import edu.berkeley.guir.damask.io.generated.ResponseLine;
import edu.berkeley.guir.damask.io.generated.SecondaryInvokeEvent;
import edu.berkeley.guir.damask.io.generated.SelectEvent;
import edu.berkeley.guir.damask.io.generated.SelectMany;
import edu.berkeley.guir.damask.io.generated.SelectOne;
import edu.berkeley.guir.damask.io.generated.Significance;
import edu.berkeley.guir.damask.io.generated.Significances;
import edu.berkeley.guir.damask.io.generated.SignificancesForDialog;
import edu.berkeley.guir.damask.io.generated.StateForCondition;
import edu.berkeley.guir.damask.io.generated.States;
import edu.berkeley.guir.damask.io.generated.StatesForDialog;
import edu.berkeley.guir.damask.io.generated.Style;
import edu.berkeley.guir.damask.io.generated.Styles;
import edu.berkeley.guir.damask.io.generated.TemplateRef;
import edu.berkeley.guir.damask.io.generated.TemplateRefs;
import edu.berkeley.guir.damask.io.generated.Templates;
import edu.berkeley.guir.damask.io.generated.TextContent;
import edu.berkeley.guir.damask.io.generated.TextInput;
import edu.berkeley.guir.damask.io.generated.TextSize;
import edu.berkeley.guir.damask.io.generated.TextSizes;
import edu.berkeley.guir.damask.io.generated.Texts;
import edu.berkeley.guir.damask.io.generated.Title;
import edu.berkeley.guir.damask.io.generated.Transform;
import edu.berkeley.guir.damask.io.generated.Trigger;
import edu.berkeley.guir.damask.io.generated.UserEvent;
import edu.berkeley.guir.damask.io.generated.VoiceViewProperties;
import edu.berkeley.guir.damask.pattern.PatternInstanceMember;
import edu.berkeley.guir.damask.userevent.DamaskUserEvent;
import edu.berkeley.guir.damask.view.DamaskAppExceptionHandler;
import edu.berkeley.guir.damask.view.DamaskFrame;
import edu.berkeley.guir.lib.awt.geom.GeomLib;
import edu.berkeley.guir.lib.awt.geom.Polygon2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.xml.bind.Element;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.transform.Result;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public class DamaskWriter {
    private static final Pattern INVALID_ID_CHARS = Pattern.compile("[^\\.\\-\\w]");
    private static Map xmlElements = new HashMap();
    private static ObjectFactory objFactory = new ObjectFactory();
    private static JAXBContext jc = null;
    private static Marshaller marshaller = null;
    static /* synthetic */ Class class$0;

    static {
        try {
            jc = JAXBContext.newInstance("edu.berkeley.guir.damask.io.generated");
            marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
        }
        catch (JAXBException e) {
            DamaskAppExceptionHandler.log(e);
        }
    }

    private DamaskWriter() {
    }

    private static Marshaller getMarshaller() throws JAXBException {
        return marshaller;
    }

    public static void save(InteractionGraph realGraph, DamaskFrame frame, OutputStream outStream) throws JAXBException {
        edu.berkeley.guir.damask.io.generated.Damask damask = DamaskWriter.writeDamask(realGraph, frame);
        DamaskWriter.getMarshaller().marshal((Object)damask, outStream);
    }

    public static void save(InteractionGraph realGraph, DamaskFrame frame, ContentHandler contentHandler) throws JAXBException {
        edu.berkeley.guir.damask.io.generated.Damask damask = DamaskWriter.writeDamask(realGraph, frame);
        DamaskWriter.getMarshaller().marshal((Object)damask, contentHandler);
    }

    public static void save(InteractionGraph realGraph, DamaskFrame frame, Node node) throws JAXBException {
        edu.berkeley.guir.damask.io.generated.Damask damask = DamaskWriter.writeDamask(realGraph, frame);
        DamaskWriter.getMarshaller().marshal((Object)damask, node);
    }

    public static void save(InteractionGraph realGraph, DamaskFrame frame, Result result) throws JAXBException {
        edu.berkeley.guir.damask.io.generated.Damask damask = DamaskWriter.writeDamask(realGraph, frame);
        DamaskWriter.getMarshaller().marshal((Object)damask, result);
    }

    public static void save(InteractionGraph realGraph, DamaskFrame frame, Writer writer) throws JAXBException {
        edu.berkeley.guir.damask.io.generated.Damask damask = DamaskWriter.writeDamask(realGraph, frame);
        DamaskWriter.getMarshaller().marshal((Object)damask, writer);
    }

    private static edu.berkeley.guir.damask.io.generated.Damask writeDamask(InteractionGraph realGraph, DamaskFrame frame) throws JAXBException {
        xmlElements.clear();
        edu.berkeley.guir.damask.io.generated.Damask damask = objFactory.createDamask();
        Design design = objFactory.createDesign();
        damask.setDesign(design);
        Templates templates = objFactory.createTemplates();
        design.setTemplates(templates);
        Iterator i = realGraph.getTemplates().iterator();
        while (i.hasNext()) {
            edu.berkeley.guir.damask.dialog.Dialog realTemplate = (edu.berkeley.guir.damask.dialog.Dialog)i.next();
            templates.getTemplate().add(DamaskWriter.writeDialog(realTemplate));
        }
        Dialogs dialogs = objFactory.createDialogs();
        design.setDialogs(dialogs);
        Iterator i2 = realGraph.getDialogs().iterator();
        while (i2.hasNext()) {
            edu.berkeley.guir.damask.dialog.Dialog realDialog = (edu.berkeley.guir.damask.dialog.Dialog)i2.next();
            dialogs.getDialog().add(DamaskWriter.writeDialog(realDialog));
        }
        HomePages homePages = objFactory.createHomePages();
        design.setHomePages(homePages);
        Iterator<Object> i3 = Damask.getSupportedDeviceTypes().iterator();
        while (i3.hasNext()) {
            DeviceType realDeviceType = (DeviceType)i3.next();
            edu.berkeley.guir.damask.dialog.Page realHomePage = realGraph.getHomePage(realDeviceType);
            if (realHomePage == null) continue;
            HomePage homePage = objFactory.createHomePage();
            homePage.setDeviceType(realDeviceType.toString());
            homePage.setPage(xmlElements.get(realHomePage));
            homePages.getHomePage().add(homePage);
        }
        i3 = xmlElements.keySet().iterator();
        while (i3.hasNext()) {
            Object key = i3.next();
            if (!(key instanceof Control)) continue;
            Control realControl = (Control)key;
            Object control = xmlElements.get(realControl);
            if (realControl.getDialog() == null || !realControl.isVisibleToDeviceType(DeviceType.VOICE)) continue;
            VoiceViewProperties voiceProperties = DamaskWriter.writeVoiceViewProperties(realControl);
            try {
                Class<?> clazz = control.getClass();
                Class[] classArray = new Class[1];
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("edu.berkeley.guir.damask.io.generated.VoiceViewProperties");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz2;
                clazz.getMethod("setVoiceViewProperties", classArray).invoke(control, voiceProperties);
            }
            catch (IllegalArgumentException e) {
                DamaskAppExceptionHandler.log(e);
            }
            catch (SecurityException e) {
                DamaskAppExceptionHandler.log(e);
            }
            catch (IllegalAccessException e) {
                DamaskAppExceptionHandler.log(e);
            }
            catch (InvocationTargetException e) {
                DamaskAppExceptionHandler.log(e);
            }
            catch (NoSuchMethodException e) {
                DamaskAppExceptionHandler.log(e);
            }
        }
        Connections connections = objFactory.createConnections();
        design.setConnections(connections);
        Iterator i4 = realGraph.getConnections().iterator();
        while (i4.hasNext()) {
            edu.berkeley.guir.damask.connection.Connection realConnection = (edu.berkeley.guir.damask.connection.Connection)i4.next();
            connections.getConnection().add(DamaskWriter.writeConnection(realConnection));
        }
        PatternInstances patternInstances = objFactory.createPatternInstances();
        design.setPatternInstances(patternInstances);
        Iterator i5 = realGraph.getPatternInstances().iterator();
        while (i5.hasNext()) {
            edu.berkeley.guir.damask.pattern.PatternInstance realPatternInstance = (edu.berkeley.guir.damask.pattern.PatternInstance)i5.next();
            patternInstances.getPatternInstance().add(DamaskWriter.writePatternInstance(realPatternInstance));
        }
        xmlElements.clear();
        return damask;
    }

    private static Dialog writeDialog(edu.berkeley.guir.damask.dialog.Dialog realDialog) throws JAXBException {
        Group group;
        ComponentGroup realGroup;
        Page page;
        edu.berkeley.guir.damask.dialog.Page realPage;
        Iterator j;
        DeviceType realDeviceType;
        Dialog dialog = objFactory.createDialog();
        xmlElements.put(realDialog, dialog);
        dialog.setId(DamaskWriter.writeId(realDialog));
        dialog.setConditionsCount(DamaskWriter.createBigInteger(realDialog.getNumConditions()));
        BoundsAndTransforms boundsAndTransforms = DamaskWriter.writeBoundsAndTransforms(realDialog);
        if (!boundsAndTransforms.getBoundsAndTransform().isEmpty()) {
            dialog.setBoundsAndTransforms(boundsAndTransforms);
        }
        Controls controls = objFactory.createControls();
        dialog.setControls(controls);
        Pages pages = objFactory.createPages();
        dialog.setPages(pages);
        Iterator i = realDialog.getDeviceTypesVisibleTo().iterator();
        while (i.hasNext()) {
            realDeviceType = (DeviceType)i.next();
            j = realDialog.getPages(realDeviceType).iterator();
            while (j.hasNext()) {
                realPage = (edu.berkeley.guir.damask.dialog.Page)j.next();
                if (realPage.getBounds() == null) continue;
                page = objFactory.createPage();
                xmlElements.put(realPage, page);
                pages.getPage().add(page);
                page.setId(DamaskWriter.writeId(realPage));
                page.setDeviceType(realPage.getDeviceType().toString());
                TemplateRefs templateRefs = objFactory.createTemplateRefs();
                page.setTemplateRefs(templateRefs);
                Iterator k = realPage.getTemplates().iterator();
                while (k.hasNext()) {
                    edu.berkeley.guir.damask.dialog.Page realTemplatePage = (edu.berkeley.guir.damask.dialog.Page)k.next();
                    TemplateRef templateRef = objFactory.createTemplateRef();
                    templateRef.setRef(xmlElements.get(realTemplatePage));
                    templateRefs.getTemplateRef().add(templateRef);
                }
                page.setBounds(DamaskWriter.writeBounds(realPage.getBounds()));
                page.setTransform(DamaskWriter.writeTransform(realPage.getTransform()));
                Title title = objFactory.createTitle();
                page.setTitle(title);
                edu.berkeley.guir.damask.component.Content realTitleContent = realPage.getTitle();
                Content titleContent = DamaskWriter.writeContent(realTitleContent);
                title.setContent(titleContent);
                titleContent.setVoiceViewProperties(DamaskWriter.writeVoiceViewProperties(realTitleContent));
            }
        }
        i = realDialog.getDeviceTypesVisibleTo().iterator();
        while (i.hasNext()) {
            realDeviceType = (DeviceType)i.next();
            j = realDialog.getPages(realDeviceType).iterator();
            while (j.hasNext()) {
                realPage = (edu.berkeley.guir.damask.dialog.Page)j.next();
                page = (Page)xmlElements.get(realPage);
                if (page == null) continue;
                DamaskWriter.addControlsToPage(realPage, page, controls);
            }
        }
        Groups groups = objFactory.createGroups();
        dialog.setGroups(groups);
        Iterator i2 = realDialog.getGroups().iterator();
        while (i2.hasNext()) {
            realGroup = (ComponentGroup)i2.next();
            group = objFactory.createGroup();
            xmlElements.put(realGroup, group);
            groups.getGroup().add(group);
            group.setId(DamaskWriter.writeId(realGroup));
            group.setBoundsAndTransformsForGroup(DamaskWriter.writeBoundsAndTransformsForGroup(realGroup));
        }
        i2 = realDialog.getGroups().iterator();
        while (i2.hasNext()) {
            realGroup = (ComponentGroup)i2.next();
            group = (Group)xmlElements.get(realGroup);
            Components components = objFactory.createComponents();
            group.setComponents(components);
            Iterator j2 = realGroup.getChildren().iterator();
            while (j2.hasNext()) {
                Component realComponent = (Component)j2.next();
                ComponentRef componentRef = objFactory.createComponentRef();
                componentRef.setRef(xmlElements.get(realComponent));
                components.getComponentRef().add(componentRef);
            }
        }
        return dialog;
    }

    private static String writeId(InteractionElement realElement) {
        Matcher matcher = INVALID_ID_CHARS.matcher(realElement.getId().toString());
        return matcher.replaceAll("_");
    }

    private static BigInteger createBigInteger(int num) {
        return new BigInteger(Integer.toString(num));
    }

    private static Bounds writeBounds(Rectangle2D realBounds) throws JAXBException {
        Bounds bounds = objFactory.createBounds();
        bounds.setX(realBounds.getX());
        bounds.setY(realBounds.getY());
        bounds.setWidth(realBounds.getWidth());
        bounds.setHeight(realBounds.getHeight());
        return bounds;
    }

    private static Transform writeTransform(AffineTransform realTransform) throws JAXBException {
        Transform transform = objFactory.createTransform();
        transform.setScaleX(realTransform.getScaleX());
        transform.setScaleY(realTransform.getScaleY());
        transform.setShearX(realTransform.getShearX());
        transform.setShearY(realTransform.getShearY());
        transform.setTranslateX(realTransform.getTranslateX());
        transform.setTranslateY(realTransform.getTranslateY());
        return transform;
    }

    private static void addControlsToPage(edu.berkeley.guir.damask.dialog.Page realPage, Page page, Controls controls) throws JAXBException {
        Regions regions = objFactory.createRegions();
        page.setRegions(regions);
        Iterator i = realPage.getRegions().iterator();
        while (i.hasNext()) {
            PageRegion realRegion = (PageRegion)i.next();
            Region region = objFactory.createRegion();
            xmlElements.put(realRegion, region);
            regions.getRegion().add(region);
            region.setName(realRegion.getName().toString());
            region.setInset(DamaskWriter.createBigInteger(realRegion.getInset()));
            List regionControls = region.getControlRef();
            Iterator j = realRegion.getControls().iterator();
            while (j.hasNext()) {
                Control realControl = (Control)j.next();
                Object control = xmlElements.get(realControl);
                if (control == null) {
                    control = DamaskWriter.writeControl(realControl);
                    controls.getControl().add(control);
                    xmlElements.put(realControl, control);
                }
                ControlRef controlRef = objFactory.createControlRef();
                controlRef.setRef(control);
                regionControls.add(controlRef);
            }
        }
    }

    private static Object writeControl(Control realControl) throws JAXBException {
        Element control;
        if (realControl instanceof edu.berkeley.guir.damask.component.Content) {
            control = objFactory.createControlsContent();
            DamaskWriter.writeIntoContent((edu.berkeley.guir.damask.component.Content)realControl, control);
        } else if (realControl instanceof edu.berkeley.guir.damask.component.TextInput) {
            control = objFactory.createControlsTextInput();
            DamaskWriter.writeIntoTextInput((edu.berkeley.guir.damask.component.TextInput)realControl, (TextInput)((Object)control));
        } else if (realControl instanceof edu.berkeley.guir.damask.component.Trigger) {
            control = objFactory.createControlsTrigger();
            DamaskWriter.writeIntoTrigger((edu.berkeley.guir.damask.component.Trigger)realControl, (Trigger)((Object)control));
        } else if (realControl instanceof edu.berkeley.guir.damask.component.SelectOne) {
            control = objFactory.createControlsSelectOne();
            DamaskWriter.writeIntoSelectOne((edu.berkeley.guir.damask.component.SelectOne)realControl, (SelectOne)((Object)control));
        } else if (realControl instanceof edu.berkeley.guir.damask.component.SelectMany) {
            control = objFactory.createControlsSelectMany();
            DamaskWriter.writeIntoSelectMany((edu.berkeley.guir.damask.component.SelectMany)realControl, (SelectMany)((Object)control));
        } else {
            control = null;
        }
        return control;
    }

    private static Content writeContent(edu.berkeley.guir.damask.component.Content realContent) throws JAXBException {
        Content content = objFactory.createContent();
        DamaskWriter.writeIntoContent(realContent, content);
        return content;
    }

    private static void writeIntoContent(edu.berkeley.guir.damask.component.Content realContent, Content content) throws JAXBException {
        Iterator i;
        Collection realStrokes;
        BufferedImage realImage;
        xmlElements.put(realContent, content);
        content.setId(DamaskWriter.writeId(realContent));
        content.setBoundsAndTransforms(DamaskWriter.writeBoundsAndTransforms(realContent));
        content.setStates(DamaskWriter.writeStates(realContent));
        content.setSignificances(DamaskWriter.writeSignificances(realContent));
        String realText = realContent.getText();
        if (realText != null) {
            TextContent textContent = objFactory.createTextContent();
            textContent.setText(realText);
            TextSizes textSizes = objFactory.createTextSizes();
            textContent.setTextSizes(textSizes);
            Iterator i2 = realContent.getDeviceTypesVisibleTo().iterator();
            while (i2.hasNext()) {
                DeviceType realDeviceType = (DeviceType)i2.next();
                TextSize textSize = objFactory.createTextSize();
                textSize.setDeviceType(realDeviceType.toString());
                textSize.setSize(DamaskWriter.createBigInteger(realContent.getTextSize(realDeviceType)));
                textSizes.getTextSize().add(textSize);
            }
            if (realContent.getVoicePromptText() != null) {
                textContent.setVoiceText(realContent.getVoicePromptText());
            }
            content.setTextContent(textContent);
        }
        if ((realImage = realContent.getImage()) != null) {
            try {
                ImageContent imageContent = objFactory.createImageContent();
                imageContent.setType("image/png");
                imageContent.setEncoding("base64");
                ByteArrayOutputStream imageOutStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)realImage, "png", imageOutStream);
                byte[] imageData = imageOutStream.toByteArray();
                String imageDataStr = new String(Base64.encodeBase64((byte[])imageData));
                imageContent.setImageData(imageDataStr);
                content.setImageContent(imageContent);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!(realStrokes = realContent.getStrokes()).isEmpty()) {
            Polylines strokesContent = objFactory.createPolylines();
            i = realStrokes.iterator();
            while (i.hasNext()) {
                GeneralPath realStroke = (GeneralPath)i.next();
                Polyline polyline = DamaskWriter.writePolyline(realStroke);
                strokesContent.getPolyline().add(polyline);
            }
            content.setStrokesContent(strokesContent);
        }
        DisplayModes displayModes = objFactory.createDisplayModes();
        content.setDisplayModes(displayModes);
        i = realContent.getDeviceTypesVisibleTo().iterator();
        while (i.hasNext()) {
            DeviceType realDeviceType = (DeviceType)i.next();
            Content.DisplayMode realDisplayMode = realContent.getPreferredDisplayMode(realDeviceType);
            DisplayMode displayMode = objFactory.createDisplayMode();
            displayMode.setDeviceType(realDeviceType.toString());
            displayMode.setMode(realDisplayMode.toString());
            displayModes.getDisplayMode().add(displayMode);
        }
    }

    private static void writeIntoTextInput(edu.berkeley.guir.damask.component.TextInput realTextInput, TextInput textInput) throws JAXBException {
        xmlElements.put(realTextInput, textInput);
        textInput.setId(DamaskWriter.writeId(realTextInput));
        textInput.setBoundsAndTransforms(DamaskWriter.writeBoundsAndTransforms(realTextInput));
        textInput.setStates(DamaskWriter.writeStates(realTextInput));
        textInput.setSignificances(DamaskWriter.writeSignificances(realTextInput));
        Borders borders = objFactory.createBorders();
        Iterator i = realTextInput.getDeviceTypesVisibleTo().iterator();
        while (i.hasNext()) {
            DeviceType realDeviceType = (DeviceType)i.next();
            GeneralPath realBorder = realTextInput.getBorder(realDeviceType);
            if (realBorder == null) continue;
            Border border = objFactory.createBorder();
            border.setDeviceType(realDeviceType.toString());
            border.setPolyline(DamaskWriter.writePolyline(realBorder));
            borders.getBorder().add(border);
        }
        if (!borders.getBorder().isEmpty()) {
            textInput.setBorders(borders);
        }
    }

    private static void writeIntoTrigger(edu.berkeley.guir.damask.component.Trigger realTrigger, Trigger trigger) throws JAXBException {
        xmlElements.put(realTrigger, trigger);
        trigger.setId(DamaskWriter.writeId(realTrigger));
        trigger.setBoundsAndTransforms(DamaskWriter.writeBoundsAndTransforms(realTrigger));
        trigger.setStates(DamaskWriter.writeStates(realTrigger));
        trigger.setSignificances(DamaskWriter.writeSignificances(realTrigger));
        Borders borders = objFactory.createBorders();
        Iterator i = realTrigger.getDeviceTypesVisibleTo().iterator();
        while (i.hasNext()) {
            DeviceType realDeviceType = (DeviceType)i.next();
            GeneralPath realBorder = realTrigger.getBorder(realDeviceType);
            if (realBorder == null) continue;
            Border border = objFactory.createBorder();
            border.setDeviceType(realDeviceType.toString());
            border.setPolyline(DamaskWriter.writePolyline(realBorder));
            borders.getBorder().add(border);
        }
        if (!borders.getBorder().isEmpty()) {
            trigger.setBorders(borders);
        }
        Styles styles = objFactory.createStyles();
        Iterator i2 = realTrigger.getDeviceTypesVisibleTo().iterator();
        while (i2.hasNext()) {
            DeviceType realDeviceType = (DeviceType)i2.next();
            Trigger.Style realStyle = realTrigger.getStyle(realDeviceType);
            if (realStyle == null) continue;
            Style style = objFactory.createStyle();
            style.setDeviceType(realDeviceType.toString());
            style.setName(realStyle.toString());
            styles.getStyle().add(style);
        }
        if (!styles.getStyle().isEmpty()) {
            trigger.setStyles(styles);
        }
        trigger.setContent(DamaskWriter.writeContent(realTrigger.getContent()));
    }

    private static void writeIntoSelectOne(edu.berkeley.guir.damask.component.SelectOne realSelectOne, SelectOne selectOne) throws JAXBException {
        xmlElements.put(realSelectOne, selectOne);
        selectOne.setId(DamaskWriter.writeId(realSelectOne));
        selectOne.setBoundsAndTransforms(DamaskWriter.writeBoundsAndTransforms(realSelectOne));
        Styles styles = objFactory.createStyles();
        Iterator i = realSelectOne.getDeviceTypesVisibleTo().iterator();
        while (i.hasNext()) {
            DeviceType realDeviceType = (DeviceType)i.next();
            Select.Style realStyle = realSelectOne.getStyle(realDeviceType);
            if (realStyle == null) continue;
            Style style = objFactory.createStyle();
            style.setDeviceType(realDeviceType.toString());
            style.setName(realStyle.toString());
            styles.getStyle().add(style);
        }
        if (!styles.getStyle().isEmpty()) {
            selectOne.setStyles(styles);
        }
        Items items = objFactory.createItems();
        Iterator i2 = realSelectOne.getItems().iterator();
        while (i2.hasNext()) {
            SelectOne.Item realItem = (SelectOne.Item)i2.next();
            Item item = DamaskWriter.writeSelectItem(realItem);
            items.getItem().add(item);
        }
        selectOne.setItems(items);
        selectOne.setStates(DamaskWriter.writeStates(realSelectOne));
        selectOne.setSignificances(DamaskWriter.writeSignificances(realSelectOne));
    }

    private static void writeIntoSelectMany(edu.berkeley.guir.damask.component.SelectMany realSelectMany, SelectMany selectMany) throws JAXBException {
        xmlElements.put(realSelectMany, selectMany);
        selectMany.setId(DamaskWriter.writeId(realSelectMany));
        selectMany.setBoundsAndTransforms(DamaskWriter.writeBoundsAndTransforms(realSelectMany));
        Styles styles = objFactory.createStyles();
        Iterator i = realSelectMany.getDeviceTypesVisibleTo().iterator();
        while (i.hasNext()) {
            DeviceType realDeviceType = (DeviceType)i.next();
            Select.Style realStyle = realSelectMany.getStyle(realDeviceType);
            if (realStyle == null) continue;
            Style style = objFactory.createStyle();
            style.setDeviceType(realDeviceType.toString());
            style.setName(realStyle.toString());
            styles.getStyle().add(style);
        }
        if (!styles.getStyle().isEmpty()) {
            selectMany.setStyles(styles);
        }
        Items items = objFactory.createItems();
        Iterator i2 = realSelectMany.getItems().iterator();
        while (i2.hasNext()) {
            SelectMany.Item realItem = (SelectMany.Item)i2.next();
            Item item = DamaskWriter.writeSelectItem(realItem);
            items.getItem().add(item);
        }
        selectMany.setItems(items);
        selectMany.setStates(DamaskWriter.writeStates(realSelectMany));
        selectMany.setSignificances(DamaskWriter.writeSignificances(realSelectMany));
    }

    private static Item writeSelectItem(Select.Item realSelectItem) throws JAXBException {
        Item item = objFactory.createItem();
        xmlElements.put(realSelectItem, item);
        item.setId(DamaskWriter.writeId(realSelectItem));
        item.setBoundsAndTransforms(DamaskWriter.writeBoundsAndTransforms(realSelectItem));
        item.setContent(DamaskWriter.writeContent(realSelectItem.getContent()));
        return item;
    }

    private static BoundsAndTransforms writeBoundsAndTransforms(InteractionElement realElement) throws JAXBException {
        BoundsAndTransforms boundsAndTransforms = objFactory.createBoundsAndTransforms();
        Iterator i = realElement.getDeviceTypesVisibleTo().iterator();
        while (i.hasNext()) {
            DeviceType realDeviceType = (DeviceType)i.next();
            if (realDeviceType == DeviceType.VOICE && realElement instanceof Component) continue;
            BoundsAndTransform boundsAndTransform = objFactory.createBoundsAndTransform();
            boundsAndTransform.setDeviceType(realDeviceType.toString());
            boundsAndTransform.setBounds(DamaskWriter.writeBounds(realElement.getBounds(realDeviceType)));
            boundsAndTransform.setTransform(DamaskWriter.writeTransform(realElement.getTransform(realDeviceType)));
            boundsAndTransforms.getBoundsAndTransform().add(boundsAndTransform);
        }
        return boundsAndTransforms;
    }

    private static BoundsAndTransformsForGroup writeBoundsAndTransformsForGroup(ComponentGroup realGroup) throws JAXBException {
        BoundsAndTransformsForGroup boundsAndTransformsForGroup = objFactory.createBoundsAndTransformsForGroup();
        Iterator i = realGroup.getPageRegions().iterator();
        while (i.hasNext()) {
            PageRegion realRegion = (PageRegion)i.next();
            BoundsAndTransformInRegion boundsAndTransformInRegion = objFactory.createBoundsAndTransformInRegion();
            boundsAndTransformInRegion.setPage(xmlElements.get(realRegion.getPage()));
            boundsAndTransformInRegion.setRegion(realRegion.getName().toString());
            boundsAndTransformInRegion.setBounds(DamaskWriter.writeBounds(realGroup.getBoundsInPageRegion(realRegion)));
            boundsAndTransformInRegion.setTransform(DamaskWriter.writeTransform(realGroup.getTransformInPageRegion(realRegion)));
            boundsAndTransformsForGroup.getBoundsAndTransformInRegion().add(boundsAndTransformInRegion);
        }
        return boundsAndTransformsForGroup;
    }

    private static VoiceViewProperties writeVoiceViewProperties(Control realControl) throws JAXBException {
        List textList;
        VoiceViewProperties props = objFactory.createVoiceViewProperties();
        Rectangle2D promptBounds = realControl.getVoicePromptBounds();
        if (promptBounds != null) {
            Prompt prompt = objFactory.createPrompt();
            props.setPrompt(prompt);
            prompt.setBounds(DamaskWriter.writeBounds(promptBounds));
            prompt.setText(realControl.getVoicePromptText());
        }
        boolean hasResponse = false;
        Response response = objFactory.createResponse();
        Lines lines = objFactory.createLines();
        response.setLines(lines);
        edu.berkeley.guir.damask.dialog.Dialog dialogOfRealControl = realControl.getDialog();
        int numConditions = dialogOfRealControl == null ? 0 : dialogOfRealControl.getNumConditions();
        int i = 0;
        while (i < numConditions) {
            Line2D realLine = realControl.getVoiceResponseLine(i);
            if (realLine != null) {
                hasResponse = true;
                ResponseLine line = objFactory.createResponseLine();
                line.setCondition(DamaskWriter.createBigInteger(i));
                line.setX1(realLine.getX1());
                line.setY1(realLine.getY1());
                line.setX2(realLine.getX2());
                line.setY2(realLine.getY2());
                lines.getResponseLine().add(line);
            }
            ++i;
        }
        if (realControl instanceof SelectMany.Item && !(textList = realControl.getVoiceResponseTextList()).isEmpty()) {
            Texts texts = objFactory.createTexts();
            int i2 = 0;
            int n = textList.size();
            while (i2 < n) {
                texts.getText().add(textList.get(i2));
                ++i2;
            }
            response.setTexts(texts);
        }
        if (hasResponse) {
            props.setResponse(response);
        }
        props.setTransform(DamaskWriter.writeTransform(realControl.getTransform(DeviceType.VOICE)));
        return props;
    }

    private static States writeStates(Control realControl) throws JAXBException {
        States states = objFactory.createStates();
        edu.berkeley.guir.damask.dialog.Dialog realDialog = realControl.getDialog();
        if (realDialog != null) {
            StatesForDialog statesForDialog = objFactory.createStatesForDialog();
            statesForDialog.setDialog(xmlElements.get(realDialog));
            int j = 0;
            int n = realDialog.getNumConditions();
            while (j < n) {
                Object realState = realControl.getStateForCondition(realDialog, j);
                if (realState != null) {
                    StateForCondition condition = objFactory.createStateForCondition();
                    condition.setConditionNum(DamaskWriter.createBigInteger(j));
                    if (realState instanceof Collection) {
                        MultiState multiState = objFactory.createMultiState();
                        Iterator k = ((Collection)realState).iterator();
                        while (k.hasNext()) {
                            Object oneRealState = k.next();
                            multiState.getState().add(DamaskWriter.writeState(oneRealState));
                        }
                        condition.setMultiState(multiState);
                    } else if (realState instanceof Integer) {
                        condition.setIntegerState(objFactory.createStateIntegerState(new BigInteger(((Integer)realState).toString())));
                    } else if (realState instanceof Boolean) {
                        condition.setBooleanState(objFactory.createStateBooleanState((Boolean)realState));
                    } else if (realState instanceof String) {
                        condition.setStringState(objFactory.createStateStringState((String)realState));
                    } else if (realState instanceof InteractionElement) {
                        condition.setIDREFState(objFactory.createStateIDREFState(xmlElements.get(realState)));
                    }
                    statesForDialog.getStateForCondition().add(condition);
                }
                ++j;
            }
            states.getStatesForDialog().add(statesForDialog);
        }
        return states;
    }

    private static Object writeState(Object realState) throws JAXBException {
        Element state = realState instanceof Integer ? objFactory.createStateIntegerState(new BigInteger(((Integer)realState).toString())) : (realState instanceof Boolean ? objFactory.createStateBooleanState((Boolean)realState) : (realState instanceof String ? objFactory.createStateStringState((String)realState) : (realState instanceof InteractionElement ? objFactory.createStateIDREFState(xmlElements.get(realState)) : null)));
        return state;
    }

    private static Significances writeSignificances(Control realControl) throws JAXBException {
        Significances sigs = objFactory.createSignificances();
        edu.berkeley.guir.damask.dialog.Dialog realDialog = realControl.getDialog();
        if (realDialog != null) {
            SignificancesForDialog sigsForDialog = objFactory.createSignificancesForDialog();
            sigsForDialog.setDialog(xmlElements.get(realDialog));
            int j = 0;
            int n = realDialog.getNumConditions();
            while (j < n) {
                Significance sig = objFactory.createSignificance();
                sig.setCondition(DamaskWriter.createBigInteger(j));
                sig.setValue(realControl.isStateSignificantForCondition(realDialog, j));
                sigsForDialog.getSignificance().add(sig);
                ++j;
            }
            sigs.getSignificancesForDialog().add(sigsForDialog);
        }
        return sigs;
    }

    private static Polyline writePolyline(GeneralPath genPath) throws JAXBException {
        Polygon2D realPoly = GeomLib.pathIteratorToPolygon2D(genPath.getPathIterator(null));
        Polyline polyline = objFactory.createPolyline();
        int i = 0;
        int n = realPoly.npoints;
        while (i < n) {
            Point point = objFactory.createPoint();
            point.setX(realPoly.xpoints[i]);
            point.setY(realPoly.ypoints[i]);
            polyline.getPoint().add(point);
            ++i;
        }
        return polyline;
    }

    private static Connection writeConnection(edu.berkeley.guir.damask.connection.Connection realConnection) throws JAXBException {
        DeviceType origRealDeviceType = realConnection.getOrigSpecifiedDeviceType();
        Connection connection = objFactory.createConnection();
        xmlElements.put(realConnection, connection);
        connection.setId(DamaskWriter.writeId(realConnection));
        connection.setOrigDeviceType(origRealDeviceType.toString());
        connection.setForAllDeviceTypes(realConnection.isForAllDeviceTypes());
        connection.setSourceForOrigDeviceType(xmlElements.get(realConnection.getConnectionSource(origRealDeviceType)));
        connection.setDestForOrigDeviceType(xmlElements.get(realConnection.getConnectionDest(origRealDeviceType)));
        if (realConnection instanceof NavConnection) {
            NavConnection realNavConnection = (NavConnection)realConnection;
            connection.setUserEvent(DamaskWriter.writeUserEvent(realNavConnection.getUserEvent()));
            connection.setCondition(DamaskWriter.createBigInteger(realNavConnection.getCondition()));
        }
        Iterator i = realConnection.getDeviceTypesVisibleTo().iterator();
        while (i.hasNext()) {
            DeviceType realDeviceType = (DeviceType)i.next();
            GeneralPath realShape = realConnection.getShape(realDeviceType);
            if (realShape == null) continue;
            ConnectionShape shape = objFactory.createConnectionShape();
            connection.getConnectionShape().add(shape);
            shape.setDeviceType(realDeviceType.toString());
            shape.setPolyline(DamaskWriter.writePolyline(realShape));
        }
        return connection;
    }

    private static UserEvent writeUserEvent(DamaskUserEvent realUserEvent) throws JAXBException {
        Element userEventElement;
        if (realUserEvent instanceof edu.berkeley.guir.damask.userevent.HoverOverEvent) {
            userEventElement = objFactory.createUserEventHoverOverEvent();
            ((HoverOverEvent)((Object)userEventElement)).setSource(xmlElements.get(realUserEvent.getSource()));
        } else if (realUserEvent instanceof edu.berkeley.guir.damask.userevent.HoverOffEvent) {
            userEventElement = objFactory.createUserEventHoverOffEvent();
            ((HoverOffEvent)((Object)userEventElement)).setSource(xmlElements.get(realUserEvent.getSource()));
        } else if (realUserEvent instanceof edu.berkeley.guir.damask.userevent.InvokeEvent) {
            userEventElement = objFactory.createUserEventInvokeEvent();
            ((InvokeEvent)((Object)userEventElement)).setSource(xmlElements.get(realUserEvent.getSource()));
        } else if (realUserEvent instanceof edu.berkeley.guir.damask.userevent.SecondaryInvokeEvent) {
            userEventElement = objFactory.createUserEventSecondaryInvokeEvent();
            ((SecondaryInvokeEvent)((Object)userEventElement)).setSource(xmlElements.get(realUserEvent.getSource()));
        } else if (realUserEvent instanceof edu.berkeley.guir.damask.userevent.SelectEvent) {
            userEventElement = objFactory.createUserEventSelectEvent();
            ((SelectEvent)((Object)userEventElement)).setSource(xmlElements.get(realUserEvent.getSource()));
        } else {
            userEventElement = null;
        }
        UserEvent userEvent = objFactory.createUserEvent();
        userEvent.setUserEvent(userEventElement);
        return userEvent;
    }

    private static PatternInstance writePatternInstance(edu.berkeley.guir.damask.pattern.PatternInstance realPatternInstance) throws JAXBException {
        PatternInstance patternInstance = objFactory.createPatternInstance();
        xmlElements.put(realPatternInstance, patternInstance);
        patternInstance.setId(DamaskWriter.writeId(realPatternInstance));
        patternInstance.setPatternID(realPatternInstance.getPattern().getID());
        patternInstance.setCollectionID(realPatternInstance.getPattern().getCollectionID());
        Iterator i = realPatternInstance.getMembers().iterator();
        while (i.hasNext()) {
            PatternInstanceMember realMember = (PatternInstanceMember)i.next();
            ElementRef elementRef = objFactory.createElementRef();
            Object element = xmlElements.get(realMember);
            if (element == null) continue;
            elementRef.setRef(element);
            patternInstance.getElementRef().add(elementRef);
        }
        return patternInstance;
    }
}

