/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.io;

import edu.berkeley.guir.damask.Damask;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.Direction;
import edu.berkeley.guir.damask.InteractionElement;
import edu.berkeley.guir.damask.InteractionGraph;
import edu.berkeley.guir.damask.component.Component;
import edu.berkeley.guir.damask.component.ComponentGroup;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.component.Select;
import edu.berkeley.guir.damask.component.SelectMany;
import edu.berkeley.guir.damask.component.SelectOne;
import edu.berkeley.guir.damask.component.Trigger;
import edu.berkeley.guir.damask.connection.ConnectionDest;
import edu.berkeley.guir.damask.connection.NavConnection;
import edu.berkeley.guir.damask.connection.OrgConnection;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.damask.dialog.TemplateDialog;
import edu.berkeley.guir.damask.io.generated.Border;
import edu.berkeley.guir.damask.io.generated.Borders;
import edu.berkeley.guir.damask.io.generated.Bounds;
import edu.berkeley.guir.damask.io.generated.BoundsAndTransform;
import edu.berkeley.guir.damask.io.generated.BoundsAndTransformInRegion;
import edu.berkeley.guir.damask.io.generated.BoundsAndTransforms;
import edu.berkeley.guir.damask.io.generated.BoundsAndTransformsForGroup;
import edu.berkeley.guir.damask.io.generated.ComponentRef;
import edu.berkeley.guir.damask.io.generated.Connection;
import edu.berkeley.guir.damask.io.generated.ConnectionShape;
import edu.berkeley.guir.damask.io.generated.Content;
import edu.berkeley.guir.damask.io.generated.ControlRef;
import edu.berkeley.guir.damask.io.generated.Design;
import edu.berkeley.guir.damask.io.generated.Dialog;
import edu.berkeley.guir.damask.io.generated.DisplayMode;
import edu.berkeley.guir.damask.io.generated.ElementRef;
import edu.berkeley.guir.damask.io.generated.Group;
import edu.berkeley.guir.damask.io.generated.HomePage;
import edu.berkeley.guir.damask.io.generated.HoverOffEvent;
import edu.berkeley.guir.damask.io.generated.HoverOverEvent;
import edu.berkeley.guir.damask.io.generated.ImageContent;
import edu.berkeley.guir.damask.io.generated.InvokeEvent;
import edu.berkeley.guir.damask.io.generated.Item;
import edu.berkeley.guir.damask.io.generated.Items;
import edu.berkeley.guir.damask.io.generated.MultiState;
import edu.berkeley.guir.damask.io.generated.Page;
import edu.berkeley.guir.damask.io.generated.PatternInstance;
import edu.berkeley.guir.damask.io.generated.Point;
import edu.berkeley.guir.damask.io.generated.Polyline;
import edu.berkeley.guir.damask.io.generated.Polylines;
import edu.berkeley.guir.damask.io.generated.Prompt;
import edu.berkeley.guir.damask.io.generated.Region;
import edu.berkeley.guir.damask.io.generated.Response;
import edu.berkeley.guir.damask.io.generated.ResponseLine;
import edu.berkeley.guir.damask.io.generated.SecondaryInvokeEvent;
import edu.berkeley.guir.damask.io.generated.SelectEvent;
import edu.berkeley.guir.damask.io.generated.SelectMany;
import edu.berkeley.guir.damask.io.generated.SelectOne;
import edu.berkeley.guir.damask.io.generated.Significance;
import edu.berkeley.guir.damask.io.generated.Significances;
import edu.berkeley.guir.damask.io.generated.SignificancesForDialog;
import edu.berkeley.guir.damask.io.generated.StateBooleanState;
import edu.berkeley.guir.damask.io.generated.StateForCondition;
import edu.berkeley.guir.damask.io.generated.StateIDREFState;
import edu.berkeley.guir.damask.io.generated.StateIntegerState;
import edu.berkeley.guir.damask.io.generated.StateStringState;
import edu.berkeley.guir.damask.io.generated.States;
import edu.berkeley.guir.damask.io.generated.StatesForDialog;
import edu.berkeley.guir.damask.io.generated.Style;
import edu.berkeley.guir.damask.io.generated.Styles;
import edu.berkeley.guir.damask.io.generated.TemplateRef;
import edu.berkeley.guir.damask.io.generated.TextContent;
import edu.berkeley.guir.damask.io.generated.TextInput;
import edu.berkeley.guir.damask.io.generated.TextSize;
import edu.berkeley.guir.damask.io.generated.Transform;
import edu.berkeley.guir.damask.io.generated.Trigger;
import edu.berkeley.guir.damask.io.generated.UserEvent;
import edu.berkeley.guir.damask.io.generated.VoiceViewProperties;
import edu.berkeley.guir.damask.pattern.Pattern;
import edu.berkeley.guir.damask.pattern.PatternInstanceMember;
import edu.berkeley.guir.damask.pattern.PatternLibrary;
import edu.berkeley.guir.damask.pattern.PatternSolution;
import edu.berkeley.guir.damask.userevent.DamaskUserEvent;
import edu.berkeley.guir.damask.view.DamaskAppExceptionHandler;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.xml.bind.Element;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class DamaskReader {
    private static Map realElements;
    private static Map origResponseLines;
    private static JAXBContext jc;
    private static Unmarshaller unmarshaller;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.io.DamaskReader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        realElements = new HashMap();
        origResponseLines = new HashMap();
        jc = null;
        unmarshaller = null;
        try {
            jc = JAXBContext.newInstance("edu.berkeley.guir.damask.io.generated");
            unmarshaller = jc.createUnmarshaller();
        }
        catch (JAXBException e) {
            DamaskAppExceptionHandler.log(e);
        }
    }

    private DamaskReader() {
    }

    private static Unmarshaller getUnmarshaller() throws JAXBException {
        return unmarshaller;
    }

    public static InteractionGraph open(File f) throws JAXBException {
        edu.berkeley.guir.damask.io.generated.Damask d = (edu.berkeley.guir.damask.io.generated.Damask)DamaskReader.getUnmarshaller().unmarshal(f);
        return DamaskReader.createRealInteractionGraph(d);
    }

    public static InteractionGraph open(InputSource source) throws JAXBException {
        edu.berkeley.guir.damask.io.generated.Damask d = (edu.berkeley.guir.damask.io.generated.Damask)DamaskReader.getUnmarshaller().unmarshal(source);
        return DamaskReader.createRealInteractionGraph(d);
    }

    public static InteractionGraph open(InputStream is) throws JAXBException {
        edu.berkeley.guir.damask.io.generated.Damask d = (edu.berkeley.guir.damask.io.generated.Damask)DamaskReader.getUnmarshaller().unmarshal(is);
        return DamaskReader.createRealInteractionGraph(d);
    }

    public static InteractionGraph open(Node node) throws JAXBException {
        edu.berkeley.guir.damask.io.generated.Damask d = (edu.berkeley.guir.damask.io.generated.Damask)DamaskReader.getUnmarshaller().unmarshal(node);
        return DamaskReader.createRealInteractionGraph(d);
    }

    public static InteractionGraph open(Source source) throws JAXBException {
        edu.berkeley.guir.damask.io.generated.Damask d = (edu.berkeley.guir.damask.io.generated.Damask)DamaskReader.getUnmarshaller().unmarshal(source);
        return DamaskReader.createRealInteractionGraph(d);
    }

    public static InteractionGraph open(URL url) throws JAXBException {
        edu.berkeley.guir.damask.io.generated.Damask d = (edu.berkeley.guir.damask.io.generated.Damask)DamaskReader.getUnmarshaller().unmarshal(url);
        return DamaskReader.createRealInteractionGraph(d);
    }

    public static PatternSolution open(URL url, Pattern realPatternForSolution) throws JAXBException {
        edu.berkeley.guir.damask.io.generated.Damask d = (edu.berkeley.guir.damask.io.generated.Damask)DamaskReader.getUnmarshaller().unmarshal(url);
        return (PatternSolution)DamaskReader.createRealInteractionGraph(d, realPatternForSolution);
    }

    private static InteractionGraph createRealInteractionGraph(edu.berkeley.guir.damask.io.generated.Damask damask) {
        return DamaskReader.createRealInteractionGraph(damask, null);
    }

    private static InteractionGraph createRealInteractionGraph(edu.berkeley.guir.damask.io.generated.Damask damask, Pattern realPatternForSolution) {
        Iterator j;
        realElements.clear();
        InteractionGraph realGraph = realPatternForSolution == null ? new InteractionGraph() : realPatternForSolution.getSolution();
        Design design = damask.getDesign();
        realGraph.removeTemplate(realGraph.getDefaultTemplate());
        Iterator i = design.getTemplates().getTemplate().iterator();
        while (i.hasNext()) {
            Dialog template = (Dialog)i.next();
            realGraph.addTemplate(DamaskReader.getRealTemplateDialog(template));
        }
        i = design.getDialogs().getDialog().iterator();
        while (i.hasNext()) {
            Dialog dialog = (Dialog)i.next();
            realGraph.add(DamaskReader.getRealDialog(dialog), false);
        }
        i = design.getHomePages().getHomePage().iterator();
        while (i.hasNext()) {
            HomePage homePage = (HomePage)i.next();
            DeviceType realDeviceType = DamaskReader.getRealDeviceType(homePage.getDeviceType());
            edu.berkeley.guir.damask.dialog.Page realPage = (edu.berkeley.guir.damask.dialog.Page)realElements.get(homePage.getPage());
            if (realPage == null) {
                j = realGraph.getDialogs().iterator();
                while (j.hasNext()) {
                    edu.berkeley.guir.damask.dialog.Dialog realDialog = (edu.berkeley.guir.damask.dialog.Dialog)j.next();
                    if (!realDialog.isVisibleToDeviceType(realDeviceType)) continue;
                    realPage = realDialog.getFirstPage(realDeviceType);
                }
            }
            realGraph.setHomePage(realDeviceType, realPage);
        }
        i = design.getConnections().getConnection().iterator();
        while (i.hasNext()) {
            Connection connection = (Connection)i.next();
            edu.berkeley.guir.damask.connection.Connection realConnection = DamaskReader.getRealConnection(connection);
            realGraph.add(realConnection);
            Iterator j2 = realConnection.getDeviceTypesVisibleTo().iterator();
            while (j2.hasNext()) {
                DeviceType aRealDeviceType = (DeviceType)j2.next();
                realConnection.refresh(aRealDeviceType);
            }
        }
        i = design.getPatternInstances().getPatternInstance().iterator();
        while (i.hasNext()) {
            PatternInstance patternInstance = (PatternInstance)i.next();
            Pattern realPattern = PatternLibrary.getPattern(patternInstance.getCollectionID(), patternInstance.getPatternID());
            edu.berkeley.guir.damask.pattern.PatternInstance realPatternInstance = new edu.berkeley.guir.damask.pattern.PatternInstance(realPattern);
            j = patternInstance.getElementRef().iterator();
            while (j.hasNext()) {
                ElementRef ref = (ElementRef)j.next();
                if (realElements.get(ref.getRef()) == null) continue;
                realPatternInstance.add((PatternInstanceMember)realElements.get(ref.getRef()));
            }
            realGraph.add(realPatternInstance);
        }
        realElements.clear();
        return realGraph;
    }

    private static TemplateDialog getRealTemplateDialog(Dialog dialog) {
        return (TemplateDialog)DamaskReader.getRealDialog(dialog, true);
    }

    private static edu.berkeley.guir.damask.dialog.Dialog getRealDialog(Dialog dialog) {
        return DamaskReader.getRealDialog(dialog, false);
    }

    private static edu.berkeley.guir.damask.dialog.Dialog getRealDialog(Dialog dialog, boolean isTemplate) {
        Group group;
        Iterator j;
        DeviceType realDeviceType;
        DeviceType realDeviceType2;
        edu.berkeley.guir.damask.dialog.Dialog realDialog = (edu.berkeley.guir.damask.dialog.Dialog)realElements.get(dialog);
        if (realDialog != null) {
            return realDialog;
        }
        Content pageTitle = null;
        HashMap pagesPerDeviceType = new HashMap();
        Iterator i = Damask.getSupportedDeviceTypes().iterator();
        while (i.hasNext()) {
            realDeviceType2 = (DeviceType)i.next();
            pagesPerDeviceType.put(realDeviceType2, new ArrayList());
        }
        int index = 0;
        Iterator i2 = dialog.getPages().getPage().iterator();
        while (i2.hasNext()) {
            Page page = (Page)i2.next();
            if (index == 0) {
                pageTitle = page.getTitle().getContent();
            }
            if ((realDeviceType = DamaskReader.getRealDeviceType(page.getDeviceType())) == DeviceType.VOICE) {
                boolean hasContent = false;
                Iterator j2 = page.getRegions().getRegion().iterator();
                while (j2.hasNext()) {
                    Region region = (Region)j2.next();
                    hasContent |= !region.getControlRef().isEmpty();
                }
                if (hasContent) {
                    ((List)pagesPerDeviceType.get(realDeviceType)).add(page);
                }
            } else {
                ((List)pagesPerDeviceType.get(realDeviceType)).add(page);
            }
            ++index;
        }
        if (!$assertionsDisabled && pageTitle == null) {
            throw new AssertionError((Object)"The title of the dialog should not be null");
        }
        HashSet<DeviceType> supportedRealDeviceTypes = new HashSet<DeviceType>();
        Iterator i3 = pagesPerDeviceType.keySet().iterator();
        while (i3.hasNext()) {
            realDeviceType = (DeviceType)i3.next();
            int count = ((List)pagesPerDeviceType.get(realDeviceType)).size();
            if (count == 0) continue;
            supportedRealDeviceTypes.add(realDeviceType);
        }
        DeviceType realDeviceTypeForDialog = supportedRealDeviceTypes.size() == 1 ? (DeviceType)supportedRealDeviceTypes.iterator().next() : DeviceType.ALL;
        realDialog = isTemplate ? new TemplateDialog(realDeviceTypeForDialog, DamaskReader.getRealContent(pageTitle)) : new edu.berkeley.guir.damask.dialog.Dialog(realDeviceTypeForDialog, DamaskReader.getRealContent(pageTitle));
        realElements.put(dialog, realDialog);
        Iterator<Object> i22 = pagesPerDeviceType.keySet().iterator();
        while (i22.hasNext()) {
            realDeviceType2 = (DeviceType)i22.next();
            List pages = (List)pagesPerDeviceType.get(realDeviceType2);
            j = pages.iterator();
            while (j.hasNext()) {
                Page page = (Page)j.next();
                edu.berkeley.guir.damask.dialog.Page realPage = realDialog.getLastPage(realDeviceType2);
                realElements.put(page, realPage);
                edu.berkeley.guir.damask.component.Content realPageTitleContent = DamaskReader.getRealContent(page.getTitle().getContent());
                realPage.getTitle().setText(realPageTitleContent.getText());
                BufferedImage realPageTitleContentImage = realPageTitleContent.getImage();
                if (realPageTitleContentImage != null) {
                    realPage.getTitle().setImage(realPageTitleContentImage);
                }
                realPage.getTitle().setStrokes(realPageTitleContent.getStrokes());
                if (!j.hasNext()) continue;
                realPage.split(Collections.EMPTY_LIST);
            }
        }
        i22 = dialog.getPages().getPage().iterator();
        while (i22.hasNext()) {
            Page page = (Page)i22.next();
            edu.berkeley.guir.damask.dialog.Page realPage = (edu.berkeley.guir.damask.dialog.Page)realElements.get(page);
            if (realPage == null) continue;
            realPage.setBounds(DamaskReader.createRealBounds(page.getBounds()));
            realPage.setTransform(DamaskReader.createRealTransform(page.getTransform()));
            j = page.getRegions().getRegion().iterator();
            while (j.hasNext()) {
                Region region = (Region)j.next();
                PageRegion realRegion = realPage.getRegion(DamaskReader.getRealDirection(region.getName()));
                realRegion.setInset(region.getInset().intValue());
                Iterator k = region.getControlRef().iterator();
                while (k.hasNext()) {
                    ControlRef controlRef = (ControlRef)k.next();
                    Object control = controlRef.getRef();
                    Control realControl = (Control)realElements.get(control);
                    if (realControl == null) {
                        if (control instanceof Content) {
                            realControl = DamaskReader.getRealContent((Content)control);
                        } else if (control instanceof TextInput) {
                            realControl = DamaskReader.getRealTextInput((TextInput)control);
                        } else if (control instanceof Trigger) {
                            realControl = DamaskReader.getRealTrigger((Trigger)control);
                        } else if (control instanceof SelectOne) {
                            realControl = DamaskReader.getRealSelectOne((SelectOne)control);
                        } else if (control instanceof SelectMany) {
                            realControl = DamaskReader.getRealSelectMany((SelectMany)control);
                        } else if (!$assertionsDisabled) {
                            throw new AssertionError((Object)("control should be a Control, not " + control.getClass()));
                        }
                        realElements.put(control, realControl);
                        origResponseLines.put(realControl, realControl.getVoiceResponseLines());
                    }
                    if (realControl.getDialog() != realDialog) {
                        realDialog.addControlAtEnd(realRegion, realControl);
                    }
                    realDialog.changeControlPageRegion(realControl, realRegion);
                    Map origResponseLinesForControl = (Map)origResponseLines.get(realControl);
                    Iterator m = origResponseLinesForControl.keySet().iterator();
                    while (m.hasNext()) {
                        Integer condition = (Integer)m.next();
                        Line2D line = (Line2D)origResponseLinesForControl.get(condition);
                        realControl.setVoiceResponseLine(condition, line);
                    }
                }
            }
            j = new ArrayList(realPage.getTemplates()).iterator();
            while (j.hasNext()) {
                edu.berkeley.guir.damask.dialog.Page templatePage = (edu.berkeley.guir.damask.dialog.Page)j.next();
                realPage.removeTemplate(templatePage);
            }
            j = page.getTemplateRefs().getTemplateRef().iterator();
            while (j.hasNext()) {
                TemplateRef templateRef = (TemplateRef)j.next();
                Object template = templateRef.getRef();
                edu.berkeley.guir.damask.dialog.Page realTemplatePage = (edu.berkeley.guir.damask.dialog.Page)realElements.get(template);
                if (realTemplatePage == null) continue;
                realPage.addTemplate(realTemplatePage);
            }
        }
        int numConditions = dialog.getConditionsCount().intValue();
        int i32 = 1;
        while (i32 < numConditions) {
            realDialog.addCondition();
            ++i32;
        }
        Iterator<Object> i4 = realElements.keySet().iterator();
        while (i4.hasNext()) {
            Object element = i4.next();
            Object realElement = realElements.get(element);
            Control realControl = realElement instanceof Control ? (Control)realElement : null;
            if (element instanceof Content) {
                DamaskReader.setStatesAndSignificances(realControl, ((Content)element).getStates(), ((Content)element).getSignificances());
                continue;
            }
            if (element instanceof TextInput) {
                DamaskReader.setStatesAndSignificances(realControl, ((TextInput)element).getStates(), ((TextInput)element).getSignificances());
                continue;
            }
            if (element instanceof Trigger) {
                DamaskReader.setStatesAndSignificances(realControl, ((Trigger)element).getStates(), ((Trigger)element).getSignificances());
                continue;
            }
            if (element instanceof SelectOne) {
                DamaskReader.setStatesAndSignificances(realControl, ((SelectOne)element).getStates(), ((SelectOne)element).getSignificances());
                continue;
            }
            if (!(element instanceof SelectMany)) continue;
            DamaskReader.setStatesAndSignificances(realControl, ((SelectMany)element).getStates(), ((SelectMany)element).getSignificances());
        }
        i4 = dialog.getGroups().getGroup().iterator();
        while (i4.hasNext()) {
            PageRegion realRegion;
            group = (Group)i4.next();
            HashMap groupBounds = new HashMap();
            HashMap groupTransform = new HashMap();
            DeviceType realGroupDeviceType = DamaskReader.getDeviceTypeAndBoundsAndTransformsForGroup(group.getBoundsAndTransformsForGroup(), groupBounds, groupTransform);
            ComponentGroup realGroup = new ComponentGroup(realGroupDeviceType);
            Iterator j3 = groupBounds.keySet().iterator();
            while (j3.hasNext()) {
                realRegion = (PageRegion)j3.next();
                realGroup.setBoundsInPageRegion(realRegion, (Rectangle2D)groupBounds.get(realRegion));
            }
            j3 = groupTransform.keySet().iterator();
            while (j3.hasNext()) {
                realRegion = (PageRegion)j3.next();
                realGroup.setTransformInPageRegion(realRegion, (AffineTransform)groupTransform.get(realRegion));
            }
            realDialog.addGroup(realGroup);
            realElements.put(group, realGroup);
        }
        i4 = dialog.getGroups().getGroup().iterator();
        while (i4.hasNext()) {
            group = (Group)i4.next();
            ComponentGroup realGroup = (ComponentGroup)realElements.get(group);
            Iterator j4 = group.getComponents().getComponentRef().iterator();
            while (j4.hasNext()) {
                ComponentRef componentRef = (ComponentRef)j4.next();
                realGroup.add((Component)realElements.get(componentRef.getRef()));
            }
        }
        realElements.put(dialog, realDialog);
        HashMap bounds = new HashMap();
        HashMap transform = new HashMap();
        DeviceType realDialogDeviceType = DamaskReader.getDeviceTypeAndBoundsAndTransforms(dialog.getBoundsAndTransforms(), bounds, transform);
        DamaskReader.setBoundsAndTransforms(realDialog, bounds, transform);
        realDialog.setDeviceType(realDialogDeviceType);
        return realDialog;
    }

    private static edu.berkeley.guir.damask.component.Content getRealContent(Content content) {
        Polylines strokesContent;
        ImageContent imageContent;
        edu.berkeley.guir.damask.component.Content realContent = (edu.berkeley.guir.damask.component.Content)realElements.get(content);
        if (realContent != null) {
            return realContent;
        }
        HashMap bounds = new HashMap();
        HashMap transform = new HashMap();
        DeviceType realDeviceType = DamaskReader.getDeviceTypeAndBoundsAndTransforms(content.getBoundsAndTransforms(), bounds, transform);
        realContent = new edu.berkeley.guir.damask.component.Content(realDeviceType);
        TextContent textContent = content.getTextContent();
        if (textContent != null) {
            realContent.setText(textContent.getText());
            Iterator i = textContent.getTextSizes().getTextSize().iterator();
            while (i.hasNext()) {
                TextSize textSize = (TextSize)i.next();
                realContent.setTextSize(DamaskReader.getRealDeviceType(textSize.getDeviceType()), textSize.getSize().intValue());
            }
            if (textContent.getVoiceText() != null && realContent.isVisibleToDeviceType(DeviceType.VOICE)) {
                realContent.setPromptTextSyncedWithText(textContent.getVoiceText().equals(realContent.getText()));
                realContent.setVoicePromptText(textContent.getVoiceText());
            }
        }
        if ((imageContent = content.getImageContent()) != null && imageContent.getEncoding().equalsIgnoreCase("base64")) {
            try {
                String imageDataStr = imageContent.getImageData();
                byte[] imageData = Base64.decodeBase64((byte[])imageDataStr.getBytes());
                BufferedImage image = ImageIO.read(new ByteArrayInputStream(imageData));
                realContent.setImage(image);
            }
            catch (IOException e) {
                DamaskAppExceptionHandler.log(e);
            }
        }
        if ((strokesContent = content.getStrokesContent()) != null) {
            ArrayList<GeneralPath> realStrokes = new ArrayList<GeneralPath>();
            Iterator i = strokesContent.getPolyline().iterator();
            while (i.hasNext()) {
                Polyline polyline = (Polyline)i.next();
                GeneralPath genPath = DamaskReader.createGeneralPath(polyline);
                realStrokes.add(genPath);
            }
            realContent.setStrokes(realStrokes);
        }
        Iterator i = content.getDisplayModes().getDisplayMode().iterator();
        while (i.hasNext()) {
            DisplayMode displayMode = (DisplayMode)i.next();
            String displayModeString = displayMode.getMode();
            Content.DisplayMode realDisplayMode = displayModeString.equalsIgnoreCase("Image") ? edu.berkeley.guir.damask.component.Content.IMAGE : (displayModeString.equalsIgnoreCase("Ink") ? edu.berkeley.guir.damask.component.Content.INK : edu.berkeley.guir.damask.component.Content.TEXT);
            realContent.setPreferredDisplayMode(DamaskReader.getRealDeviceType(displayMode.getDeviceType()), realDisplayMode);
        }
        DamaskReader.setBoundsAndTransforms(realContent, bounds, transform);
        DamaskReader.setVoiceViewProperties(realContent, content);
        realElements.put(content, realContent);
        return realContent;
    }

    private static edu.berkeley.guir.damask.component.TextInput getRealTextInput(TextInput textInput) {
        edu.berkeley.guir.damask.component.TextInput realTextInput = (edu.berkeley.guir.damask.component.TextInput)realElements.get(textInput);
        if (realTextInput != null) {
            return realTextInput;
        }
        HashMap bounds = new HashMap();
        HashMap transform = new HashMap();
        DeviceType realDeviceType = DamaskReader.getDeviceTypeAndBoundsAndTransforms(textInput.getBoundsAndTransforms(), bounds, transform);
        realTextInput = new edu.berkeley.guir.damask.component.TextInput(realDeviceType);
        DamaskReader.setBoundsAndTransforms(realTextInput, bounds, transform);
        Borders borders = textInput.getBorders();
        if (borders != null) {
            Iterator i = borders.getBorder().iterator();
            while (i.hasNext()) {
                Border border = (Border)i.next();
                realTextInput.setBorder(DamaskReader.getRealDeviceType(border.getDeviceType()), DamaskReader.createGeneralPath(border.getPolyline()));
            }
        }
        realElements.put(textInput, realTextInput);
        DamaskReader.setVoiceViewProperties(realTextInput, textInput);
        return realTextInput;
    }

    private static edu.berkeley.guir.damask.component.Trigger getRealTrigger(Trigger trigger) {
        Styles styles;
        edu.berkeley.guir.damask.component.Trigger realTrigger = (edu.berkeley.guir.damask.component.Trigger)realElements.get(trigger);
        if (realTrigger != null) {
            return realTrigger;
        }
        HashMap bounds = new HashMap();
        HashMap transform = new HashMap();
        DeviceType realDeviceType = DamaskReader.getDeviceTypeAndBoundsAndTransforms(trigger.getBoundsAndTransforms(), bounds, transform);
        realTrigger = new edu.berkeley.guir.damask.component.Trigger(realDeviceType, DamaskReader.getRealContent(trigger.getContent()));
        DamaskReader.setBoundsAndTransforms(realTrigger, bounds, transform);
        Borders borders = trigger.getBorders();
        if (borders != null) {
            Iterator i = borders.getBorder().iterator();
            while (i.hasNext()) {
                Border border = (Border)i.next();
                realTrigger.setBorder(DamaskReader.getRealDeviceType(border.getDeviceType()), DamaskReader.createGeneralPath(border.getPolyline()));
            }
        }
        if ((styles = trigger.getStyles()) != null) {
            Iterator i = styles.getStyle().iterator();
            while (i.hasNext()) {
                Style style = (Style)i.next();
                String styleString = style.getName();
                Trigger.Style realStyle = styleString.equalsIgnoreCase("Button") ? edu.berkeley.guir.damask.component.Trigger.BUTTON : edu.berkeley.guir.damask.component.Trigger.HYPERLINK;
                realTrigger.setStyle(DamaskReader.getRealDeviceType(style.getDeviceType()), realStyle);
            }
        }
        realElements.put(trigger, realTrigger);
        DamaskReader.setVoiceViewProperties(realTrigger, trigger);
        return realTrigger;
    }

    private static edu.berkeley.guir.damask.component.SelectOne getRealSelectOne(SelectOne selectOne) {
        edu.berkeley.guir.damask.component.SelectOne realSelectOne = (edu.berkeley.guir.damask.component.SelectOne)realElements.get(selectOne);
        if (realSelectOne != null) {
            return realSelectOne;
        }
        HashMap bounds = new HashMap();
        HashMap transform = new HashMap();
        DeviceType realDeviceType = DamaskReader.getDeviceTypeAndBoundsAndTransforms(selectOne.getBoundsAndTransforms(), bounds, transform);
        realSelectOne = new edu.berkeley.guir.damask.component.SelectOne(realDeviceType);
        Styles styles = selectOne.getStyles();
        if (styles != null) {
            Iterator i = styles.getStyle().iterator();
            while (i.hasNext()) {
                Style style = (Style)i.next();
                String styleString = style.getName();
                Select.Style realStyle = styleString.equalsIgnoreCase("Full") ? Select.FULL : (styleString.equalsIgnoreCase("Compact") ? Select.COMPACT : Select.MINIMAL);
                realSelectOne.setStyle(DamaskReader.getRealDeviceType(style.getDeviceType()), realStyle);
            }
        }
        DamaskReader.setBoundsAndTransforms(realSelectOne, bounds, transform);
        Items items = selectOne.getItems();
        if (items != null) {
            Iterator i = items.getItem().iterator();
            while (i.hasNext()) {
                Item item = (Item)i.next();
                HashMap itemBounds = new HashMap();
                HashMap itemTransform = new HashMap();
                DamaskReader.getDeviceTypeAndBoundsAndTransforms(item.getBoundsAndTransforms(), itemBounds, itemTransform);
                SelectOne.Item realItem = new SelectOne.Item(DamaskReader.getRealContent(item.getContent()));
                realElements.put(item, realItem);
                DamaskReader.setBoundsAndTransforms(realItem, itemBounds, itemTransform);
                DamaskReader.setVoiceViewProperties(realItem, item);
                realSelectOne.addItem(realItem);
            }
        }
        DamaskReader.setVoiceViewProperties(realSelectOne, selectOne);
        realElements.put(selectOne, realSelectOne);
        return realSelectOne;
    }

    private static edu.berkeley.guir.damask.component.SelectMany getRealSelectMany(SelectMany selectMany) {
        Styles styles;
        edu.berkeley.guir.damask.component.SelectMany realSelectMany = (edu.berkeley.guir.damask.component.SelectMany)realElements.get(selectMany);
        if (realSelectMany != null) {
            return realSelectMany;
        }
        HashMap bounds = new HashMap();
        HashMap transform = new HashMap();
        DeviceType realDeviceType = DamaskReader.getDeviceTypeAndBoundsAndTransforms(selectMany.getBoundsAndTransforms(), bounds, transform);
        realSelectMany = new edu.berkeley.guir.damask.component.SelectMany(realDeviceType);
        DamaskReader.setBoundsAndTransforms(realSelectMany, bounds, transform);
        Items items = selectMany.getItems();
        if (items != null) {
            Iterator i = items.getItem().iterator();
            while (i.hasNext()) {
                Item item = (Item)i.next();
                HashMap itemBounds = new HashMap();
                HashMap itemTransform = new HashMap();
                DamaskReader.getDeviceTypeAndBoundsAndTransforms(item.getBoundsAndTransforms(), itemBounds, itemTransform);
                SelectMany.Item realItem = new SelectMany.Item(DamaskReader.getRealContent(item.getContent()));
                realElements.put(item, realItem);
                DamaskReader.setBoundsAndTransforms(realItem, itemBounds, itemTransform);
                DamaskReader.setVoiceViewProperties(realItem, item);
                realSelectMany.addItem(realItem);
            }
        }
        if ((styles = selectMany.getStyles()) != null) {
            Iterator i = styles.getStyle().iterator();
            while (i.hasNext()) {
                Style style = (Style)i.next();
                String styleString = style.getName();
                Select.Style realStyle = styleString.equalsIgnoreCase("Full") ? Select.FULL : (styleString.equalsIgnoreCase("Compact") ? Select.COMPACT : Select.MINIMAL);
                realSelectMany.setStyle(DamaskReader.getRealDeviceType(style.getDeviceType()), realStyle);
            }
        }
        realElements.put(selectMany, realSelectMany);
        DamaskReader.setVoiceViewProperties(realSelectMany, selectMany);
        return realSelectMany;
    }

    private static void setStatesAndSignificances(Control realControl, States states, Significances significances) {
        int conditionNum;
        Iterator j;
        edu.berkeley.guir.damask.dialog.Dialog realDialog;
        Dialog dialog;
        if (states == null || significances == null) {
            return;
        }
        Iterator i = states.getStatesForDialog().iterator();
        while (i.hasNext()) {
            StatesForDialog statesForDialog = (StatesForDialog)i.next();
            dialog = (Dialog)statesForDialog.getDialog();
            realDialog = (edu.berkeley.guir.damask.dialog.Dialog)realElements.get(dialog);
            j = statesForDialog.getStateForCondition().iterator();
            while (j.hasNext()) {
                StateForCondition condition = (StateForCondition)j.next();
                conditionNum = condition.getConditionNum().intValue();
                if (condition.getMultiState() != null) {
                    MultiState multiState = condition.getMultiState();
                    ArrayList<Object> realStates = new ArrayList<Object>();
                    Iterator k = multiState.getState().iterator();
                    while (k.hasNext()) {
                        Object o = k.next();
                        if (o instanceof StateBooleanState) {
                            realStates.add(((StateBooleanState)o).isValue());
                        } else if (o instanceof StateIntegerState) {
                            realStates.add(new Integer(((StateIntegerState)o).getValue().intValue()));
                        } else if (o instanceof StateStringState) {
                            realStates.add(((StateStringState)o).getValue());
                        } else if (o instanceof StateIDREFState) {
                            realStates.add(realElements.get(((StateIDREFState)o).getValue()));
                        }
                        realControl.setStateForCondition(realDialog, conditionNum, realStates);
                    }
                    continue;
                }
                Object realState = condition.getIntegerState() != null ? new Integer(condition.getIntegerState().getValue().intValue()) : (condition.getStringState() != null ? condition.getStringState().getValue() : (condition.getIDREFState() != null ? realElements.get(condition.getIDREFState().getValue()) : Boolean.valueOf(condition.getBooleanState().isValue())));
                realControl.setStateForCondition(realDialog, conditionNum, realState);
            }
        }
        i = significances.getSignificancesForDialog().iterator();
        while (i.hasNext()) {
            SignificancesForDialog sigsForDialog = (SignificancesForDialog)i.next();
            dialog = (Dialog)sigsForDialog.getDialog();
            realDialog = (edu.berkeley.guir.damask.dialog.Dialog)realElements.get(dialog);
            j = sigsForDialog.getSignificance().iterator();
            while (j.hasNext()) {
                Significance sig = (Significance)j.next();
                conditionNum = sig.getCondition().intValue();
                boolean sigValue = sig.isValue();
                realControl.setStateSignificantForCondition(realDialog, conditionNum, sigValue);
            }
        }
    }

    private static edu.berkeley.guir.damask.connection.Connection getRealConnection(Connection connection) {
        edu.berkeley.guir.damask.connection.Connection realConnection = (edu.berkeley.guir.damask.connection.Connection)realElements.get(connection);
        if (realConnection != null) {
            return realConnection;
        }
        UserEvent userEvent = connection.getUserEvent();
        int condition = connection.getCondition() != null ? connection.getCondition().intValue() : -1;
        HashMap<String, Polyline> shapes = new HashMap<String, Polyline>();
        Iterator<Object> i = connection.getConnectionShape().iterator();
        while (i.hasNext()) {
            ConnectionShape connectionShape = (ConnectionShape)i.next();
            shapes.put(connectionShape.getDeviceType(), connectionShape.getPolyline());
        }
        realConnection = userEvent == null ? new OrgConnection(DamaskReader.getRealDeviceType(connection.getOrigDeviceType()), connection.isForAllDeviceTypes(), (edu.berkeley.guir.damask.dialog.Page)realElements.get(connection.getSourceForOrigDeviceType()), (edu.berkeley.guir.damask.dialog.Page)realElements.get(connection.getDestForOrigDeviceType()), DamaskReader.createGeneralPath((Polyline)shapes.get(connection.getOrigDeviceType()))) : new NavConnection(DamaskReader.getRealDeviceType(connection.getOrigDeviceType()), connection.isForAllDeviceTypes(), (Control)realElements.get(connection.getSourceForOrigDeviceType()), DamaskReader.createRealUserEvent(userEvent), condition, (ConnectionDest)realElements.get(connection.getDestForOrigDeviceType()), DamaskReader.createGeneralPath((Polyline)shapes.get(connection.getOrigDeviceType())));
        i = shapes.keySet().iterator();
        while (i.hasNext()) {
            String deviceType = (String)i.next();
            Polyline polyline = (Polyline)shapes.get(deviceType);
            realConnection.setShape(DamaskReader.getRealDeviceType(deviceType), DamaskReader.createGeneralPath(polyline));
        }
        realElements.put(connection, realConnection);
        return realConnection;
    }

    private static DamaskUserEvent createRealUserEvent(UserEvent event) {
        Element eventElement = event.getUserEvent();
        if (eventElement instanceof HoverOverEvent) {
            return new edu.berkeley.guir.damask.userevent.HoverOverEvent(realElements.get(((HoverOverEvent)((Object)eventElement)).getSource()));
        }
        if (eventElement instanceof HoverOffEvent) {
            return new edu.berkeley.guir.damask.userevent.HoverOffEvent(realElements.get(((HoverOffEvent)((Object)eventElement)).getSource()));
        }
        if (eventElement instanceof InvokeEvent) {
            return new edu.berkeley.guir.damask.userevent.InvokeEvent(realElements.get(((InvokeEvent)((Object)eventElement)).getSource()));
        }
        if (eventElement instanceof SecondaryInvokeEvent) {
            return new edu.berkeley.guir.damask.userevent.SecondaryInvokeEvent(realElements.get(((SecondaryInvokeEvent)((Object)eventElement)).getSource()));
        }
        return new edu.berkeley.guir.damask.userevent.SelectEvent(realElements.get(((SelectEvent)((Object)eventElement)).getSource()));
    }

    private static DeviceType getDeviceTypeAndBoundsAndTransforms(BoundsAndTransforms boundsAndTransforms, Map bounds, Map transform) {
        Iterator i = boundsAndTransforms.getBoundsAndTransform().iterator();
        while (i.hasNext()) {
            BoundsAndTransform boundsAndTransform = (BoundsAndTransform)i.next();
            DeviceType realDeviceType = DamaskReader.getRealDeviceType(boundsAndTransform.getDeviceType());
            bounds.put(realDeviceType, DamaskReader.createRealBounds(boundsAndTransform.getBounds()));
            transform.put(realDeviceType, DamaskReader.createRealTransform(boundsAndTransform.getTransform()));
        }
        DeviceType realDeviceType = bounds.size() == 0 ? DeviceType.VOICE : (bounds.size() == 1 ? (DeviceType)bounds.keySet().iterator().next() : DeviceType.ALL);
        return realDeviceType;
    }

    private static DeviceType getDeviceTypeAndBoundsAndTransformsForGroup(BoundsAndTransformsForGroup boundsAndTransformsForGroup, Map bounds, Map transform) {
        HashSet<DeviceType> supportedRealDeviceTypes = new HashSet<DeviceType>();
        Iterator i = boundsAndTransformsForGroup.getBoundsAndTransformInRegion().iterator();
        while (i.hasNext()) {
            BoundsAndTransformInRegion boundsAndTransformInRegion = (BoundsAndTransformInRegion)i.next();
            edu.berkeley.guir.damask.dialog.Page realPage = (edu.berkeley.guir.damask.dialog.Page)realElements.get(boundsAndTransformInRegion.getPage());
            DeviceType realDeviceType = realPage.getDeviceType();
            supportedRealDeviceTypes.add(realDeviceType);
            PageRegion realRegion = realPage.getRegion(DamaskReader.getRealDirection(boundsAndTransformInRegion.getRegion()));
            bounds.put(realRegion, DamaskReader.createRealBounds(boundsAndTransformInRegion.getBounds()));
            transform.put(realRegion, DamaskReader.createRealTransform(boundsAndTransformInRegion.getTransform()));
        }
        DeviceType realDeviceType = supportedRealDeviceTypes.size() == 1 ? (DeviceType)supportedRealDeviceTypes.iterator().next() : DeviceType.ALL;
        return realDeviceType;
    }

    private static void setBoundsAndTransforms(InteractionElement realElement, Map bounds, Map transform) {
        Iterator i = bounds.keySet().iterator();
        while (i.hasNext()) {
            DeviceType realDeviceType = (DeviceType)i.next();
            realElement.setBounds(realDeviceType, (Rectangle2D)bounds.get(realDeviceType));
            realElement.setTransform(realDeviceType, (AffineTransform)transform.get(realDeviceType));
        }
    }

    private static void setVoiceViewProperties(Control realControl, Object control) {
        if (!realControl.isVisibleToDeviceType(DeviceType.VOICE)) {
            return;
        }
        try {
            Response response;
            VoiceViewProperties voiceProperties = (VoiceViewProperties)control.getClass().getMethod("getVoiceViewProperties", null).invoke(control, null);
            if (voiceProperties == null) {
                return;
            }
            Prompt prompt = voiceProperties.getPrompt();
            if (prompt != null) {
                realControl.setVoicePromptBounds(DamaskReader.createRealBounds(prompt.getBounds()));
                if (prompt.getText() != null) {
                    realControl.setVoicePromptText(prompt.getText());
                }
            }
            if (realControl instanceof edu.berkeley.guir.damask.component.Content) {
                String origPromptText = ((edu.berkeley.guir.damask.component.Content)realControl).getVoicePromptText();
                if (((edu.berkeley.guir.damask.component.Content)realControl).getText().equals("") && (origPromptText == null || origPromptText.equals(""))) {
                    ((edu.berkeley.guir.damask.component.Content)realControl).setText("Text");
                }
            }
            if ((response = voiceProperties.getResponse()) != null) {
                Iterator i = response.getLines().getResponseLine().iterator();
                while (i.hasNext()) {
                    ResponseLine responseLine = (ResponseLine)i.next();
                    realControl.setVoiceResponseLine(responseLine.getCondition().intValue(), new Line2D.Double(responseLine.getX1(), responseLine.getY1(), responseLine.getX2(), responseLine.getY2()));
                }
                if (realControl instanceof SelectMany.Item) {
                    SelectMany.Item realItem = (SelectMany.Item)realControl;
                    ArrayList textList = new ArrayList(response.getTexts().getText());
                    realItem.setVoiceResponseTextList(textList);
                }
            }
            realControl.setTransform(DeviceType.VOICE, DamaskReader.createRealTransform(voiceProperties.getTransform()));
        }
        catch (IllegalArgumentException e) {
            DamaskAppExceptionHandler.log(e);
        }
        catch (SecurityException e) {
            DamaskAppExceptionHandler.log(e);
        }
        catch (IllegalAccessException e) {
            DamaskAppExceptionHandler.log(e);
        }
        catch (InvocationTargetException e) {
            DamaskAppExceptionHandler.log(e);
        }
        catch (NoSuchMethodException e) {
            DamaskAppExceptionHandler.log(e);
        }
    }

    private static Rectangle2D createRealBounds(Bounds bounds) {
        return new Rectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
    }

    private static AffineTransform createRealTransform(Transform transform) {
        return new AffineTransform(transform.getScaleX(), transform.getShearX(), transform.getShearY(), transform.getScaleY(), transform.getTranslateX(), transform.getTranslateY());
    }

    private static DeviceType getRealDeviceType(String deviceTypeString) {
        if (deviceTypeString.equalsIgnoreCase("Desktop")) {
            return DeviceType.DESKTOP;
        }
        if (deviceTypeString.equalsIgnoreCase("Smartphone")) {
            return DeviceType.SMARTPHONE;
        }
        if (deviceTypeString.equalsIgnoreCase("Voice")) {
            return DeviceType.VOICE;
        }
        return DeviceType.ALL;
    }

    private static GeneralPath createGeneralPath(Polyline polyline) {
        Point point;
        GeneralPath genPath = new GeneralPath();
        Iterator j = polyline.getPoint().iterator();
        if (j.hasNext()) {
            point = (Point)j.next();
            genPath.moveTo((float)point.getX(), (float)point.getY());
        }
        while (j.hasNext()) {
            point = (Point)j.next();
            genPath.lineTo((float)point.getX(), (float)point.getY());
        }
        return genPath;
    }

    private static Direction getRealDirection(String directionString) {
        if (directionString.equalsIgnoreCase("North")) {
            return Direction.NORTH;
        }
        if (directionString.equalsIgnoreCase("South")) {
            return Direction.SOUTH;
        }
        if (directionString.equalsIgnoreCase("East")) {
            return Direction.EAST;
        }
        if (directionString.equalsIgnoreCase("West")) {
            return Direction.WEST;
        }
        return Direction.CENTER;
    }
}

