/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.event;

import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.event.PageEvent;
import edu.berkeley.guir.damask.event.PageListener;
import java.util.Iterator;
import java.util.Vector;

public class PageEventSource {
    private Vector eventListeners = new Vector();

    public synchronized void addPageListener(PageListener listener) {
        if (!this.eventListeners.contains(listener)) {
            this.eventListeners.add(listener);
        }
    }

    public synchronized void removePageListener(PageListener listener) {
        this.eventListeners.remove(listener);
    }

    public void fireTemplateAdded(Page page, Page newTemplate) {
        Vector el;
        PageEventSource pageEventSource = this;
        synchronized (pageEventSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        PageEvent event = new PageEvent(page, PageEvent.TEMPLATE_ADDED, newTemplate);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            PageListener listener = (PageListener)i.next();
            listener.templateAdded(event);
        }
    }

    public void fireTemplateRemoved(Page page, Page oldTemplate) {
        Vector el;
        PageEventSource pageEventSource = this;
        synchronized (pageEventSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        PageEvent event = new PageEvent(page, PageEvent.TEMPLATE_REMOVED, oldTemplate);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            PageListener listener = (PageListener)i.next();
            listener.templateRemoved(event);
        }
    }
}

