/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.event;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.InteractionGraph;
import edu.berkeley.guir.damask.event.InteractionGraphEvent;
import edu.berkeley.guir.damask.event.InteractionGraphListener;
import java.util.Iterator;
import java.util.Vector;

public class InteractionGraphSource {
    private Vector eventListeners = new Vector();

    public synchronized void addInteractionGraphListener(InteractionGraphListener listener) {
        if (!this.eventListeners.contains(listener)) {
            this.eventListeners.add(listener);
        }
    }

    public synchronized void removeInteractionGraphListener(InteractionGraphListener listener) {
        this.eventListeners.remove(listener);
    }

    public void fireHomePageChanged(InteractionGraph graph, DeviceType deviceType) {
        Vector el;
        InteractionGraphSource interactionGraphSource = this;
        synchronized (interactionGraphSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        InteractionGraphEvent event = new InteractionGraphEvent(graph, InteractionGraphEvent.HOME_PAGE_CHANGED, deviceType);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            InteractionGraphListener listener = (InteractionGraphListener)i.next();
            listener.homePageChanged(event);
        }
    }
}

