/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.event;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.InteractionElement;
import edu.berkeley.guir.damask.event.InteractionElementEvent;
import edu.berkeley.guir.damask.event.InteractionElementListener;
import java.util.Iterator;
import java.util.Vector;

public class InteractionElementSource {
    private Vector eventListeners = new Vector();

    public synchronized void addInteractionElementListener(InteractionElementListener listener) {
        if (!this.eventListeners.contains(listener)) {
            this.eventListeners.add(listener);
        }
    }

    public synchronized void removeInteractionElementListener(InteractionElementListener listener) {
        this.eventListeners.remove(listener);
    }

    public void fireElementBoundsUpdated(InteractionElement e, DeviceType deviceType) {
        Vector el;
        InteractionElementSource interactionElementSource = this;
        synchronized (interactionElementSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        InteractionElementEvent event = new InteractionElementEvent(e, InteractionElementEvent.BOUNDS_UPDATED, deviceType);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            InteractionElementListener listener = (InteractionElementListener)i.next();
            listener.elementBoundsUpdated(event);
        }
    }

    public void fireElementTransformUpdated(InteractionElement e, DeviceType deviceType) {
        Vector el;
        InteractionElementSource interactionElementSource = this;
        synchronized (interactionElementSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        InteractionElementEvent event = new InteractionElementEvent(e, InteractionElementEvent.TRANSFORM_UPDATED, deviceType);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            InteractionElementListener listener = (InteractionElementListener)i.next();
            listener.elementTransformUpdated(event);
        }
    }

    public void fireElementBorderUpdated(InteractionElement e, DeviceType deviceType) {
        Vector el;
        InteractionElementSource interactionElementSource = this;
        synchronized (interactionElementSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        InteractionElementEvent event = new InteractionElementEvent(e, InteractionElementEvent.BORDER_UPDATED, deviceType);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            InteractionElementListener listener = (InteractionElementListener)i.next();
            listener.elementBorderUpdated(event);
        }
    }
}

