/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.event;

import edu.berkeley.guir.damask.component.ComponentGroup;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.damask.event.GroupEvent;
import edu.berkeley.guir.damask.event.GroupListener;
import java.util.Iterator;
import java.util.Vector;

public class GroupEventSource {
    private Vector eventListeners = new Vector();

    public synchronized void addGroupListener(GroupListener listener) {
        if (!this.eventListeners.contains(listener)) {
            this.eventListeners.add(listener);
        }
    }

    public synchronized void removeGroupListener(GroupListener listener) {
        this.eventListeners.remove(listener);
    }

    public void fireElementBoundsUpdated(ComponentGroup group, PageRegion region) {
        Vector el;
        GroupEventSource groupEventSource = this;
        synchronized (groupEventSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        GroupEvent event = new GroupEvent(group, GroupEvent.BOUNDS_UPDATED, region);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            GroupListener listener = (GroupListener)i.next();
            listener.elementBoundsUpdated(event);
        }
    }

    public void fireElementTransformUpdated(ComponentGroup group, PageRegion region) {
        Vector el;
        GroupEventSource groupEventSource = this;
        synchronized (groupEventSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        GroupEvent event = new GroupEvent(group, GroupEvent.TRANSFORM_UPDATED, region);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            GroupListener listener = (GroupListener)i.next();
            listener.elementTransformUpdated(event);
        }
    }
}

