/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.event;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.InteractionElement;
import edu.berkeley.guir.damask.event.ElementContainerEvent;
import edu.berkeley.guir.damask.event.ElementContainerListener;
import java.util.Iterator;
import java.util.Vector;

public class ElementContainerSource {
    private Vector eventListeners = new Vector();

    public synchronized void addElementContainerListener(ElementContainerListener listener) {
        if (!this.eventListeners.contains(listener)) {
            this.eventListeners.add(listener);
        }
    }

    public synchronized void removeElementContainerListener(ElementContainerListener listener) {
        this.eventListeners.remove(listener);
    }

    public ElementContainerListener[] getElementContainerListeners() {
        return (ElementContainerListener[])this.eventListeners.toArray();
    }

    public void fireElementAdded(Object source, DeviceType deviceType, int index, InteractionElement e) {
        Vector el;
        ElementContainerSource elementContainerSource = this;
        synchronized (elementContainerSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        ElementContainerEvent event = new ElementContainerEvent(source, ElementContainerEvent.ADDED, deviceType, index, e);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            ElementContainerListener listener = (ElementContainerListener)i.next();
            listener.elementAdded(event);
        }
    }

    public void fireElementRemoved(Object source, DeviceType deviceType, int index, InteractionElement e) {
        Vector el;
        ElementContainerSource elementContainerSource = this;
        synchronized (elementContainerSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        ElementContainerEvent event = new ElementContainerEvent(source, ElementContainerEvent.REMOVED, deviceType, index, e);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            ElementContainerListener listener = (ElementContainerListener)i.next();
            listener.elementRemoved(event);
        }
    }
}

