/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.event;

import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.event.DialogEvent;
import edu.berkeley.guir.damask.event.DialogListener;
import java.util.Iterator;
import java.util.Vector;

public class DialogEventSource {
    private Vector eventListeners = new Vector();

    public synchronized void addDialogListener(DialogListener listener) {
        if (!this.eventListeners.contains(listener)) {
            this.eventListeners.add(listener);
        }
    }

    public synchronized void removeDialogListener(DialogListener listener) {
        this.eventListeners.remove(listener);
    }

    public void fireInitialConditionChanged(Dialog dialog, int newInitialCondition) {
        Vector el;
        DialogEventSource dialogEventSource = this;
        synchronized (dialogEventSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        DialogEvent event = new DialogEvent(dialog, DialogEvent.INITIAL_CONDITION_CHANGED, new Integer(newInitialCondition));
        Iterator i = el.iterator();
        while (i.hasNext()) {
            DialogListener listener = (DialogListener)i.next();
            listener.initialConditionChanged(event);
        }
    }
}

