/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.event;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.event.ControlEvent;
import edu.berkeley.guir.damask.event.ControlListener;
import java.util.Iterator;
import java.util.Vector;

public class ControlEventSource {
    private Vector eventListeners = new Vector();

    public synchronized void addControlListener(ControlListener listener) {
        if (!this.eventListeners.contains(listener)) {
            this.eventListeners.add(listener);
        }
    }

    public synchronized void removeControlListener(ControlListener listener) {
        this.eventListeners.remove(listener);
    }

    public void fireControlStateChanged(Control e, DeviceType deviceType) {
        Vector el;
        ControlEventSource controlEventSource = this;
        synchronized (controlEventSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        ControlEvent event = new ControlEvent(e, ControlEvent.STATE_CHANGED, deviceType);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            ControlListener listener = (ControlListener)i.next();
            listener.controlStateChanged(event);
        }
    }

    public void fireControlSignificanceChanged(Control e, DeviceType deviceType) {
        Vector el;
        ControlEventSource controlEventSource = this;
        synchronized (controlEventSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        ControlEvent event = new ControlEvent(e, ControlEvent.SIGNIFICANCE_CHANGED, deviceType);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            ControlListener listener = (ControlListener)i.next();
            listener.controlSignificanceChanged(event);
        }
    }

    public void firePageRegionChanged(Control e, DeviceType deviceType) {
        Vector el;
        ControlEventSource controlEventSource = this;
        synchronized (controlEventSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        ControlEvent event = new ControlEvent(e, ControlEvent.PAGE_REGION_CHANGED, deviceType);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            ControlListener listener = (ControlListener)i.next();
            listener.pageRegionChanged(event);
        }
    }
}

