/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.event;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.event.ContentEvent;
import edu.berkeley.guir.damask.event.ContentListener;
import java.awt.geom.GeneralPath;
import java.util.Iterator;
import java.util.Vector;

public class ContentEventSource {
    private Vector eventListeners = new Vector();

    public synchronized void addContentListener(ContentListener listener) {
        if (!this.eventListeners.contains(listener)) {
            this.eventListeners.add(listener);
        }
    }

    public synchronized void removeContentListener(ContentListener listener) {
        this.eventListeners.remove(listener);
    }

    public void fireStrokeAdded(Content e, GeneralPath path) {
        Vector el;
        ContentEventSource contentEventSource = this;
        synchronized (contentEventSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        ContentEvent event = new ContentEvent(e, ContentEvent.STROKE_ADDED, e.getDeviceType(), null, path);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            ContentListener listener = (ContentListener)i.next();
            listener.strokeAdded(event);
        }
    }

    public void fireStrokeRemoved(Content e, GeneralPath path) {
        Vector el;
        ContentEventSource contentEventSource = this;
        synchronized (contentEventSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        ContentEvent event = new ContentEvent(e, ContentEvent.STROKE_REMOVED, e.getDeviceType(), null, path);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            ContentListener listener = (ContentListener)i.next();
            listener.strokeRemoved(event);
        }
    }

    public void fireStrokesChanged(Content e) {
        Vector el;
        ContentEventSource contentEventSource = this;
        synchronized (contentEventSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        ContentEvent event = new ContentEvent(e, ContentEvent.STROKES_CHANGED, e.getDeviceType(), null, null);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            ContentListener listener = (ContentListener)i.next();
            listener.strokesChanged(event);
        }
    }

    public void fireTextChanged(Content e) {
        Vector el;
        ContentEventSource contentEventSource = this;
        synchronized (contentEventSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        ContentEvent event = new ContentEvent(e, ContentEvent.TEXT_CHANGED, e.getDeviceType(), null, null);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            ContentListener listener = (ContentListener)i.next();
            listener.textChanged(event);
        }
    }

    public void fireImageChanged(Content e) {
        Vector el;
        ContentEventSource contentEventSource = this;
        synchronized (contentEventSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        ContentEvent event = new ContentEvent(e, ContentEvent.IMAGE_CHANGED, e.getDeviceType(), null, null);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            ContentListener listener = (ContentListener)i.next();
            listener.imageChanged(event);
        }
    }

    public void firePreferredDisplayModeChanged(Content content, DeviceType deviceType, Content.DisplayMode oldMode, Content.DisplayMode newMode) {
        Vector el;
        ContentEventSource contentEventSource = this;
        synchronized (contentEventSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        ContentEvent event = new ContentEvent(content, ContentEvent.PREFERRED_DISPLAY_MODE_CHANGED, deviceType, oldMode, newMode);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            ContentListener listener = (ContentListener)i.next();
            listener.preferredDisplayModeChanged(event);
        }
    }

    public void firePromptTextIsSyncedWithText(Content content) {
        Vector el;
        ContentEventSource contentEventSource = this;
        synchronized (contentEventSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        ContentEvent event = new ContentEvent(content, ContentEvent.PROMPT_TEXT_SYNCED, content.getDeviceType(), null, null);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            ContentListener listener = (ContentListener)i.next();
            listener.promptTextIsSyncedWithText(event);
        }
    }

    public void firePromptTextIsUnsyncedWithText(Content content) {
        Vector el;
        ContentEventSource contentEventSource = this;
        synchronized (contentEventSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        ContentEvent event = new ContentEvent(content, ContentEvent.PROMPT_TEXT_UNSYNCED, content.getDeviceType(), null, null);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            ContentListener listener = (ContentListener)i.next();
            listener.promptTextIsUnsyncedWithText(event);
        }
    }
}

