/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.event;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.component.Content;
import java.util.EventObject;

public class ContentEvent
extends EventObject {
    private final Type eventType;
    private final DeviceType deviceType;
    private final Object oldValue;
    private final Object newValue;
    public static final Type STROKE_ADDED = new Type("stroke added");
    public static final Type STROKE_REMOVED = new Type("stroke removed");
    public static final Type STROKES_CHANGED = new Type("strokes changed");
    public static final Type TEXT_CHANGED = new Type("text changed");
    public static final Type IMAGE_CHANGED = new Type("image changed");
    public static final Type PREFERRED_DISPLAY_MODE_CHANGED = new Type("content's preferred display mode changed");
    public static final Type PROMPT_TEXT_SYNCED = new Type("content's prompt text is synchronized with its text");
    public static final Type PROMPT_TEXT_UNSYNCED = new Type("content's prompt text is not synchronized with its text");

    public ContentEvent(Content source, Type eventType, DeviceType deviceType, Object oldValue, Object newValue) {
        super(source);
        this.eventType = eventType;
        this.deviceType = deviceType;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public Content getContent() {
        return (Content)this.source;
    }

    public Type getEventType() {
        return this.eventType;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public static class Type {
        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

