/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.event;

import edu.berkeley.guir.damask.connection.Connection;
import edu.berkeley.guir.damask.connection.ConnectionSource;
import edu.berkeley.guir.damask.event.ConnectionSourceEvent;
import edu.berkeley.guir.damask.event.ConnectionSourceListener;
import java.util.Iterator;
import java.util.Vector;

public class ConnectionSourceEventSource {
    private Vector eventListeners = new Vector();

    public synchronized void addConnectionSourceListener(ConnectionSourceListener listener) {
        if (!this.eventListeners.contains(listener)) {
            this.eventListeners.add(listener);
        }
    }

    public synchronized void removeConnectionSourceListener(ConnectionSourceListener listener) {
        this.eventListeners.remove(listener);
    }

    public void fireOutConnectionAdded(ConnectionSource e, Connection connection) {
        Vector el;
        ConnectionSourceEventSource connectionSourceEventSource = this;
        synchronized (connectionSourceEventSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        ConnectionSourceEvent event = new ConnectionSourceEvent(e, ConnectionSourceEvent.OUT_CONNECTION_ADDED, connection);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            ConnectionSourceListener listener = (ConnectionSourceListener)i.next();
            listener.outConnectionAdded(event);
        }
    }

    public void fireOutConnectionRemoved(ConnectionSource e, Connection connection) {
        Vector el;
        ConnectionSourceEventSource connectionSourceEventSource = this;
        synchronized (connectionSourceEventSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        ConnectionSourceEvent event = new ConnectionSourceEvent(e, ConnectionSourceEvent.OUT_CONNECTION_REMOVED, connection);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            ConnectionSourceListener listener = (ConnectionSourceListener)i.next();
            listener.outConnectionRemoved(event);
        }
    }
}

