/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.event;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.connection.Connection;
import edu.berkeley.guir.damask.connection.ConnectionDest;
import edu.berkeley.guir.damask.connection.ConnectionSource;
import edu.berkeley.guir.damask.event.ConnectionEvent;
import edu.berkeley.guir.damask.event.ConnectionListener;
import edu.berkeley.guir.damask.userevent.DamaskUserEvent;
import java.awt.Shape;
import java.util.Iterator;
import java.util.Vector;

public class ConnectionEventSource {
    private Vector eventListeners = new Vector();

    public synchronized void addConnectionListener(ConnectionListener listener) {
        if (!this.eventListeners.contains(listener)) {
            this.eventListeners.add(listener);
        }
    }

    public synchronized void removeConnectionListener(ConnectionListener listener) {
        this.eventListeners.remove(listener);
    }

    public void fireSourceChanged(Connection connection, DeviceType deviceType, ConnectionSource oldSource, ConnectionSource newSource) {
        Vector el;
        ConnectionEventSource connectionEventSource = this;
        synchronized (connectionEventSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        ConnectionEvent event = new ConnectionEvent(connection, ConnectionEvent.SOURCE_CHANGED, deviceType, oldSource, newSource);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            ConnectionListener listener = (ConnectionListener)i.next();
            listener.sourceChanged(event);
        }
    }

    public void fireDestChanged(Connection connection, DeviceType deviceType, ConnectionDest oldDest, ConnectionDest newDest) {
        Vector el;
        ConnectionEventSource connectionEventSource = this;
        synchronized (connectionEventSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        ConnectionEvent event = new ConnectionEvent(connection, ConnectionEvent.DEST_CHANGED, deviceType, oldDest, newDest);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            ConnectionListener listener = (ConnectionListener)i.next();
            listener.destChanged(event);
        }
    }

    public void fireShapeChanged(Connection connection, DeviceType deviceType, Shape oldShape, Shape newShape) {
        Vector el;
        ConnectionEventSource connectionEventSource = this;
        synchronized (connectionEventSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        ConnectionEvent event = new ConnectionEvent(connection, ConnectionEvent.SHAPE_CHANGED, deviceType, oldShape, newShape);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            ConnectionListener listener = (ConnectionListener)i.next();
            listener.shapeChanged(event);
        }
    }

    public void fireUserEventChanged(Connection connection, DamaskUserEvent oldEvent, DamaskUserEvent newEvent) {
        Vector el;
        ConnectionEventSource connectionEventSource = this;
        synchronized (connectionEventSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        ConnectionEvent event = new ConnectionEvent(connection, ConnectionEvent.USER_EVENT_CHANGED, DeviceType.ALL, oldEvent, newEvent);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            ConnectionListener listener = (ConnectionListener)i.next();
            listener.userEventChanged(event);
        }
    }

    public void fireConditionChanged(Connection connection, int oldCondition, int newCondition) {
        Vector el;
        ConnectionEventSource connectionEventSource = this;
        synchronized (connectionEventSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        ConnectionEvent event = new ConnectionEvent(connection, ConnectionEvent.CONDITION_CHANGED, DeviceType.ALL, new Integer(oldCondition), new Integer(newCondition));
        Iterator i = el.iterator();
        while (i.hasNext()) {
            ConnectionListener listener = (ConnectionListener)i.next();
            listener.conditionChanged(event);
        }
    }
}

