/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.event;

import edu.berkeley.guir.damask.connection.Connection;
import edu.berkeley.guir.damask.connection.ConnectionDest;
import edu.berkeley.guir.damask.event.ConnectionDestEvent;
import edu.berkeley.guir.damask.event.ConnectionDestListener;
import java.util.Iterator;
import java.util.Vector;

public class ConnectionDestEventSource {
    private Vector eventListeners = new Vector();

    public synchronized void addConnectionDestListener(ConnectionDestListener listener) {
        if (!this.eventListeners.contains(listener)) {
            this.eventListeners.add(listener);
        }
    }

    public synchronized void removeConnectionDestListener(ConnectionDestListener listener) {
        this.eventListeners.remove(listener);
    }

    public void fireInConnectionAdded(ConnectionDest e, Connection connection) {
        Vector el;
        ConnectionDestEventSource connectionDestEventSource = this;
        synchronized (connectionDestEventSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        ConnectionDestEvent event = new ConnectionDestEvent(e, ConnectionDestEvent.IN_CONNECTION_ADDED, connection);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            ConnectionDestListener listener = (ConnectionDestListener)i.next();
            listener.inConnectionAdded(event);
        }
    }

    public void fireInConnectionRemoved(ConnectionDest e, Connection connection) {
        Vector el;
        ConnectionDestEventSource connectionDestEventSource = this;
        synchronized (connectionDestEventSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        ConnectionDestEvent event = new ConnectionDestEvent(e, ConnectionDestEvent.IN_CONNECTION_REMOVED, connection);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            ConnectionDestListener listener = (ConnectionDestListener)i.next();
            listener.inConnectionRemoved(event);
        }
    }
}

