/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.dialog;

import edu.berkeley.guir.damask.AbstractInteractionElement;
import edu.berkeley.guir.damask.DamaskUtils;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.Direction;
import edu.berkeley.guir.damask.InteractionElement;
import edu.berkeley.guir.damask.InteractionGraph;
import edu.berkeley.guir.damask.Orientation;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.event.ElementContainerListener;
import edu.berkeley.guir.damask.event.ElementContainerSource;
import edu.berkeley.guir.damask.event.InteractionElementEvent;
import edu.berkeley.guir.damask.event.InteractionElementListener;
import edu.berkeley.guir.lib.util.StringLib;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PageRegion
extends AbstractInteractionElement {
    private Page page;
    private final Direction name;
    private int inset;
    private List controls = new ArrayList();
    private Map controlVoiceYDistances = new HashMap();
    private final Orientation orientation;
    private PageBoundsHandler pageBoundsHandler = new PageBoundsHandler();
    private ElementContainerSource containerEventSource = new ElementContainerSource();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.dialog.PageRegion");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public PageRegion(Page page, Direction name) {
        this.page = page;
        this.name = name;
        this.inset = this.getDeviceType().getDefaultInset(name);
        this.orientation = this.getDeviceType().getOrientation(name);
    }

    protected void initListeners() {
        this.page.addInteractionElementListener(this.pageBoundsHandler);
        if (this.name == Direction.EAST || this.name == Direction.WEST || this.name == Direction.CENTER) {
            PageRegion southRegion;
            PageRegion northRegion = this.page.getRegion(Direction.NORTH);
            if (northRegion != null) {
                northRegion.addInteractionElementListener(this.pageBoundsHandler);
            }
            if ((southRegion = this.page.getRegion(Direction.SOUTH)) != null) {
                southRegion.addInteractionElementListener(this.pageBoundsHandler);
            }
        }
    }

    public Page getPage() {
        return this.page;
    }

    public InteractionGraph getInteractionGraph() {
        Page p = this.getPage();
        if (p != null) {
            return p.getInteractionGraph();
        }
        return null;
    }

    public Direction getName() {
        return this.name;
    }

    public List getControls() {
        return Collections.unmodifiableList(this.controls);
    }

    protected final void add(Control child) {
        this.add(this.controls.size(), child);
    }

    protected void add(int index, Control child) {
        PageRegion oldRegion = child.getPageRegion(this.getDeviceType());
        if (oldRegion != null) {
            oldRegion.remove(child);
        }
        this.prepareLayoutVoiceControls();
        this.controls.add(index, child);
        child.setPageRegion(this.getDeviceType(), this);
        this.fireElementAdded(index, child);
        this.layoutVoiceControls();
    }

    protected void addAfter(Control insertAfterMe, Control child) {
        int index;
        if (insertAfterMe != null) {
            int indexOfInsertAfterMe = this.controls.indexOf(insertAfterMe);
            if (indexOfInsertAfterMe < 0) {
                throw new IllegalArgumentException(insertAfterMe + " is not in " + this);
            }
            index = indexOfInsertAfterMe + 1;
        } else {
            index = 0;
        }
        this.add(index, child);
    }

    protected boolean remove(Control control) {
        control.setPageRegion(this.getDeviceType(), null);
        int index = this.controls.indexOf(control);
        if (index != -1) {
            this.prepareLayoutVoiceControls();
            this.controls.remove(control);
            this.fireElementRemoved(index, control);
            this.layoutVoiceControls();
            return true;
        }
        return false;
    }

    public Control getPreviousControl(Control control) {
        List controls = this.getControls();
        if (control == null) {
            if (controls.size() == 0) {
                return null;
            }
            return (Control)controls.get(controls.size() - 1);
        }
        int childIndex = controls.indexOf(control);
        if (childIndex == -1) {
            throw new IllegalArgumentException(control + " is not in " + this);
        }
        if (childIndex > 0) {
            return (Control)controls.get(childIndex - 1);
        }
        return null;
    }

    public Control getNextControl(Control control) {
        List controls = this.getControls();
        if (control == null) {
            if (controls.size() == 0) {
                return null;
            }
            return (Control)controls.get(0);
        }
        int childIndex = controls.indexOf(control);
        if (childIndex == -1) {
            throw new IllegalArgumentException(control + " is not in " + this);
        }
        if (childIndex < controls.size() - 1) {
            return (Control)controls.get(childIndex + 1);
        }
        return null;
    }

    public String toLongString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.toString());
        String controlsStr = this.controlsToString(1);
        if (controlsStr.length() != 0) {
            sb.append('\n');
            sb.append(controlsStr);
        }
        return sb.toString();
    }

    public String toLongString(int indentLevel, DeviceType deviceType) {
        if (!$assertionsDisabled && deviceType == DeviceType.ALL) {
            throw new AssertionError((Object)"Device cannot be ALL");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(StringLib.spaces(indentLevel * DamaskUtils.INDENT_SPACES));
        sb.append(this.toString());
        String controlsStr = this.controlsToString(indentLevel + 1);
        if (controlsStr.length() != 0) {
            sb.append('\n');
            sb.append(controlsStr);
        }
        return sb.toString();
    }

    private String controlsToString(int indentLevel) {
        StringBuffer sb = new StringBuffer();
        Iterator i = this.controls.iterator();
        while (i.hasNext()) {
            InteractionElement e = (InteractionElement)i.next();
            sb.append(e.toLongString(indentLevel, this.getDeviceType()));
            if (!i.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public int getInset() {
        return this.inset;
    }

    public void setInset(int inset) {
        this.inset = inset;
        this.updateBoundsAndTransform();
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public DeviceType getDeviceType() {
        if (this.page == null) {
            return null;
        }
        return this.page.getDeviceType();
    }

    public Set getDeviceTypesVisibleTo() {
        HashSet<DeviceType> deviceTypes = new HashSet<DeviceType>();
        DeviceType deviceType = this.getDeviceType();
        if (deviceType != null) {
            deviceTypes.add(deviceType);
        }
        return deviceTypes;
    }

    public Rectangle2D getBounds() {
        return this.getBounds(this.getDeviceType());
    }

    protected void setBounds(Rectangle2D bounds) {
        this.setBounds(this.getDeviceType(), bounds);
    }

    public AffineTransform getTransform() {
        return this.getTransform(this.getDeviceType());
    }

    protected void setTransform(AffineTransform transform) {
        this.setTransform(this.getDeviceType(), transform);
    }

    protected void updateBoundsAndTransform() {
        if (this.page.getBounds() == null) {
            return;
        }
        double width = this.page.getBounds().getWidth();
        double height = this.page.getBounds().getHeight();
        if (this.name == Direction.NORTH) {
            this.setBounds(new Rectangle2D.Double(0.0, 0.0, width, this.inset));
        } else if (this.name == Direction.SOUTH) {
            this.setBounds(new Rectangle2D.Double(0.0, 0.0, width, this.inset));
            this.setTransform(AffineTransform.getTranslateInstance(0.0, height - (double)this.inset));
        } else {
            int northInset = this.page.getRegionInset(Direction.NORTH);
            int southInset = this.page.getRegionInset(Direction.SOUTH);
            if (this.name == Direction.WEST) {
                this.setBounds(new Rectangle2D.Double(0.0, 0.0, this.inset, height - (double)southInset - (double)northInset));
                this.setTransform(AffineTransform.getTranslateInstance(0.0, northInset));
            } else if (this.name == Direction.EAST) {
                this.setBounds(new Rectangle2D.Double(0.0, 0.0, this.inset, height - (double)southInset - (double)northInset));
                this.setTransform(AffineTransform.getTranslateInstance(width - (double)this.inset, northInset));
            } else {
                int eastInset = this.page.getRegionInset(Direction.EAST);
                int westInset = this.page.getRegionInset(Direction.WEST);
                this.setBounds(new Rectangle2D.Double(0.0, 0.0, width - (double)westInset - (double)eastInset, height - (double)southInset - (double)northInset));
                this.setTransform(AffineTransform.getTranslateInstance(westInset, northInset));
            }
        }
    }

    public void prepareLayoutVoiceControls() {
        if (this.getDeviceType() == DeviceType.VOICE) {
            this.controlVoiceYDistances.clear();
            Control control = DamaskUtils.getNextControlWithPrompt(this, null);
            Control prevControl = null;
            while (control != null) {
                if (prevControl != null) {
                    this.controlVoiceYDistances.put(control, new Double(control.getBoundsInParentCoords(DeviceType.VOICE).getY() - prevControl.getBoundsInParentCoords(DeviceType.VOICE).getY()));
                } else {
                    this.controlVoiceYDistances.put(control, new Double(Double.POSITIVE_INFINITY));
                }
                prevControl = control;
                control = DamaskUtils.getNextControlWithPrompt(this, prevControl);
            }
        }
    }

    public void layoutVoiceControls() {
        if (this.getDeviceType() == DeviceType.VOICE) {
            Control control = DamaskUtils.getNextControlWithPrompt(this, null);
            Control prevControl = null;
            while (control != null) {
                Double oldDyObject;
                if (prevControl != null && (oldDyObject = (Double)this.controlVoiceYDistances.get(control)) != null) {
                    double oldDy = oldDyObject;
                    double newDy = control.getBoundsInParentCoords(DeviceType.VOICE).getY() - prevControl.getBoundsInParentCoords(DeviceType.VOICE).getY();
                    if (newDy != oldDy) {
                        AffineTransform transform = control.getTransform(DeviceType.VOICE);
                        if (oldDy == Double.POSITIVE_INFINITY) {
                            transform.preConcatenate(AffineTransform.getTranslateInstance(0.0, 225.0));
                        } else {
                            transform.preConcatenate(AffineTransform.getTranslateInstance(0.0, oldDy - newDy));
                        }
                        control.setTransform(DeviceType.VOICE, transform);
                    }
                }
                prevControl = control;
                control = DamaskUtils.getNextControlWithPrompt(this, prevControl);
            }
        }
    }

    public void addElementContainerListener(ElementContainerListener listener) {
        this.containerEventSource.addElementContainerListener(listener);
    }

    public void removeElementContainerListener(ElementContainerListener listener) {
        this.containerEventSource.removeElementContainerListener(listener);
    }

    private void fireElementAdded(int index, InteractionElement e) {
        this.containerEventSource.fireElementAdded(this, this.getDeviceType(), index, e);
    }

    private void fireElementRemoved(int index, InteractionElement e) {
        this.containerEventSource.fireElementRemoved(this, this.getDeviceType(), index, e);
    }

    public String toString() {
        return String.valueOf(this.page.toString()) + " - " + this.name + " - " + super.toString();
    }

    public Object clone() {
        return this.clone(null, new HashMap());
    }

    protected Object clone(Page clonePage, Map elementClones) {
        PageRegion clone = (PageRegion)super.clone();
        clone.page = clonePage;
        clone.controls = new ArrayList();
        clone.containerEventSource = new ElementContainerSource();
        Iterator i = this.controls.iterator();
        while (i.hasNext()) {
            Control control = (Control)i.next();
            Control controlClone = (Control)elementClones.get(control);
            if (controlClone == null) {
                controlClone = (Control)control.clone();
                elementClones.put(control, controlClone);
            }
            Map origResponseLines = control.getVoiceResponseLines();
            clone.add(controlClone);
            Iterator m = origResponseLines.keySet().iterator();
            while (m.hasNext()) {
                Integer condition = (Integer)m.next();
                Line2D line = (Line2D)origResponseLines.get(condition);
                controlClone.setVoiceResponseLine(condition, line);
            }
        }
        return clone;
    }

    private class PageBoundsHandler
    implements InteractionElementListener {
        PageBoundsHandler() {
        }

        public void elementBoundsUpdated(InteractionElementEvent e) {
            PageRegion.this.updateBoundsAndTransform();
        }

        public void elementTransformUpdated(InteractionElementEvent e) {
            PageRegion.this.updateBoundsAndTransform();
        }

        public void elementBorderUpdated(InteractionElementEvent e) {
        }
    }
}

