/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.dialog;

import edu.berkeley.guir.damask.AbstractInteractionElement;
import edu.berkeley.guir.damask.DamaskUtils;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.Direction;
import edu.berkeley.guir.damask.InteractionGraph;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.connection.Connection;
import edu.berkeley.guir.damask.connection.ConnectionDest;
import edu.berkeley.guir.damask.connection.ConnectionSource;
import edu.berkeley.guir.damask.connection.OrgConnection;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.damask.dialog.TemplateDialog;
import edu.berkeley.guir.damask.event.ConnectionDestEventSource;
import edu.berkeley.guir.damask.event.ConnectionDestListener;
import edu.berkeley.guir.damask.event.ConnectionSourceEventSource;
import edu.berkeley.guir.damask.event.ConnectionSourceListener;
import edu.berkeley.guir.damask.event.PageEventSource;
import edu.berkeley.guir.damask.event.PageListener;
import edu.berkeley.guir.damask.view.DamaskAppExceptionHandler;
import edu.berkeley.guir.lib.awt.geom.GeomLib;
import edu.berkeley.guir.lib.util.StringLib;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Page
extends AbstractInteractionElement
implements ConnectionSource,
ConnectionDest {
    private Dialog dialog;
    private final DeviceType deviceType;
    private Map regions = new HashMap();
    private final List templates = new ArrayList();
    private Content title;
    private Set outOrgConnections = new HashSet();
    private Set inConnections = new HashSet();
    private PageEventSource pageEventSource = new PageEventSource();
    private ConnectionSourceEventSource connectionSourceEventSource = new ConnectionSourceEventSource();
    private ConnectionDestEventSource connectionDestEventSource = new ConnectionDestEventSource();

    public Page(DeviceType deviceType, Dialog dialog, Content title) {
        PageRegion region;
        this.dialog = dialog;
        this.title = title;
        this.deviceType = deviceType;
        this.setBounds(new Rectangle2D.Double(0.0, 0.0, deviceType.getDefaultWidth(), deviceType.getDefaultHeight()));
        this.setTransform(deviceType, new AffineTransform());
        Iterator i = deviceType.getRegionNames().iterator();
        while (i.hasNext()) {
            Direction name = (Direction)i.next();
            this.regions.put(name, new PageRegion(this, name));
        }
        i = this.getRegions().iterator();
        while (i.hasNext()) {
            region = (PageRegion)i.next();
            region.updateBoundsAndTransform();
        }
        i = this.getRegions().iterator();
        while (i.hasNext()) {
            region = (PageRegion)i.next();
            region.initListeners();
        }
    }

    public Page(DeviceType deviceType, Dialog dialog, Page oldPage, Map controlCopies) {
        this(deviceType, dialog, (Content)controlCopies.get(oldPage.getTitle()));
        Iterator i = oldPage.getRegions().iterator();
        while (i.hasNext()) {
            PageRegion oldRegion = (PageRegion)i.next();
            PageRegion newRegion = this.getRegion(oldRegion.getName());
            Iterator j = oldRegion.getControls().iterator();
            while (j.hasNext()) {
                Control oldControl = (Control)j.next();
                Control newControl = (Control)controlCopies.get(oldControl);
                newRegion.add(newControl);
            }
        }
        this.setTransform(oldPage.getTransform());
    }

    public void dispose() {
        Iterator<Object> i = this.regions.values().iterator();
        while (i.hasNext()) {
            PageRegion region = (PageRegion)i.next();
            Iterator j = new ArrayList(region.getControls()).iterator();
            while (j.hasNext()) {
                Control control = (Control)j.next();
                region.remove(control);
                control.dispose();
            }
        }
        i = this.outOrgConnections.iterator();
        while (i.hasNext()) {
            OrgConnection out = (OrgConnection)i.next();
            out.getInteractionGraph().remove(out);
        }
        this.outOrgConnections.clear();
        this.outOrgConnections = null;
        i = this.inConnections.iterator();
        while (i.hasNext()) {
            Connection in = (Connection)i.next();
            in.getInteractionGraph().remove(in);
        }
        this.inConnections.clear();
        this.inConnections = null;
        this.regions.clear();
        this.regions = null;
        this.dialog = null;
    }

    public Page getPage(DeviceType deviceType) {
        deviceType.verifyIsEqual(this.getDeviceType());
        return this;
    }

    public Dialog getDialog() {
        return this.dialog;
    }

    protected void setDialog(Dialog dialog) {
        this.dialog = dialog;
    }

    public Collection getRegions() {
        return Collections.unmodifiableCollection(this.regions.values());
    }

    public Set getRegionNames() {
        return this.getDeviceType().getRegionNames();
    }

    public PageRegion getRegion(Direction name) {
        return (PageRegion)this.regions.get(name);
    }

    public int getRegionInset(Direction regionName) {
        if (this.getRegionNames().contains(regionName)) {
            return this.getRegion(regionName).getInset();
        }
        return 0;
    }

    public Content getTitle() {
        return this.title;
    }

    public Rectangle2D getBounds() {
        return this.getBounds(this.deviceType);
    }

    public void setBounds(Rectangle2D bounds) {
        this.setBounds(this.deviceType, bounds);
    }

    public AffineTransform getTransform() {
        return this.getTransform(this.deviceType);
    }

    public void setTransform(AffineTransform bounds) {
        this.setTransform(this.deviceType, bounds);
    }

    protected AffineTransform getGlobalTransform(DeviceType deviceType) {
        AffineTransform transform = this.getTransform(deviceType);
        Dialog dialog = this.getDialog();
        if (dialog != null) {
            transform.preConcatenate(dialog.getTransform(deviceType));
        }
        return transform;
    }

    public Rectangle2D localToGlobal(DeviceType deviceType, Rectangle2D rect) {
        return GeomLib.transformRectangle(this.getGlobalTransform(deviceType), rect);
    }

    public Rectangle2D globalToLocal(DeviceType deviceType, Rectangle2D rect) {
        try {
            return GeomLib.transformRectangle(this.getGlobalTransform(deviceType).createInverse(), rect);
        }
        catch (NoninvertibleTransformException e) {
            DamaskAppExceptionHandler.log(e);
            return null;
        }
    }

    public Page split(Collection controls) {
        Page newPage = new Page(this.getDeviceType(), this.getDialog(), (Content)this.getTitle().clone());
        AffineTransform transform = this.getTransform();
        if (this.getDeviceType() != DeviceType.VOICE) {
            transform.preConcatenate(AffineTransform.getTranslateInstance(0.0, this.getBounds().getHeight() + 50.0));
        }
        newPage.setTransform(transform);
        Dialog d = this.getDialog();
        d.add(d.indexOf(this) + 1, newPage);
        PageRegion newPageCenter = newPage.getRegion(Direction.CENTER);
        Iterator i = controls.iterator();
        while (i.hasNext()) {
            Control control = (Control)i.next();
            if (!control.getPageRegion(this.getDeviceType()).equals(this.getRegion(Direction.CENTER))) continue;
            newPageCenter.add(control);
            Iterator j = control.getOutConnections().iterator();
            while (j.hasNext()) {
                Connection outConnection = (Connection)j.next();
                if (!outConnection.isVisibleToDeviceType(this.getDeviceType())) continue;
                outConnection.refresh(this.getDeviceType());
            }
        }
        i = Direction.getValues().iterator();
        while (i.hasNext()) {
            PageRegion oldRegion;
            Direction name = (Direction)i.next();
            if (name == Direction.CENTER || (oldRegion = this.getRegion(name)) == null) continue;
            PageRegion newRegion = newPage.getRegion(name);
            Iterator j = oldRegion.getControls().iterator();
            while (j.hasNext()) {
                Control oldControl = (Control)j.next();
                newRegion.add((Control)oldControl.createCopy(this.getDeviceType()));
            }
        }
        return newPage;
    }

    public void mergeWithAdjacent() {
        Dialog d = this.getDialog();
        Page page2 = d.getPage(this.getDeviceType(), d.indexOf(this) + 1);
        if (page2 != null) {
            this.merge(page2);
        }
    }

    public void merge(Page page2) {
        Dialog d = this.getDialog();
        DamaskUtils.checkValidArgument(page2.getDialog() == d, page2 + " must be in the same dialog as " + this + ", which is " + d);
        Iterator i = this.getRegions().iterator();
        while (i.hasNext()) {
            PageRegion region = (PageRegion)i.next();
            ArrayList page2Controls = new ArrayList(page2.getRegion(region.getName()).getControls());
            Iterator j = page2Controls.iterator();
            while (j.hasNext()) {
                Control control = (Control)j.next();
                region.add(control);
                Iterator k = control.getOutConnections().iterator();
                while (k.hasNext()) {
                    Connection outConnection = (Connection)k.next();
                    if (!outConnection.isVisibleToDeviceType(this.getDeviceType())) continue;
                    outConnection.refresh(this.getDeviceType());
                }
            }
        }
        this.takeConnections(page2);
        d.remove(page2);
    }

    protected void takeConnections(Page page2) {
        HashSet page2OutConnections = new HashSet(page2.getOutConnections());
        Iterator i = page2OutConnections.iterator();
        while (i.hasNext()) {
            OrgConnection c = (OrgConnection)i.next();
            c.setSource(this.getDeviceType(), this);
        }
        HashSet page2InConnections = new HashSet(page2.getInConnections());
        Iterator i2 = page2InConnections.iterator();
        while (i2.hasNext()) {
            Connection c = (Connection)i2.next();
            c.adjustDestPage(this.getDeviceType(), this);
        }
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public Set getDeviceTypesVisibleTo() {
        HashSet<DeviceType> deviceTypes = new HashSet<DeviceType>();
        deviceTypes.add(this.deviceType);
        return deviceTypes;
    }

    public InteractionGraph getInteractionGraph() {
        Dialog d = this.getDialog();
        if (d != null) {
            return d.getInteractionGraph();
        }
        return null;
    }

    public Collection getOutConnections() {
        return Collections.unmodifiableCollection(this.outOrgConnections);
    }

    public void addOutConnection(Connection outConnection) {
        if (!this.outOrgConnections.contains(outConnection)) {
            this.outOrgConnections.add(outConnection);
            this.fireOutConnectionAdded(outConnection);
        }
    }

    public void removeOutConnection(Connection outConnection) {
        if (this.outOrgConnections.contains(outConnection)) {
            this.outOrgConnections.remove(outConnection);
            this.fireOutConnectionRemoved(outConnection);
        }
    }

    public boolean containsOutConnectionWithDest(ConnectionDest dest) {
        Iterator i = this.getOutConnections().iterator();
        while (i.hasNext()) {
            Connection connection = (Connection)i.next();
            Iterator j = connection.getDeviceTypesVisibleTo().iterator();
            while (j.hasNext()) {
                DeviceType aDeviceType = (DeviceType)j.next();
                if (connection.getConnectionDest(aDeviceType) != dest) continue;
                return true;
            }
        }
        return false;
    }

    public Collection getInConnections() {
        return Collections.unmodifiableCollection(this.inConnections);
    }

    public void addInConnection(Connection inConnection) {
        if (!this.inConnections.contains(inConnection)) {
            this.inConnections.add(inConnection);
            this.fireInConnectionAdded(inConnection);
        }
    }

    public void removeInConnection(Connection inConnection) {
        if (this.inConnections.contains(inConnection)) {
            this.inConnections.remove(inConnection);
            this.fireInConnectionRemoved(inConnection);
        }
    }

    public boolean containsInConnectionWithSource(ConnectionSource source) {
        Iterator i = this.getInConnections().iterator();
        while (i.hasNext()) {
            Connection connection = (Connection)i.next();
            Iterator j = connection.getDeviceTypesVisibleTo().iterator();
            while (j.hasNext()) {
                DeviceType aDeviceType = (DeviceType)j.next();
                if (connection.getConnectionSource(aDeviceType) != source) continue;
                return true;
            }
        }
        return false;
    }

    public List getTemplates() {
        return Collections.unmodifiableList(this.templates);
    }

    public void addTemplate(Page template) {
        DamaskUtils.checkValidArgument(template.isTemplate(), template + " is not a template");
        this.templates.add(template);
        this.fireTemplateAdded(template);
    }

    public boolean removeTemplate(Page template) {
        DamaskUtils.checkValidArgument(template.isTemplate(), template + " is not a template");
        boolean wasRemoved = this.templates.remove(template);
        if (wasRemoved) {
            this.fireTemplateRemoved(template);
        }
        return wasRemoved;
    }

    public boolean isTemplate() {
        return this.getDialog() instanceof TemplateDialog;
    }

    public void addPageListener(PageListener listener) {
        this.pageEventSource.addPageListener(listener);
    }

    public void removePageListener(PageListener listener) {
        this.pageEventSource.removePageListener(listener);
    }

    protected void fireTemplateAdded(Page newTemplate) {
        this.pageEventSource.fireTemplateAdded(this, newTemplate);
    }

    protected void fireTemplateRemoved(Page oldTemplate) {
        this.pageEventSource.fireTemplateRemoved(this, oldTemplate);
    }

    public void addConnectionDestListener(ConnectionDestListener listener) {
        this.connectionDestEventSource.addConnectionDestListener(listener);
    }

    public void removeConnectionDestListener(ConnectionDestListener listener) {
        this.connectionDestEventSource.removeConnectionDestListener(listener);
    }

    protected void fireInConnectionAdded(Connection connection) {
        this.connectionDestEventSource.fireInConnectionAdded(this, connection);
    }

    protected void fireInConnectionRemoved(Connection connection) {
        this.connectionDestEventSource.fireInConnectionRemoved(this, connection);
    }

    public void addConnectionSourceListener(ConnectionSourceListener listener) {
        this.connectionSourceEventSource.addConnectionSourceListener(listener);
    }

    public void removeConnectionSourceListener(ConnectionSourceListener listener) {
        this.connectionSourceEventSource.removeConnectionSourceListener(listener);
    }

    protected void fireOutConnectionAdded(Connection connection) {
        this.connectionSourceEventSource.fireOutConnectionAdded(this, connection);
    }

    protected void fireOutConnectionRemoved(Connection connection) {
        this.connectionSourceEventSource.fireOutConnectionRemoved(this, connection);
    }

    public Object clone() {
        return this.clone(null, new HashMap());
    }

    protected Object clone(Dialog cloneDialog, Map elementClones) {
        Page clone = (Page)super.clone();
        clone.dialog = cloneDialog;
        clone.pageEventSource = new PageEventSource();
        clone.regions = new HashMap();
        Iterator i = this.regions.keySet().iterator();
        while (i.hasNext()) {
            Direction name = (Direction)i.next();
            PageRegion clonePageRegion = (PageRegion)this.getRegion(name).clone(clone, elementClones);
            clone.regions.put(name, clonePageRegion);
        }
        clone.outOrgConnections = new HashSet();
        clone.inConnections = new HashSet();
        clone.title = (Content)elementClones.get(this.title);
        if (clone.title == null) {
            clone.title = (Content)this.title.clone();
        }
        return clone;
    }

    public String toLongString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.toString());
        sb.append("\n");
        Iterator i = this.regions.keySet().iterator();
        while (i.hasNext()) {
            Direction name = (Direction)i.next();
            PageRegion region = (PageRegion)this.regions.get(name);
            if (region.getControls().size() == 0) continue;
            sb.append(region.toLongString(1, this.getDeviceType()));
            if (!i.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toLongString(int indentLevel, DeviceType aDeviceType) {
        if (aDeviceType != this.deviceType) {
            throw new IllegalArgumentException("aDeviceType must match getDeviceType()");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(StringLib.spaces(indentLevel * DamaskUtils.INDENT_SPACES));
        sb.append(this.toString());
        sb.append("\n");
        Iterator i = this.regions.keySet().iterator();
        while (i.hasNext()) {
            Direction name = (Direction)i.next();
            PageRegion region = (PageRegion)this.regions.get(name);
            if (region.getControls().size() == 0) continue;
            sb.append(region.toLongString(indentLevel + 1, aDeviceType));
            if (!i.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public Rectangle2D getVoiceResponseDestBounds() {
        Dialog dialog = this.getDialog();
        List controls = this.getRegion(Direction.CENTER).getControls();
        if (dialog.indexOf(this) == 0 || controls.isEmpty()) {
            Rectangle2D dialogBounds = dialog.getBounds(DeviceType.VOICE);
            return new Rectangle2D.Double(dialogBounds.getX(), dialogBounds.getY(), dialogBounds.getWidth(), 1.0);
        }
        return ((Control)controls.get(0)).getVoicePromptBounds();
    }
}

