/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.dialog;

import edu.berkeley.guir.damask.AbstractInteractionElement;
import edu.berkeley.guir.damask.Damask;
import edu.berkeley.guir.damask.DamaskUtils;
import edu.berkeley.guir.damask.DeviceDependentContainer;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.Direction;
import edu.berkeley.guir.damask.InteractionGraph;
import edu.berkeley.guir.damask.component.Component;
import edu.berkeley.guir.damask.component.ComponentGroup;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.damask.event.DialogEventSource;
import edu.berkeley.guir.damask.event.ElementContainerListener;
import edu.berkeley.guir.damask.event.ElementContainerSource;
import edu.berkeley.guir.lib.util.StringLib;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Dialog
extends AbstractInteractionElement {
    private InteractionGraph graph = null;
    private DeviceDependentContainer pages = new DeviceDependentContainer();
    private DeviceType deviceType;
    private List groups = new ArrayList();
    private int numConditions = 0;
    private int initialCondition = 0;
    private ElementContainerSource containerEventSource = new ElementContainerSource();
    private DialogEventSource dialogEventSource = new DialogEventSource();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.dialog.Dialog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public Dialog(DeviceType deviceType, Content pageTitle) {
        this.deviceType = deviceType;
        Iterator i = deviceType.getSpecificDeviceTypes().iterator();
        while (i.hasNext()) {
            DeviceType aDeviceType = (DeviceType)i.next();
            Page page = new Page(aDeviceType, this, pageTitle);
            this.basicAdd(page);
        }
        this.setBounds(deviceType, new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0));
        this.setTransform(deviceType, new AffineTransform());
        if (this.isVisibleToDeviceType(DeviceType.VOICE)) {
            this.setBounds(DeviceType.VOICE, new Rectangle2D.Double(0.0, 0.0, DeviceType.VOICE.getDefaultWidth(), DeviceType.VOICE.getDefaultHeight()));
        }
        this.addCondition();
    }

    public Dialog(Dialog oldDialog, DeviceType deviceType) {
        this.copy(oldDialog, deviceType, false);
        this.setBounds(deviceType, new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0));
        this.setTransform(deviceType, new AffineTransform());
        if (this.isVisibleToDeviceType(DeviceType.VOICE)) {
            this.setBounds(DeviceType.VOICE, new Rectangle2D.Double(0.0, 0.0, DeviceType.VOICE.getDefaultWidth(), DeviceType.VOICE.getDefaultHeight()));
            if (oldDialog.isVisibleToDeviceType(DeviceType.VOICE)) {
                this.setTransform(DeviceType.VOICE, oldDialog.getTransform(DeviceType.VOICE));
            } else {
                Iterator i = oldDialog.getDeviceTypesVisibleTo().iterator();
                if (i.hasNext()) {
                    DeviceType aDeviceType = (DeviceType)i.next();
                    this.setTransform(DeviceType.VOICE, oldDialog.getFirstPage(aDeviceType).getTransform());
                }
            }
        }
    }

    public void dispose() {
        Iterator i = this.pages.getDeviceTypes().iterator();
        while (i.hasNext()) {
            DeviceType deviceType = (DeviceType)i.next();
            Iterator j = new ArrayList(this.pages.getContainees(deviceType)).iterator();
            while (j.hasNext()) {
                Page p = (Page)j.next();
                this.remove(p);
            }
        }
        this.graph = null;
        this.pages.clear();
    }

    public InteractionGraph getInteractionGraph() {
        return this.graph;
    }

    public void setInteractionGraph(InteractionGraph graph) {
        this.graph = graph;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(DeviceType deviceType) {
        this.deviceType = deviceType;
    }

    public Set getDeviceTypesVisibleTo() {
        return this.pages.getDeviceTypes();
    }

    public Page getPage(DeviceType aDeviceType, int index) {
        aDeviceType.verifyTypeIsNotAll();
        if (this.isEnabled(aDeviceType)) {
            List pagesForDevice = this.pages.getContainees(aDeviceType);
            return (Page)pagesForDevice.get(index);
        }
        return null;
    }

    public Page getFirstPage(DeviceType deviceType) {
        return this.getPage(deviceType, 0);
    }

    public Page getLastPage(DeviceType deviceType) {
        return this.getPage(deviceType, this.getPages(deviceType).size() - 1);
    }

    public List getPages(DeviceType deviceType) {
        return this.pages.getContainees(deviceType);
    }

    private final void basicAdd(Page page) {
        this.basicAdd(this.pages.size(page.getDeviceType()), page);
    }

    private void basicAdd(int index, Page page) {
        DamaskUtils.checkValidArgument(page.getDialog() == this, page + "'s dialog should be " + page.getDialog());
        this.pages.add(page.getDeviceType(), index, page);
        this.fireElementAdded(index, page);
    }

    protected void add(Page page) {
        this.add(this.pages.size(page.getDeviceType()), page);
    }

    protected void add(int index, Page page) {
        this.basicAdd(index, page);
    }

    protected boolean removeWithoutDispose(Page page) {
        int index = this.pages.indexOf(page.getDeviceType(), page);
        if (index != -1) {
            this.pages.remove(page.getDeviceType(), page);
            this.fireElementRemoved(index, page);
            return true;
        }
        return false;
    }

    protected boolean remove(Page page) {
        boolean wasRemoved = this.removeWithoutDispose(page);
        if (wasRemoved) {
            page.dispose();
        }
        return wasRemoved;
    }

    public void setIndex(int newIndex, Page page) {
        this.removeWithoutDispose(page);
        page.setDialog(this);
        this.add(newIndex, page);
    }

    public int indexOf(Page page) {
        return this.pages.indexOf(page.getDeviceType(), page);
    }

    public void merge(Dialog dialog2) {
        DeviceType deviceType;
        HashSet dialog2ControlConnections = new HashSet();
        HashSet<Control> dialog2Controls = new HashSet<Control>();
        HashMap<PageRegion, ArrayList<Control>> dialog1ControlsByRegion = new HashMap<PageRegion, ArrayList<Control>>();
        Iterator i = this.getDeviceTypesVisibleTo().iterator();
        while (i.hasNext()) {
            int d1NumPages;
            deviceType = (DeviceType)i.next();
            int d2NumPages = dialog2.getPages(deviceType).size();
            if (d2NumPages > 1 && (d1NumPages = this.getPages(deviceType).size()) < d2NumPages) {
                int j = d1NumPages;
                while (j < d2NumPages) {
                    this.getLastPage(deviceType).split(Collections.EMPTY_LIST);
                    ++j;
                }
            }
            Iterator j1 = this.getPages(deviceType).iterator();
            Iterator j2 = dialog2.getPages(deviceType).iterator();
            while (j1.hasNext()) {
                Page p1 = (Page)j1.next();
                Page p2 = (Page)j2.next();
                Iterator k = p1.getRegions().iterator();
                while (k.hasNext()) {
                    PageRegion p1Region = (PageRegion)k.next();
                    PageRegion p2Region = p2.getRegion(p1Region.getName());
                    ArrayList p2RegionControls = new ArrayList(p2Region.getControls());
                    Iterator m = p2RegionControls.iterator();
                    while (m.hasNext()) {
                        Control c = (Control)m.next();
                        dialog2ControlConnections.addAll(c.getInConnections());
                        dialog2ControlConnections.addAll(c.getOutConnections());
                        dialog2Controls.add(c);
                        ArrayList<Control> p1RegionControls = (ArrayList<Control>)dialog1ControlsByRegion.get(p1Region);
                        if (p1RegionControls == null) {
                            p1RegionControls = new ArrayList<Control>();
                            dialog1ControlsByRegion.put(p1Region, p1RegionControls);
                        }
                        p1RegionControls.add(c);
                    }
                }
            }
        }
        i = dialog2Controls.iterator();
        while (i.hasNext()) {
            Control c = (Control)i.next();
            c.getDialog().removeControl(c);
        }
        i = this.getDeviceTypesVisibleTo().iterator();
        while (i.hasNext()) {
            deviceType = (DeviceType)i.next();
            Iterator j = this.getPages(deviceType).iterator();
            while (j.hasNext()) {
                Page p = (Page)j.next();
                Iterator k = p.getRegions().iterator();
                while (k.hasNext()) {
                    PageRegion region = (PageRegion)k.next();
                    List newControls = (List)dialog1ControlsByRegion.get(region);
                    if (newControls == null) continue;
                    Iterator m = newControls.iterator();
                    while (m.hasNext()) {
                        Control c = (Control)m.next();
                        region.add(c);
                    }
                }
            }
        }
        i = this.getDeviceTypesVisibleTo().iterator();
        while (i.hasNext()) {
            deviceType = (DeviceType)i.next();
            Iterator j = this.getPages(deviceType).iterator();
            Iterator k = dialog2.getPages(deviceType).iterator();
            while (j.hasNext()) {
                Page d1Page = (Page)j.next();
                Page d2Page = (Page)k.next();
                d1Page.takeConnections(d2Page);
            }
        }
        dialog2.getInteractionGraph().remove(dialog2);
    }

    public boolean isEnabled(DeviceType deviceType) {
        return deviceType == this.deviceType || this.deviceType == DeviceType.ALL;
    }

    public final void addControlAtBeginning(PageRegion region, Control controlToAdd) {
        this.addControl(region, true, controlToAdd);
    }

    public final void addControlAtEnd(PageRegion region, Control controlToAdd) {
        this.addControl(region, false, controlToAdd);
    }

    protected void addControl(PageRegion region, boolean trueIfFirstFalseIfLast, Control controlToAdd) {
        DamaskUtils.checkValidArgument(region.getPage().getDialog() == this, region + " must be within " + this);
        if (trueIfFirstFalseIfLast) {
            region.add(0, controlToAdd);
        } else {
            region.add(controlToAdd);
        }
        Iterator i = controlToAdd.getDeviceTypesVisibleTo().iterator();
        while (i.hasNext()) {
            DeviceType aDeviceType = (DeviceType)i.next();
            if (aDeviceType == region.getDeviceType()) continue;
            PageRegion aRegion = this.getPageRegionToAddTo(region, trueIfFirstFalseIfLast, aDeviceType);
            if (trueIfFirstFalseIfLast) {
                aRegion.add(0, controlToAdd);
                continue;
            }
            aRegion.add(controlToAdd);
        }
    }

    public PageRegion getPageRegionToAddTo(PageRegion region, boolean trueIfFirstFalseIfLast, DeviceType aDeviceType) {
        DamaskUtils.checkValidArgument(region.getPage().getDialog() == this, region + " must be within " + this);
        Direction aRegionName = aDeviceType == DeviceType.VOICE ? Direction.CENTER : region.getName();
        PageRegion aRegion = trueIfFirstFalseIfLast ? this.getFirstPage(aDeviceType).getRegion(aRegionName) : this.getLastPage(aDeviceType).getRegion(aRegionName);
        return aRegion;
    }

    public void addControl(Map regions, Control controlToAdd) {
        PageRegion region;
        HashSet deviceTypesForControl = new HashSet(controlToAdd.getDeviceTypesVisibleTo());
        boolean match = true;
        Iterator i = regions.keySet().iterator();
        while (i.hasNext()) {
            region = (PageRegion)i.next();
            match &= deviceTypesForControl.remove(region.getDeviceType());
        }
        DamaskUtils.checkValidArgument(match &= deviceTypesForControl.isEmpty(), "device types of regions does not match those of " + controlToAdd);
        i = regions.keySet().iterator();
        while (i.hasNext()) {
            region = (PageRegion)i.next();
            int index = (Integer)regions.get(region);
            region.add(index, controlToAdd);
        }
    }

    public void addControlAfter(Control insertAfterMe, Control controlToAdd) {
        DamaskUtils.checkValidArgument(insertAfterMe.getDialog() == this, insertAfterMe + " is not in " + this);
        Iterator i = controlToAdd.getDeviceTypesVisibleTo().iterator();
        while (i.hasNext()) {
            DeviceType aDeviceType = (DeviceType)i.next();
            PageRegion regionToAddTo = this.getPageRegionToAddTo(insertAfterMe, aDeviceType);
            if (insertAfterMe.isVisibleToDeviceType(aDeviceType)) {
                regionToAddTo.addAfter(insertAfterMe, controlToAdd);
                continue;
            }
            regionToAddTo.add(controlToAdd);
        }
    }

    public PageRegion getPageRegionToAddTo(Control insertAfterMe, DeviceType aDeviceType) {
        DamaskUtils.checkValidArgument(insertAfterMe.getDialog() == this, insertAfterMe + " is not in " + this);
        aDeviceType.verifyTypeIsNotAll();
        DeviceType aVisibleDeviceTypeForinsertAfterMe = (DeviceType)insertAfterMe.getDeviceTypesVisibleTo().iterator().next();
        if (insertAfterMe.isVisibleToDeviceType(aDeviceType)) {
            PageRegion region = insertAfterMe.getPageRegion(aDeviceType);
            return region;
        }
        PageRegion aRegionForInsertAfterMe = insertAfterMe.getPageRegion(aVisibleDeviceTypeForinsertAfterMe);
        Iterator j = aRegionForInsertAfterMe.getControls().iterator();
        while (j.hasNext()) {
            Control newInsertAfterMe = (Control)j.next();
            if (!newInsertAfterMe.isVisibleToDeviceType(aDeviceType)) continue;
            return this.getLastPage(aDeviceType).getRegion(Direction.CENTER);
        }
        return this.getLastPage(aDeviceType).getRegion(aRegionForInsertAfterMe.getName());
    }

    public Collection removeControl(Control control) {
        HashSet<DeviceType> devicesRemoved = new HashSet<DeviceType>();
        Iterator i = Damask.getSupportedDeviceTypes().iterator();
        while (i.hasNext()) {
            DeviceType deviceType = (DeviceType)i.next();
            PageRegion region = control.getPageRegion(deviceType);
            if (region == null) continue;
            region.remove(control);
            devicesRemoved.add(deviceType);
        }
        return devicesRemoved;
    }

    public void changeControlPageRegion(Control control, PageRegion region) {
        DamaskUtils.checkValidArgument(region != null, "region parameter cannot be null");
        DamaskUtils.checkValidArgument(region.getPage().getDialog() == this, "region parameter " + region + " must be in this dialog, " + this);
        DamaskUtils.checkValidArgument(control.isVisibleToDeviceType(region.getDeviceType()), control + " must be visible to " + region.getDeviceType());
        control.getPageRegion(region.getDeviceType()).remove(control);
        region.add(control);
    }

    public Control getControlBefore(PageRegion region, DeviceType newControlDeviceType, AffineTransform newControlTransform, Rectangle2D newControlBounds) {
        DeviceType regionDeviceType = region.getDeviceType();
        Control controlBefore = DamaskUtils.getControlBefore(regionDeviceType, region.getControls().iterator(), newControlDeviceType, newControlTransform, newControlBounds);
        if (controlBefore == null && region.getName() == Direction.CENTER) {
            Page page = region.getPage();
            Dialog dialog = page.getDialog();
            int i = dialog.indexOf(page) - 1;
            while (i >= 0) {
                Page aPrevPage = dialog.getPage(regionDeviceType, i);
                List controls = DamaskUtils.getControlsInPositionOrder(aPrevPage.getRegion(Direction.CENTER), newControlDeviceType);
                if (!controls.isEmpty()) {
                    controlBefore = (Control)controls.get(controls.size() - 1);
                    break;
                }
                --i;
            }
        }
        return controlBefore;
    }

    public void addGroup(ComponentGroup group) {
        this.groups.add(group);
        group.setDialog(this);
        this.fireElementAdded(group);
    }

    public boolean removeGroup(ComponentGroup group) {
        boolean wasDeleted = this.groups.remove(group);
        if (wasDeleted) {
            group.setDialog(null);
            this.fireElementRemoved(group);
        }
        return wasDeleted;
    }

    public List getGroups() {
        return Collections.unmodifiableList(this.groups);
    }

    public int getCondition(Map controlStates) {
        if (this.numConditions == 1) {
            return 0;
        }
        int result = -1;
        int condition = 0;
        while (condition < this.numConditions) {
            boolean match = true;
            Iterator i = this.getDeviceTypesVisibleTo().iterator();
            while (i.hasNext()) {
                DeviceType deviceType = (DeviceType)i.next();
                Iterator j = this.getPages(deviceType).iterator();
                while (j.hasNext()) {
                    Page page = (Page)j.next();
                    Iterator k = page.getRegions().iterator();
                    block3: while (k.hasNext()) {
                        PageRegion region = (PageRegion)k.next();
                        Iterator m = region.getControls().iterator();
                        while (m.hasNext()) {
                            Control control = (Control)m.next();
                            if (!control.isStateSignificantForCondition(this, condition) || control.getStateForCondition(this, condition).equals(controlStates.get(control))) continue;
                            match = false;
                            continue block3;
                        }
                    }
                }
            }
            if (match) {
                result = condition;
                break;
            }
            ++condition;
        }
        return result;
    }

    public void addCondition() {
        this.basicAddCondition(-1);
    }

    public void addCondition(int index) {
        this.basicAddCondition(index);
    }

    private void basicAddCondition(int index) {
        Iterator i = this.getDeviceTypesVisibleTo().iterator();
        while (i.hasNext()) {
            DeviceType deviceType = (DeviceType)i.next();
            Iterator j = this.getPages(deviceType).iterator();
            while (j.hasNext()) {
                Page page = (Page)j.next();
                Iterator k = page.getRegions().iterator();
                while (k.hasNext()) {
                    PageRegion region = (PageRegion)k.next();
                    Iterator m = region.getControls().iterator();
                    while (m.hasNext()) {
                        Control control = (Control)m.next();
                        if (index == -1) {
                            control.addCondition(this);
                            continue;
                        }
                        control.addCondition(this, index);
                    }
                }
            }
        }
        ++this.numConditions;
    }

    public void removeCondition(int index) {
        Iterator i = this.getDeviceTypesVisibleTo().iterator();
        while (i.hasNext()) {
            DeviceType deviceType = (DeviceType)i.next();
            Iterator j = this.getPages(deviceType).iterator();
            while (j.hasNext()) {
                Page page = (Page)j.next();
                Iterator k = page.getRegions().iterator();
                while (k.hasNext()) {
                    PageRegion region = (PageRegion)k.next();
                    Iterator m = region.getControls().iterator();
                    while (m.hasNext()) {
                        Control control = (Control)m.next();
                        control.removeCondition(this, index);
                    }
                }
            }
        }
        --this.numConditions;
    }

    public int getNumConditions() {
        return this.numConditions;
    }

    public int getInitialCondition() {
        return this.initialCondition;
    }

    public void setInitialCondition(int condition) {
        DamaskUtils.checkValidArgument(condition >= 0 && condition < this.numConditions, "Initial condition must be from 0 up to but not including the number of conditions");
        this.initialCondition = condition;
        this.fireInitialConditionChanged(this.initialCondition);
    }

    public void addElementContainerListener(ElementContainerListener listener) {
        this.containerEventSource.addElementContainerListener(listener);
    }

    public void removeElementContainerListener(ElementContainerListener listener) {
        this.containerEventSource.removeElementContainerListener(listener);
    }

    private void fireElementAdded(int index, Page p) {
        this.containerEventSource.fireElementAdded(this, p.getDeviceType(), index, p);
    }

    private void fireElementRemoved(int index, Page p) {
        this.containerEventSource.fireElementRemoved(this, p.getDeviceType(), index, p);
    }

    private void fireElementAdded(ComponentGroup group) {
        this.containerEventSource.fireElementAdded(this, DeviceType.ALL, -1, group);
    }

    private void fireElementRemoved(ComponentGroup group) {
        this.containerEventSource.fireElementRemoved(this, DeviceType.ALL, -1, group);
    }

    private void fireInitialConditionChanged(int newInitialCondition) {
        this.dialogEventSource.fireInitialConditionChanged(this, newInitialCondition);
    }

    public Object clone() {
        Dialog clone = (Dialog)super.clone();
        clone.containerEventSource = new ElementContainerSource();
        clone.dialogEventSource = new DialogEventSource();
        clone.pages = new DeviceDependentContainer();
        clone.groups = new ArrayList();
        clone.numConditions = 0;
        clone.copy(this, this.deviceType, true);
        return clone;
    }

    private void copy(Dialog oldDialog, DeviceType deviceType, boolean toClone) {
        ComponentGroup newGroup;
        Page oldPage;
        Iterator j;
        List oldPages;
        this.deviceType = deviceType;
        HashMap<Component, Component> copies = new HashMap<Component, Component>();
        int i = 0;
        int n = oldDialog.getNumConditions();
        while (i < n) {
            this.addCondition();
            ++i;
        }
        this.setInitialCondition(oldDialog.getInitialCondition());
        Iterator i2 = deviceType.getSpecificDeviceTypes().iterator();
        while (i2.hasNext()) {
            DeviceType aDeviceType = (DeviceType)i2.next();
            oldPages = oldDialog.getPages(aDeviceType);
            if (oldPages.isEmpty()) {
                oldPages = oldDialog.getPages(oldDialog.getDeviceType());
            }
            j = oldPages.iterator();
            while (j.hasNext()) {
                oldPage = (Page)j.next();
                Content oldTitle = oldPage.getTitle();
                if (!copies.containsKey(oldTitle)) {
                    Content titleCopy = toClone ? (Content)oldTitle.clone() : (Content)oldTitle.createCopy(deviceType);
                    copies.put(oldTitle, titleCopy);
                }
                Iterator k = oldPage.getRegions().iterator();
                while (k.hasNext()) {
                    PageRegion oldRegion = (PageRegion)k.next();
                    Iterator m = oldRegion.getControls().iterator();
                    while (m.hasNext()) {
                        Control oldControl = (Control)m.next();
                        if (copies.containsKey(oldControl)) continue;
                        Control copy = toClone ? (Control)oldControl.clone() : (Control)oldControl.createCopy(deviceType);
                        copies.put(oldControl, copy);
                    }
                }
            }
        }
        i2 = deviceType.getSpecificDeviceTypes().iterator();
        while (i2.hasNext()) {
            DeviceType aDeviceType = (DeviceType)i2.next();
            oldPages = oldDialog.getPages(aDeviceType);
            if (oldPages.isEmpty()) {
                oldPages = oldDialog.getPages(oldDialog.getDeviceType());
            }
            j = oldPages.iterator();
            while (j.hasNext()) {
                Page newPage;
                oldPage = (Page)j.next();
                if (toClone) {
                    newPage = (Page)oldPage.clone(this, copies);
                    newPage.setDialog(this);
                } else {
                    newPage = new Page(aDeviceType, this, oldPage, copies);
                }
                this.basicAdd(newPage);
            }
            this.setBounds(aDeviceType, oldDialog.getBounds(aDeviceType));
            this.setTransform(aDeviceType, oldDialog.getTransform(aDeviceType));
        }
        i2 = oldDialog.getGroups().iterator();
        while (i2.hasNext()) {
            ComponentGroup oldGroup = (ComponentGroup)i2.next();
            newGroup = (ComponentGroup)oldGroup.createCopy(deviceType);
            this.addGroup(newGroup);
            copies.put(oldGroup, newGroup);
        }
        i2 = oldDialog.getGroups().iterator();
        while (i2.hasNext()) {
            ComponentGroup oldGroup = (ComponentGroup)i2.next();
            newGroup = (ComponentGroup)oldGroup.createCopy(deviceType);
            j = oldGroup.getChildren().iterator();
            while (j.hasNext()) {
                Component oldChild = (Component)j.next();
                newGroup.add((Component)copies.get(oldChild));
            }
        }
    }

    public String toLongString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.toString()) + ":\n");
        sb.append(this.pages.toLongString());
        return sb.toString();
    }

    public String toLongString(int indentLevel, DeviceType deviceType) {
        if (!$assertionsDisabled && deviceType == DeviceType.ALL) {
            throw new AssertionError((Object)"Device cannot be ALL");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(StringLib.spaces(indentLevel * DamaskUtils.INDENT_SPACES));
        sb.append(this.toString());
        sb.append("\n");
        sb.append(this.pages.toString(indentLevel + 1, deviceType));
        return sb.toString();
    }
}

