/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.connection;

import edu.berkeley.guir.damask.DamaskUtils;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.connection.Connection;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.lib.util.StringLib;
import java.awt.geom.GeneralPath;
import java.util.Iterator;

public class OrgConnection
extends Connection {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("edu.berkeley.guir.damask.connection.OrgConnection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public OrgConnection(DeviceType deviceType, boolean forAllDevices, Page sourceForDeviceType, Page destForDeviceType, GeneralPath generalPathForDeviceType) {
        Class<?> clazz;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("edu.berkeley.guir.damask.dialog.Page");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.dialog.Page");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(deviceType, forAllDevices, sourceForDeviceType, clazz2, destForDeviceType, clazz, generalPathForDeviceType);
        DamaskUtils.checkValidArgument(deviceType == sourceForDeviceType.getDeviceType(), "deviceType parameter must match device type of source parameter");
        DamaskUtils.checkValidArgument(deviceType == destForDeviceType.getDeviceType(), "deviceType parameter must match device type of dest parameter");
    }

    public Page getSource(DeviceType deviceType) {
        return (Page)this.getConnectionSource(deviceType);
    }

    public void setSource(DeviceType deviceType, Page newSource) {
        Page oldSource = this.getSource(deviceType);
        if (oldSource == newSource) {
            return;
        }
        DamaskUtils.checkValidArgument(newSource.getDeviceType() == deviceType, "The device type of the new source, " + newSource + " (" + newSource.getDeviceType() + ") must be the same as the deviceType parameter (" + deviceType);
        this.setConnectionSource(deviceType, newSource);
    }

    public Page getDest(DeviceType deviceType) {
        return (Page)this.getConnectionDest(deviceType);
    }

    public String toLongString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.toString());
        sb.append("\n");
        Iterator i = this.getDeviceTypesVisibleTo().iterator();
        while (i.hasNext()) {
            DeviceType aDeviceType = (DeviceType)i.next();
            sb.append("* " + aDeviceType + " - ");
            sb.append(this.getSource(aDeviceType).toString());
            sb.append(" -> ");
            sb.append(this.getDest(aDeviceType).toString());
            if (!i.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toLongString(int indentLevel, DeviceType aDeviceType) {
        if (!$assertionsDisabled && aDeviceType == DeviceType.ALL) {
            throw new AssertionError((Object)"Device cannot be ALL");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(StringLib.spaces(indentLevel * DamaskUtils.INDENT_SPACES));
        sb.append(this.toString());
        sb.append(": ");
        sb.append(this.getSource(aDeviceType).toString());
        sb.append(" -> ");
        sb.append(this.getDest(aDeviceType).toString());
        return sb.toString();
    }

    public Object clone() {
        OrgConnection clone = (OrgConnection)super.clone();
        return clone;
    }
}

