/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.connection;

import edu.berkeley.guir.damask.DamaskUtils;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.connection.Connection;
import edu.berkeley.guir.damask.connection.ConnectionDest;
import edu.berkeley.guir.damask.userevent.DamaskUserEvent;
import edu.berkeley.guir.lib.util.StringLib;
import java.awt.geom.GeneralPath;
import java.util.Iterator;

public class NavConnection
extends Connection {
    private DamaskUserEvent userEvent;
    private int condition;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("edu.berkeley.guir.damask.connection.NavConnection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public NavConnection(DeviceType deviceType, boolean forAllDevices, Control sourceForDeviceType, DamaskUserEvent userEvent, int condition, ConnectionDest destForDeviceType, GeneralPath generalPathForDeviceType) {
        Class<?> clazz;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("edu.berkeley.guir.damask.component.Control");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("edu.berkeley.guir.damask.connection.ConnectionDest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(deviceType, forAllDevices, sourceForDeviceType, clazz2, destForDeviceType, clazz, generalPathForDeviceType);
        this.userEvent = userEvent;
        this.condition = condition;
        this.basicSetUserEvent(userEvent);
        this.basicSetCondition(condition);
    }

    public DamaskUserEvent getUserEvent() {
        return this.userEvent;
    }

    private void basicSetUserEvent(DamaskUserEvent userEvent) {
        DamaskUserEvent oldUserEvent = this.userEvent;
        this.userEvent = userEvent;
        this.fireUserEventChanged(oldUserEvent, userEvent);
    }

    public void setUserEvent(DamaskUserEvent userEvent) {
        this.basicSetUserEvent(userEvent);
    }

    public Control getSource(DeviceType deviceType) {
        return (Control)this.getConnectionSource(deviceType);
    }

    public ConnectionDest getDest(DeviceType deviceType) {
        return this.getConnectionDest(deviceType);
    }

    public int getCondition() {
        return this.condition;
    }

    private void basicSetCondition(int condition) {
        int oldCondition = this.condition;
        this.condition = condition;
        this.fireConditionChanged(oldCondition, condition);
    }

    public void setCondition(int condition) {
        this.basicSetCondition(condition);
    }

    private String transitionInfoToString(DeviceType deviceType) {
        StringBuffer sb = new StringBuffer();
        sb.append(" [");
        sb.append(this.getUserEvent());
        sb.append("]: ");
        sb.append(this.getSource(deviceType).toString());
        sb.append(" -> ");
        sb.append(this.getDest(deviceType).toString());
        return sb.toString();
    }

    public String toLongString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.toString());
        Iterator i = this.getDeviceTypesVisibleTo().iterator();
        while (i.hasNext()) {
            DeviceType aDeviceType = (DeviceType)i.next();
            sb.append("* " + aDeviceType + " - ");
            sb.append(this.transitionInfoToString(aDeviceType));
            if (!i.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toLongString(int indentLevel, DeviceType aDeviceType) {
        if (!$assertionsDisabled && aDeviceType == DeviceType.ALL) {
            throw new AssertionError((Object)"Device cannot be ALL");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(StringLib.spaces(indentLevel * DamaskUtils.INDENT_SPACES));
        sb.append(this.toString());
        sb.append(this.transitionInfoToString(aDeviceType));
        return sb.toString();
    }

    public Object clone() {
        NavConnection clone = (NavConnection)super.clone();
        clone.userEvent = this.userEvent.createCopy(clone.getSource(this.getOrigSpecifiedDeviceType()));
        return clone;
    }
}

