/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.connection;

import edu.berkeley.guir.damask.AbstractInteractionElement;
import edu.berkeley.guir.damask.Damask;
import edu.berkeley.guir.damask.DamaskUtils;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.InteractionGraph;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.connection.ConnectionDest;
import edu.berkeley.guir.damask.connection.ConnectionSource;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.damask.event.ConnectionEventSource;
import edu.berkeley.guir.damask.event.ConnectionListener;
import edu.berkeley.guir.damask.event.ControlEvent;
import edu.berkeley.guir.damask.event.ControlListener;
import edu.berkeley.guir.damask.event.InteractionElementEvent;
import edu.berkeley.guir.damask.event.InteractionElementListener;
import edu.berkeley.guir.damask.pattern.PatternInstance;
import edu.berkeley.guir.damask.pattern.PatternInstanceMember;
import edu.berkeley.guir.damask.userevent.DamaskUserEvent;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class Connection
extends AbstractInteractionElement
implements PatternInstanceMember {
    private Map sources = new HashMap();
    private Map dests = new HashMap();
    private Map sourcePages = new HashMap();
    private Map destPages = new HashMap();
    private Map sourceLocFracs = new HashMap();
    private Map destLocFracs = new HashMap();
    private Map paths = new HashMap();
    private Set patternInstances = new HashSet();
    private InteractionGraph graph;
    private final Class sourceClass;
    private final Class destClass;
    private final DeviceType userSpecDeviceType;
    private final boolean forAllDevices;
    private InteractionElementListener endpointListener = new EndpointListener();
    private ControlHandler controlHandler = new ControlHandler();
    private ConnectionEventSource connectionEventSource = new ConnectionEventSource();

    protected Connection(DeviceType userSpecDeviceType, boolean forAllDevices, ConnectionSource sourceForUserSpecDeviceType, Class sourceClass, ConnectionDest destForUserSpecDeviceType, Class destClass, GeneralPath shapeForUserSpecDeviceType) {
        userSpecDeviceType.verifyTypeIsNotAll();
        this.sourceClass = sourceClass;
        this.destClass = destClass;
        this.userSpecDeviceType = userSpecDeviceType;
        this.forAllDevices = forAllDevices;
        this.sourceLocFracs.put(userSpecDeviceType, new double[]{0.5, 0.5});
        this.destLocFracs.put(userSpecDeviceType, new double[]{0.5, 0.5});
        this.sources.put(userSpecDeviceType, null);
        this.dests.put(userSpecDeviceType, null);
        this.basicSetShape(userSpecDeviceType, shapeForUserSpecDeviceType);
        this.basicSetConnectionSource(userSpecDeviceType, sourceForUserSpecDeviceType);
        this.recalculateStartPointLocFrac(userSpecDeviceType);
        this.basicSetConnectionDest(userSpecDeviceType, destForUserSpecDeviceType);
        this.recalculateEndPointLocFrac(userSpecDeviceType);
        if (forAllDevices) {
            Iterator i = Damask.getSupportedDeviceTypes().iterator();
            while (i.hasNext()) {
                DeviceType aDeviceType = (DeviceType)i.next();
                if (userSpecDeviceType.equals(aDeviceType)) continue;
                this.sources.put(aDeviceType, null);
                this.dests.put(aDeviceType, null);
                ConnectionSource sourceForThisDeviceType = sourceForUserSpecDeviceType instanceof Page ? ((Page)sourceForUserSpecDeviceType).getDialog().getFirstPage(aDeviceType) : sourceForUserSpecDeviceType;
                ConnectionDest destForThisDeviceType = destForUserSpecDeviceType instanceof Page ? ((Page)destForUserSpecDeviceType).getDialog().getFirstPage(aDeviceType) : destForUserSpecDeviceType;
                this.sourceLocFracs.put(aDeviceType, new double[]{this.getSourceXAsWidthFraction(userSpecDeviceType), this.getSourceYAsHeightFraction(userSpecDeviceType)});
                this.destLocFracs.put(aDeviceType, new double[]{this.getDestXAsWidthFraction(userSpecDeviceType), this.getDestYAsHeightFraction(userSpecDeviceType)});
                this.basicSetConnectionSource(aDeviceType, sourceForThisDeviceType);
                this.basicSetConnectionDest(aDeviceType, destForThisDeviceType);
                this.recalculateShape(aDeviceType);
            }
        }
    }

    public void dispose() {
        this.setInteractionGraph(null);
        HashSet deviceTypes = new HashSet(this.getDeviceTypesVisibleTo());
        Iterator i = deviceTypes.iterator();
        while (i.hasNext()) {
            DeviceType deviceType = (DeviceType)i.next();
            this.basicSetConnectionSource(deviceType, null);
            this.basicSetConnectionDest(deviceType, null);
            this.sources.remove(deviceType);
            this.dests.remove(deviceType);
        }
    }

    public InteractionGraph getInteractionGraph() {
        return this.graph;
    }

    public void setInteractionGraph(InteractionGraph graph) {
        this.graph = graph;
    }

    public boolean isVisibleToDeviceType(DeviceType deviceType) {
        deviceType.verifyTypeIsNotAll();
        return this.sources.containsKey(deviceType);
    }

    public Set getDeviceTypesVisibleTo() {
        return Collections.unmodifiableSet(this.sources.keySet());
    }

    public boolean isForAllDeviceTypes() {
        return this.forAllDevices;
    }

    public DeviceType getOrigSpecifiedDeviceType() {
        return this.userSpecDeviceType;
    }

    protected void verifyDeviceTypeIsValid(DeviceType deviceType) {
        DamaskUtils.checkValidArgument(this.isVisibleToDeviceType(deviceType), String.valueOf(deviceType.toString()) + " has not been added to connection " + this.toString());
    }

    public ConnectionSource getConnectionSource(DeviceType deviceType) {
        deviceType.verifyTypeIsNotAll();
        return (ConnectionSource)this.sources.get(deviceType);
    }

    private final void basicSetConnectionSource(DeviceType deviceType, ConnectionSource newSource) {
        this.verifyDeviceTypeIsValid(deviceType);
        DamaskUtils.checkValidArgument(this.sourceClass.isInstance(newSource) || newSource == null, newSource + " must be an instance of " + this.sourceClass + " or null");
        Iterator i = deviceType.getSpecificDeviceTypes().iterator();
        while (i.hasNext()) {
            DeviceType aDeviceType = (DeviceType)i.next();
            ConnectionSource oldSource = (ConnectionSource)this.sources.get(aDeviceType);
            if (oldSource != null) {
                Page oldSourcePage;
                oldSource.removeOutConnection(this);
                oldSource.removeInteractionElementListener(this.endpointListener);
                if (oldSource instanceof Control) {
                    ((Control)oldSource).addControlListener(this.controlHandler);
                }
                if ((oldSourcePage = (Page)this.sourcePages.remove(aDeviceType)) != null && oldSource != oldSourcePage) {
                    oldSourcePage.removeInteractionElementListener(this.endpointListener);
                }
            }
            this.sources.put(aDeviceType, newSource);
            if (newSource != null) {
                Page newSourcePage;
                newSource.addOutConnection(this);
                newSource.addInteractionElementListener(this.endpointListener);
                if (newSource instanceof Control) {
                    ((Control)newSource).addControlListener(this.controlHandler);
                }
                if ((newSourcePage = newSource.getPage(aDeviceType)) != null && newSource != newSourcePage) {
                    this.sourcePages.put(aDeviceType, newSourcePage);
                    newSourcePage.addInteractionElementListener(this.endpointListener);
                }
            }
            this.fireSourceChanged(aDeviceType, oldSource, newSource);
        }
    }

    protected void setConnectionSource(DeviceType deviceType, ConnectionSource newSource) {
        deviceType.verifyTypeIsNotAll();
        this.basicSetConnectionSource(deviceType, newSource);
        this.recalculateShape(deviceType);
    }

    public ConnectionDest getConnectionDest(DeviceType deviceType) {
        deviceType.verifyTypeIsNotAll();
        return (ConnectionDest)this.dests.get(deviceType);
    }

    private final void basicSetConnectionDest(DeviceType deviceType, ConnectionDest newDest) {
        this.verifyDeviceTypeIsValid(deviceType);
        DamaskUtils.checkValidArgument(this.destClass.isInstance(newDest) || newDest == null, newDest + " must be an instance of " + this.destClass + " or null");
        Iterator i = deviceType.getSpecificDeviceTypes().iterator();
        while (i.hasNext()) {
            DeviceType aDeviceType = (DeviceType)i.next();
            ConnectionDest oldDest = (ConnectionDest)this.dests.get(aDeviceType);
            if (oldDest != null) {
                Page oldDestPage;
                oldDest.removeInConnection(this);
                oldDest.removeInteractionElementListener(this.endpointListener);
                if (oldDest instanceof Control) {
                    ((Control)oldDest).removeControlListener(this.controlHandler);
                }
                if ((oldDestPage = (Page)this.destPages.remove(aDeviceType)) != null && oldDest != oldDestPage) {
                    oldDestPage.removeInteractionElementListener(this.endpointListener);
                }
            }
            this.dests.put(aDeviceType, newDest);
            if (newDest != null) {
                Page newDestPage;
                newDest.addInConnection(this);
                newDest.addInteractionElementListener(this.endpointListener);
                if (newDest instanceof Control) {
                    ((Control)newDest).addControlListener(this.controlHandler);
                }
                if ((newDestPage = newDest.getPage(aDeviceType)) != null && newDest != newDestPage) {
                    this.destPages.put(aDeviceType, newDestPage);
                    newDestPage.addInteractionElementListener(this.endpointListener);
                }
            }
            this.fireDestChanged(aDeviceType, oldDest, newDest);
        }
    }

    protected void setConnectionDest(DeviceType deviceType, ConnectionDest newDest) {
        deviceType.verifyTypeIsNotAll();
        this.basicSetConnectionDest(deviceType, newDest);
        this.recalculateShape(deviceType);
    }

    public void adjustDestPage(DeviceType deviceType, Page newDest) {
        ConnectionDest oldDest = this.getConnectionDest(deviceType);
        if (!(oldDest instanceof Page)) {
            throw new UnsupportedOperationException("The destination of " + this + " for " + deviceType + " must be a page, not " + oldDest);
        }
        if (oldDest == newDest) {
            return;
        }
        DamaskUtils.checkValidArgument(newDest.getDeviceType() == deviceType, "The device type of the new destination, " + newDest + " (" + newDest.getDeviceType() + ") must be the same as the deviceType parameter (" + deviceType);
        this.setConnectionDest(deviceType, newDest);
    }

    private void recalculateStartPointLocFrac(DeviceType aDeviceType) {
        ConnectionSource source = (ConnectionSource)this.sources.get(aDeviceType);
        Point2D startPoint = DamaskAppUtils.getFirstPoint(this.getShape(aDeviceType));
        Rectangle2D sourceGlobalBds = source.localToGlobal(aDeviceType, source.getBounds(aDeviceType));
        double pctWidth = (startPoint.getX() - sourceGlobalBds.getX()) / sourceGlobalBds.getWidth();
        double pctHeight = (startPoint.getY() - sourceGlobalBds.getY()) / sourceGlobalBds.getHeight();
        this.sourceLocFracs.put(aDeviceType, new double[]{pctWidth, pctHeight});
    }

    private void recalculateEndPointLocFrac(DeviceType aDeviceType) {
        ConnectionDest dest = (ConnectionDest)this.dests.get(aDeviceType);
        Point2D endPoint = DamaskAppUtils.getLastPoint(this.getShape(aDeviceType));
        Rectangle2D destGlobalBds = dest.localToGlobal(aDeviceType, dest.getBounds(aDeviceType));
        double pctWidth = (endPoint.getX() - destGlobalBds.getX()) / destGlobalBds.getWidth();
        double pctHeight = (endPoint.getY() - destGlobalBds.getY()) / destGlobalBds.getHeight();
        this.destLocFracs.put(aDeviceType, new double[]{pctWidth, pctHeight});
    }

    public double getSourceXAsWidthFraction(DeviceType deviceType) {
        return ((double[])this.sourceLocFracs.get(deviceType))[0];
    }

    public double getSourceYAsHeightFraction(DeviceType deviceType) {
        return ((double[])this.sourceLocFracs.get(deviceType))[1];
    }

    public double getDestXAsWidthFraction(DeviceType deviceType) {
        return ((double[])this.destLocFracs.get(deviceType))[0];
    }

    public double getDestYAsHeightFraction(DeviceType deviceType) {
        return ((double[])this.destLocFracs.get(deviceType))[1];
    }

    public GeneralPath getShape(DeviceType deviceType) {
        deviceType.verifyTypeIsNotAll();
        return (GeneralPath)this.paths.get(deviceType);
    }

    private final void basicSetShape(DeviceType deviceType, GeneralPath newShape) {
        this.verifyDeviceTypeIsValid(deviceType);
        Collection deviceTypes = deviceType.getSpecificDeviceTypes();
        Iterator i = deviceTypes.iterator();
        while (i.hasNext()) {
            DeviceType aDeviceType = (DeviceType)i.next();
            GeneralPath oldShape = (GeneralPath)this.paths.get(aDeviceType);
            this.paths.put(aDeviceType, newShape);
            this.fireShapeChanged(aDeviceType, oldShape, newShape);
        }
    }

    public void setShape(DeviceType deviceType, GeneralPath newShape) {
        this.basicSetShape(deviceType, newShape);
        this.recalculateStartPointLocFrac(deviceType);
        this.recalculateEndPointLocFrac(deviceType);
    }

    private void recalculateShape(DeviceType deviceType) {
        ConnectionSource source = this.getConnectionSource(deviceType);
        if (source.getBounds(deviceType) == null) {
            return;
        }
        Rectangle2D sourceGlobalBds = source.localToGlobal(deviceType, source.getBounds(deviceType));
        double[] sourceFracs = (double[])this.sourceLocFracs.get(deviceType);
        double newStartPointX = sourceFracs[0] * sourceGlobalBds.getWidth() + sourceGlobalBds.getX();
        double newStartPointY = sourceFracs[1] * sourceGlobalBds.getHeight() + sourceGlobalBds.getY();
        ConnectionDest dest = this.getConnectionDest(deviceType);
        if (dest.getBounds(deviceType) == null) {
            return;
        }
        Rectangle2D destGlobalBds = dest.localToGlobal(deviceType, dest.getBounds(deviceType));
        double[] destFracs = (double[])this.destLocFracs.get(deviceType);
        double newEndPointX = destFracs[0] * destGlobalBds.getWidth() + destGlobalBds.getX();
        double newEndPointY = destFracs[1] * destGlobalBds.getHeight() + destGlobalBds.getY();
        GeneralPath oldGenPath = (GeneralPath)this.paths.get(deviceType);
        GeneralPath newGenPath = new GeneralPath();
        newGenPath.moveTo((float)newStartPointX, (float)newStartPointY);
        newGenPath.lineTo((float)newEndPointX, (float)newEndPointY);
        this.paths.put(deviceType, newGenPath);
        this.fireShapeChanged(deviceType, oldGenPath, newGenPath);
    }

    public void refresh(DeviceType aDeviceType) {
        this.recalculateShape(aDeviceType);
        this.setConnectionSource(aDeviceType, this.getConnectionSource(aDeviceType));
        this.setConnectionDest(aDeviceType, this.getConnectionDest(aDeviceType));
    }

    public Collection getPatternInstanceMemberships() {
        return Collections.unmodifiableCollection(this.patternInstances);
    }

    public void addToPatternInstance(PatternInstance pi) {
        this.patternInstances.add(pi);
    }

    public boolean removeFromPatternInstance(PatternInstance pi) {
        return this.patternInstances.remove(pi);
    }

    public void addConnectionListener(ConnectionListener listener) {
        this.connectionEventSource.addConnectionListener(listener);
    }

    public void removeConnectionListener(ConnectionListener listener) {
        this.connectionEventSource.removeConnectionListener(listener);
    }

    protected void fireSourceChanged(DeviceType deviceType, ConnectionSource oldSource, ConnectionSource newSource) {
        this.connectionEventSource.fireSourceChanged(this, deviceType, oldSource, newSource);
    }

    protected void fireDestChanged(DeviceType deviceType, ConnectionDest oldDest, ConnectionDest newDest) {
        this.connectionEventSource.fireDestChanged(this, deviceType, oldDest, newDest);
    }

    protected void fireShapeChanged(DeviceType deviceType, Shape oldShape, Shape newShape) {
        this.connectionEventSource.fireShapeChanged(this, deviceType, oldShape, newShape);
    }

    protected void fireUserEventChanged(DamaskUserEvent oldEvent, DamaskUserEvent newEvent) {
        this.connectionEventSource.fireUserEventChanged(this, oldEvent, newEvent);
    }

    protected void fireConditionChanged(int oldCondition, int newCondition) {
        this.connectionEventSource.fireConditionChanged(this, oldCondition, newCondition);
    }

    public Object clone() {
        DeviceType aDeviceType;
        Connection clone = (Connection)super.clone();
        clone.patternInstances = new HashSet();
        clone.sources = new HashMap();
        Iterator i = this.sources.keySet().iterator();
        while (i.hasNext()) {
            aDeviceType = (DeviceType)i.next();
            clone.sources.put(aDeviceType, null);
            clone.basicSetConnectionSource(aDeviceType, (ConnectionSource)((ConnectionSource)this.sources.get(aDeviceType)).getMostRecentCloneIfAlive());
        }
        clone.dests = new HashMap();
        i = this.dests.keySet().iterator();
        while (i.hasNext()) {
            aDeviceType = (DeviceType)i.next();
            clone.dests.put(aDeviceType, null);
            clone.basicSetConnectionDest(aDeviceType, (ConnectionDest)((ConnectionDest)this.dests.get(aDeviceType)).getMostRecentCloneIfAlive());
        }
        clone.paths = new HashMap();
        i = this.paths.keySet().iterator();
        while (i.hasNext()) {
            aDeviceType = (DeviceType)i.next();
            clone.basicSetShape(aDeviceType, (GeneralPath)((GeneralPath)this.paths.get(aDeviceType)).clone());
        }
        clone.patternInstances = new HashSet();
        clone.endpointListener = new EndpointListener();
        clone.connectionEventSource = new ConnectionEventSource();
        return clone;
    }

    private class EndpointListener
    implements InteractionElementListener {
        EndpointListener() {
        }

        public void elementBoundsUpdated(InteractionElementEvent e) {
            if (Connection.this.isVisibleToDeviceType(e.getDeviceType())) {
                Connection.this.recalculateShape(e.getDeviceType());
            }
        }

        public void elementTransformUpdated(InteractionElementEvent e) {
            if (Connection.this.isVisibleToDeviceType(e.getDeviceType())) {
                Connection.this.recalculateShape(e.getDeviceType());
            }
        }

        public void elementBorderUpdated(InteractionElementEvent e) {
        }
    }

    private class ControlHandler
    implements ControlListener {
        ControlHandler() {
        }

        public void controlStateChanged(ControlEvent e) {
        }

        public void controlSignificanceChanged(ControlEvent e) {
        }

        public void pageRegionChanged(ControlEvent e) {
            DeviceType deviceType = e.getDeviceType();
            Control control = e.getControl();
            PageRegion pageRegion = control.getPageRegion(deviceType);
            if (control == Connection.this.getConnectionSource(deviceType)) {
                Page oldSourcePage = (Page)Connection.this.sourcePages.remove(deviceType);
                if (oldSourcePage != null) {
                    oldSourcePage.removeInteractionElementListener(Connection.this.endpointListener);
                }
                if (pageRegion != null) {
                    Page newSourcePage = pageRegion.getPage();
                    Connection.this.sourcePages.put(deviceType, newSourcePage);
                    newSourcePage.addInteractionElementListener(Connection.this.endpointListener);
                }
            }
            if (control == Connection.this.getConnectionDest(deviceType)) {
                Page oldDestPage = (Page)Connection.this.destPages.remove(deviceType);
                if (oldDestPage != null) {
                    oldDestPage.removeInteractionElementListener(Connection.this.endpointListener);
                }
                if (pageRegion != null) {
                    Page newDestPage = pageRegion.getPage();
                    Connection.this.destPages.put(deviceType, newDestPage);
                    newDestPage.addInteractionElementListener(Connection.this.endpointListener);
                }
            }
        }
    }
}

