/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.component;

import edu.berkeley.guir.damask.DamaskUtils;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.component.Component;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.connection.ConnectionDest;
import edu.berkeley.guir.damask.connection.NavConnection;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.damask.event.ContentEvent;
import edu.berkeley.guir.damask.event.ContentListener;
import edu.berkeley.guir.damask.event.ControlVoiceEvent;
import edu.berkeley.guir.damask.event.ControlVoiceListener;
import edu.berkeley.guir.damask.event.ElementContainerEvent;
import edu.berkeley.guir.damask.event.ElementContainerListener;
import edu.berkeley.guir.damask.event.InteractionElementEvent;
import edu.berkeley.guir.damask.event.InteractionElementListener;
import edu.berkeley.guir.damask.userevent.InvokeEvent;
import edu.berkeley.guir.damask.view.visual.component.Button;
import edu.umd.cs.piccolo.PNode;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Trigger
extends Control {
    private static final int CORNER_RADIUS = 10;
    public static final Style BUTTON = new Style("button");
    public static final Style HYPERLINK = new Style("hyperlink");
    private static final AffineTransform DEFAULT_BUTTON_CONTENT_TRANSFORM;
    private Content content;
    private Map styles = new HashMap();
    private Map borders = new HashMap();
    private Control prevVoiceControl;
    private ControlVoiceListener prevVoiceControlHandler = new PrevControlVoiceHandler();
    private PageRegionHandler pageRegionHandler = new PageRegionHandler();
    private ContentHandler contentHandler = new ContentHandler();

    static {
        PNode button = Button.createTempView();
        DEFAULT_BUTTON_CONTENT_TRANSFORM = button.getChild(0).getTransform();
    }

    public Trigger(DeviceType deviceType, Content content) {
        super(deviceType);
        DamaskUtils.checkValidArgument(content.isVisibleToDeviceType(deviceType), "content must be visible to " + deviceType);
        this.content = content;
        this.init();
    }

    public Trigger(Trigger trigger, DeviceType deviceType) {
        super(trigger, deviceType);
        this.content = new Content(trigger.getContent(), deviceType);
        this.styles = new HashMap(trigger.styles);
        if (deviceType == DeviceType.ALL && trigger.getDeviceTypesVisibleTo().size() == 1) {
            DeviceType triggerDeviceType = trigger.getDeviceType();
            Iterator i = deviceType.getSpecificDeviceTypes().iterator();
            while (i.hasNext()) {
                DeviceType aDeviceType = (DeviceType)i.next();
                if (this.styles.get(aDeviceType) != null) continue;
                this.styles.put(aDeviceType, trigger.getStyle(triggerDeviceType));
            }
        }
        this.borders = new HashMap(trigger.borders);
        this.init();
    }

    private void init() {
        this.content.addInteractionElementListener(this.contentHandler);
        this.content.addContentEventListener(this.contentHandler);
        this.content.addControlVoiceListener(this.contentHandler);
        this.addVoiceResponseText(0, this.content.getVoicePromptText());
    }

    public void dispose() {
        this.content.removeInteractionElementListener(this.contentHandler);
        this.content.removeContentEventListener(this.contentHandler);
        this.content.removeControlVoiceListener(this.contentHandler);
    }

    public Content getContent() {
        return this.content;
    }

    public Style getStyle(DeviceType deviceType) {
        deviceType.verifyTypeIsNotAll();
        DamaskUtils.checkValidArgument(this.isVisibleToDeviceType(deviceType), this + " supports " + this.getDeviceType() + ", not " + deviceType);
        Style style = (Style)this.styles.get(deviceType);
        if (style == null) {
            return HYPERLINK;
        }
        return style;
    }

    public void setStyle(DeviceType deviceType, Style style) {
        DamaskUtils.checkValidArgument(this.isVisibleToDeviceType(deviceType), this + " supports " + this.getDeviceType() + ", not " + deviceType);
        Iterator i = deviceType.getSpecificDeviceTypes().iterator();
        while (i.hasNext()) {
            DeviceType aDeviceType = (DeviceType)i.next();
            this.styles.put(aDeviceType, style);
        }
    }

    public GeneralPath getBorder(DeviceType deviceType) {
        deviceType.verifyTypeIsNotAll();
        return (GeneralPath)this.borders.get(deviceType);
    }

    public void setBorder(DeviceType deviceType, GeneralPath border) {
        DamaskUtils.checkValidArgument(this.isVisibleToDeviceType(deviceType), this + " supports " + this.getDeviceType() + ", not " + deviceType);
        Iterator i = deviceType.getSpecificDeviceTypes().iterator();
        while (i.hasNext()) {
            DeviceType aDeviceType = (DeviceType)i.next();
            this.borders.put(aDeviceType, border);
            this.fireElementBorderUpdated(aDeviceType);
        }
    }

    public void setBounds(DeviceType deviceType, Rectangle2D newBounds) {
        super.setBounds(deviceType, newBounds);
        if (newBounds == null) {
            this.setBorder(deviceType, null);
        } else {
            this.setBorder(deviceType, new GeneralPath(new RoundRectangle2D.Double(newBounds.getX(), newBounds.getY(), newBounds.getWidth(), newBounds.getHeight(), 10.0, 10.0)));
        }
    }

    private void autoPositionForVisual(DeviceType aDeviceType) {
        Rectangle2D fullBounds = this.content.getFullSizeBounds(this.content.getPreferredDisplayMode(aDeviceType));
        Rectangle2D.Double contentBounds = new Rectangle2D.Double(fullBounds.getX(), fullBounds.getY(), fullBounds.getWidth(), fullBounds.getHeight());
        this.content.setBounds(aDeviceType, contentBounds);
        if (this.getStyle(aDeviceType) == BUTTON) {
            this.content.setTransform(aDeviceType, DEFAULT_BUTTON_CONTENT_TRANSFORM);
            this.setBounds(aDeviceType, new Rectangle2D.Double(0.0, 0.0, ((RectangularShape)contentBounds).getWidth() + 2.0 * DEFAULT_BUTTON_CONTENT_TRANSFORM.getTranslateX(), ((RectangularShape)contentBounds).getHeight() + 2.0 * DEFAULT_BUTTON_CONTENT_TRANSFORM.getTranslateY()));
        } else {
            this.setBounds(aDeviceType, contentBounds);
        }
        this.placeAfterAllControls(aDeviceType);
    }

    protected void autoPositionForDesktop() {
        Style phoneStyle = (Style)this.styles.get(DeviceType.SMARTPHONE);
        if (phoneStyle != null) {
            this.setStyle(DeviceType.DESKTOP, phoneStyle);
        }
        this.autoPositionForVisual(DeviceType.DESKTOP);
    }

    protected void autoPositionForSmartphone() {
        Style desktopStyle = (Style)this.styles.get(DeviceType.DESKTOP);
        if (desktopStyle != null) {
            this.setStyle(DeviceType.SMARTPHONE, desktopStyle);
        }
        this.autoPositionForVisual(DeviceType.SMARTPHONE);
    }

    protected void autoPositionForVoice() {
    }

    protected void setPrevVoiceControl(Control control) {
        if (this.prevVoiceControl != null) {
            this.prevVoiceControl.removeControlVoiceListener(this.prevVoiceControlHandler);
        }
        this.prevVoiceControl = control;
        if (this.prevVoiceControl != null) {
            this.prevVoiceControl.addControlVoiceListener(this.prevVoiceControlHandler);
        }
    }

    protected void setupVoiceResponses() {
        int i = 0;
        int n = this.getDialog().getNumConditions();
        while (i < n) {
            Point2D responseEndPt;
            Point2D responseStartPt;
            Point2D sourceBoundsCenterInTriggerCoords;
            Rectangle2D prevPromptBounds;
            Point2D.Double destBoundsCenterInTriggerCoords;
            Line2D existingLine = this.getVoiceResponseLine(i);
            NavConnection navConnection = this.getOutConnection(DeviceType.VOICE, new InvokeEvent(this), i);
            ConnectionDest dest = navConnection != null ? navConnection.getDest(DeviceType.VOICE) : null;
            if (dest != null) {
                Rectangle2D destBoundsInTriggerCoords = this.globalToLocal(DeviceType.VOICE, dest.localToGlobal(DeviceType.VOICE, dest.getVoiceResponseDestBounds()));
                destBoundsCenterInTriggerCoords = new Point2D.Double(destBoundsInTriggerCoords.getCenterX(), destBoundsInTriggerCoords.getCenterY());
            } else {
                destBoundsCenterInTriggerCoords = null;
            }
            int numTriggersBetween = 0;
            PageRegion voiceRegion = this.getPageRegion(DeviceType.VOICE);
            Control prevControlWithPrompt = DamaskUtils.getPreviousLowLevelControl(voiceRegion, this);
            Rectangle2D rectangle2D = prevPromptBounds = prevControlWithPrompt == null ? null : prevControlWithPrompt.getVoicePromptBounds();
            if (prevControlWithPrompt instanceof Trigger) {
                ++numTriggersBetween;
            }
            while (prevPromptBounds == null && prevControlWithPrompt != null) {
                Rectangle2D rectangle2D2 = prevPromptBounds = (prevControlWithPrompt = DamaskUtils.getPreviousLowLevelControl(voiceRegion, prevControlWithPrompt)) == null ? null : prevControlWithPrompt.getVoicePromptBounds();
                if (!(prevControlWithPrompt instanceof Trigger)) continue;
                ++numTriggersBetween;
            }
            if (prevControlWithPrompt != null) {
                Rectangle2D sourceBoundsInTriggerCoords = this.globalToLocal(DeviceType.VOICE, prevControlWithPrompt.localToGlobal(DeviceType.VOICE, prevControlWithPrompt.getBounds(DeviceType.VOICE)));
                sourceBoundsCenterInTriggerCoords = new Point2D.Double(sourceBoundsInTriggerCoords.getCenterX(), sourceBoundsInTriggerCoords.getCenterY());
            } else {
                sourceBoundsCenterInTriggerCoords = null;
            }
            if (prevControlWithPrompt == null && dest == null) {
                Rectangle2D balloonBounds = this.content.getBounds(DeviceType.VOICE);
                responseStartPt = new Point2D.Double(balloonBounds.getWidth() / 2.0, 0.0);
                responseEndPt = new Point2D.Double(balloonBounds.getWidth() / 2.0, 225.0);
            } else {
                responseStartPt = prevControlWithPrompt == null ? (existingLine == null ? new Point2D.Double(((Point2D)destBoundsCenterInTriggerCoords).getX() + (double)(225 * numTriggersBetween), ((Point2D)destBoundsCenterInTriggerCoords).getY() - 225.0) : existingLine.getP1()) : sourceBoundsCenterInTriggerCoords;
                responseEndPt = dest == null ? (existingLine == null ? new Point2D.Double(sourceBoundsCenterInTriggerCoords.getX() + (double)(225 * numTriggersBetween), sourceBoundsCenterInTriggerCoords.getY() + 225.0) : existingLine.getP2()) : destBoundsCenterInTriggerCoords;
            }
            this.setVoiceResponseLine(i, new Line2D.Double(responseStartPt, responseEndPt));
            this.setVoiceResponseSource(prevControlWithPrompt);
            this.setVoiceResponseDest(i, dest);
            ++i;
        }
    }

    protected void updateVoiceResponseText() {
        PageRegion voiceRegion = this.getPageRegion(DeviceType.VOICE);
        if (voiceRegion != null) {
            Control prevControl = DamaskUtils.getPreviousLowLevelControl(voiceRegion, this);
            if (prevControl != null && !(prevControl instanceof Trigger) && !(prevControl instanceof Content)) {
                this.setVoiceResponseTextList(prevControl.getVoiceResponseTextList());
            } else {
                ArrayList<String> newResponseTextList = new ArrayList<String>();
                newResponseTextList.add(this.content.getVoicePromptText());
                this.setVoiceResponseTextList(newResponseTextList);
            }
        }
    }

    public void setPageRegion(DeviceType aDeviceType, PageRegion aRegion) {
        PageRegion oldRegion = this.getPageRegion(aDeviceType);
        super.setPageRegion(aDeviceType, aRegion);
        if (oldRegion == aRegion) {
            return;
        }
        if (aDeviceType == DeviceType.VOICE) {
            if (oldRegion != null) {
                oldRegion.removeElementContainerListener(this.pageRegionHandler);
            }
            if (aRegion != null) {
                aRegion.addElementContainerListener(this.pageRegionHandler);
            }
        }
    }

    public String toString() {
        if (this.content == null) {
            return super.toString();
        }
        return String.valueOf(super.toString()) + " - " + this.content.contentsToString();
    }

    public Component createCopy(DeviceType deviceType) {
        return new Trigger(this, deviceType);
    }

    public Object clone() {
        Trigger clone = (Trigger)super.clone();
        clone.contentHandler = clone.new ContentHandler();
        clone.pageRegionHandler = clone.new PageRegionHandler();
        clone.prevVoiceControlHandler = clone.new PrevControlVoiceHandler();
        if (this.content != null) {
            clone.content = (Content)this.content.clone();
            clone.content.addInteractionElementListener(clone.contentHandler);
            clone.content.addContentEventListener(clone.contentHandler);
            clone.content.addControlVoiceListener(clone.contentHandler);
        }
        clone.styles = new HashMap(this.styles);
        clone.borders = new HashMap();
        Iterator i = this.borders.keySet().iterator();
        while (i.hasNext()) {
            DeviceType deviceType = (DeviceType)i.next();
            clone.borders.put(deviceType, ((GeneralPath)this.borders.get(deviceType)).clone());
        }
        return clone;
    }

    public static class Style {
        private String name;

        private Style(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private class ContentHandler
    implements InteractionElementListener,
    ContentListener,
    ControlVoiceListener {
        ContentHandler() {
        }

        private void reshape(DeviceType deviceType) {
            Content content = Trigger.this.getContent();
            Iterator i = deviceType.getSpecificDeviceTypes().iterator();
            while (i.hasNext()) {
                DeviceType aDeviceType = (DeviceType)i.next();
                if (Trigger.this.getStyle(aDeviceType) != HYPERLINK) continue;
                Trigger.this.setBounds(aDeviceType, content.getBoundsInParentCoords(aDeviceType));
            }
        }

        public void elementBoundsUpdated(InteractionElementEvent e) {
            if (e.getElement() == Trigger.this.getContent()) {
                this.reshape(e.getDeviceType());
            }
        }

        public void elementTransformUpdated(InteractionElementEvent e) {
            if (e.getElement() == Trigger.this.getContent()) {
                this.reshape(e.getDeviceType());
            }
        }

        public void elementBorderUpdated(InteractionElementEvent e) {
        }

        public void preferredDisplayModeChanged(ContentEvent e) {
            if (e.getContent() == Trigger.this.getContent()) {
                this.reshape(e.getDeviceType());
            }
        }

        public void strokeAdded(ContentEvent e) {
            if (e.getContent() == Trigger.this.getContent()) {
                this.reshape(e.getDeviceType());
            }
        }

        public void strokeRemoved(ContentEvent e) {
            if (e.getContent() == Trigger.this.getContent()) {
                this.reshape(e.getDeviceType());
            }
        }

        public void strokesChanged(ContentEvent e) {
            if (e.getContent() == Trigger.this.getContent()) {
                this.reshape(e.getDeviceType());
            }
        }

        public void textChanged(ContentEvent e) {
            if (e.getContent() == Trigger.this.getContent()) {
                this.reshape(e.getDeviceType());
                Trigger.this.updateVoiceResponseText();
            }
        }

        public void imageChanged(ContentEvent e) {
            if (e.getContent() == Trigger.this.getContent()) {
                this.reshape(e.getDeviceType());
            }
        }

        public void promptTextChanged(ControlVoiceEvent e) {
            if (e.getControl() == Trigger.this.getContent()) {
                this.reshape(DeviceType.VOICE);
                Trigger.this.updateVoiceResponseText();
            }
        }

        public void promptBoundsChanged(ControlVoiceEvent e) {
        }

        public void responseSourceChanged(ControlVoiceEvent e) {
        }

        public void responseDestChanged(ControlVoiceEvent e) {
        }

        public void responseLineChanged(ControlVoiceEvent e) {
        }

        public void responseTextChanged(ControlVoiceEvent e) {
        }

        public void promptTextIsSyncedWithText(ContentEvent e) {
        }

        public void promptTextIsUnsyncedWithText(ContentEvent e) {
        }
    }

    private class PrevControlVoiceHandler
    implements ControlVoiceListener {
        PrevControlVoiceHandler() {
        }

        public void promptTextChanged(ControlVoiceEvent e) {
        }

        public void promptBoundsChanged(ControlVoiceEvent e) {
        }

        public void responseSourceChanged(ControlVoiceEvent e) {
        }

        public void responseDestChanged(ControlVoiceEvent e) {
        }

        public void responseLineChanged(ControlVoiceEvent e) {
        }

        public void responseTextChanged(ControlVoiceEvent e) {
            Trigger.this.updateVoiceResponseText();
        }
    }

    private class PageRegionHandler
    implements ElementContainerListener {
        PageRegionHandler() {
        }

        public void elementAdded(ElementContainerEvent e) {
            if (e.getElement() == Trigger.this) {
                Trigger.this.setupVoiceResponses();
                Trigger.this.updateVoiceResponseText();
                Trigger.this.setPrevVoiceControl(Trigger.this.getPageRegion(DeviceType.VOICE).getPreviousControl(Trigger.this));
            } else {
                Control newPrev = Trigger.this.getPageRegion(DeviceType.VOICE).getPreviousControl(Trigger.this);
                if (e.getElement() == newPrev) {
                    Trigger.this.setupVoiceResponses();
                    Trigger.this.updateVoiceResponseText();
                    Trigger.this.setPrevVoiceControl(newPrev);
                }
            }
        }

        public void elementRemoved(ElementContainerEvent e) {
            if (e.getElement() == Trigger.this.prevVoiceControl) {
                Trigger.this.setupVoiceResponses();
                Trigger.this.updateVoiceResponseText();
                Trigger.this.setPrevVoiceControl(Trigger.this.getPageRegion(DeviceType.VOICE).getPreviousControl(Trigger.this));
            }
        }
    }
}

