/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.component;

import edu.berkeley.guir.damask.DamaskUtils;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.component.Component;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.view.visual.component.TextBox;
import edu.umd.cs.piccolo.PNode;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TextInput
extends Control {
    public static final String RESPONSE_TEXT = "*";
    private Map borders = new HashMap();
    private static final Rectangle2D DEFAULT_TEXT_INPUT_BOUNDS;

    static {
        PNode textBox = TextBox.createTempView();
        DEFAULT_TEXT_INPUT_BOUNDS = textBox.getBounds();
    }

    public TextInput(DeviceType deviceType) {
        super(deviceType);
        this.init();
    }

    public TextInput(TextInput textInput, DeviceType deviceType) {
        super(textInput, deviceType);
        this.borders = new HashMap(textInput.borders);
        this.init();
    }

    private void init() {
        this.addVoiceResponseText(0, RESPONSE_TEXT);
    }

    public GeneralPath getBorder(DeviceType deviceType) {
        deviceType.verifyTypeIsNotAll();
        return (GeneralPath)this.borders.get(deviceType);
    }

    public void setBorder(DeviceType deviceType, GeneralPath border) {
        DamaskUtils.checkValidArgument(this.isVisibleToDeviceType(deviceType), this + " supports " + this.getDeviceType() + ", not " + deviceType);
        Iterator i = deviceType.getSpecificDeviceTypes().iterator();
        while (i.hasNext()) {
            DeviceType aDeviceType = (DeviceType)i.next();
            this.borders.put(aDeviceType, border);
        }
    }

    public Content getContent() {
        return null;
    }

    protected void autoPositionForDesktop() {
        this.setBounds(DeviceType.DESKTOP, DEFAULT_TEXT_INPUT_BOUNDS);
        this.setBorder(DeviceType.DESKTOP, new GeneralPath(DEFAULT_TEXT_INPUT_BOUNDS));
        this.placeAfterAllControls(DeviceType.DESKTOP);
    }

    protected void autoPositionForSmartphone() {
        this.setBounds(DeviceType.SMARTPHONE, DEFAULT_TEXT_INPUT_BOUNDS);
        this.setBorder(DeviceType.SMARTPHONE, new GeneralPath(DEFAULT_TEXT_INPUT_BOUNDS));
        this.placeAfterAllControls(DeviceType.SMARTPHONE);
    }

    protected void autoPositionForVoice() {
    }

    protected void setupVoiceResponses() {
        this.setupVoiceResponseForControlWithResponseOnly();
    }

    public Component createCopy(DeviceType deviceType) {
        return new TextInput(this, deviceType);
    }

    public Object clone() {
        TextInput clone = (TextInput)super.clone();
        clone.borders = new HashMap();
        Iterator i = this.borders.keySet().iterator();
        while (i.hasNext()) {
            DeviceType deviceType = (DeviceType)i.next();
            clone.borders.put(deviceType, ((GeneralPath)this.borders.get(deviceType)).clone());
        }
        return clone;
    }
}

