/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.component;

import edu.berkeley.guir.damask.Damask;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.component.Component;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.component.Insets2D;
import edu.berkeley.guir.damask.component.Select;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.event.ControlVoiceEvent;
import edu.berkeley.guir.damask.event.ControlVoiceListener;
import edu.berkeley.guir.damask.view.visual.component.RadioButton;
import edu.berkeley.guir.lib.awt.geom.GeomLib;
import edu.berkeley.guir.lib.collection.Map2D;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Iterator;
import java.util.List;

public class SelectOne
extends Select {
    private static final String DEFAULT_VOICE_CAPTION = "Please say one of the following: $items";

    public SelectOne(DeviceType deviceType) {
        super(deviceType);
        this.init();
        if (this.isVisibleToDeviceType(DeviceType.VOICE)) {
            this.setStyle(DeviceType.VOICE, Select.MINIMAL);
        }
    }

    public SelectOne(SelectOne selectOne, DeviceType deviceType) {
        super(selectOne, deviceType);
        this.init();
        Iterator i = selectOne.getItems().iterator();
        while (i.hasNext()) {
            Item item = (Item)i.next();
            Item newItem = new Item(item, deviceType);
            this.addItem(newItem);
            this.replaceStates(item, newItem);
        }
    }

    private void init() {
    }

    protected void autoPositionForVoice() {
    }

    protected void setupVoiceResponses() {
        this.setupVoiceResponseForControlWithResponseOnly();
    }

    public Object getDefaultState() {
        List items = this.getItems();
        if (items.size() >= 1) {
            return items.get(0);
        }
        return null;
    }

    private void replaceStatesWithDefaultState(Item stateToReplace) {
        Item defaultState = (Item)this.getDefaultState();
        Dialog dialog = this.getDialog();
        if (dialog != null) {
            int j = 0;
            int n = dialog.getNumConditions();
            while (j < n) {
                if (this.getStateForCondition(dialog, j) == stateToReplace) {
                    this.setStateForCondition(dialog, j, defaultState);
                }
                ++j;
            }
        }
    }

    public void addItem(int index, Select.Item item) {
        super.addItem(index, item);
        this.replaceStatesWithDefaultState(null);
        this.addVoiceResponseText(index, item.getContent().getVoicePromptText());
    }

    public Select.Item removeItem(int index) {
        Item removedItem = (Item)super.removeItem(index);
        this.replaceStatesWithDefaultState(removedItem);
        this.removeVoiceResponseText(index);
        return removedItem;
    }

    public Component createCopy(DeviceType deviceType) {
        return new SelectOne(this, deviceType);
    }

    private void replaceStates(Item oldItem, Item newItem) {
        Iterator i = this.getDialogsWithState().iterator();
        while (i.hasNext()) {
            Dialog dialog = (Dialog)i.next();
            int cond = 0;
            int n = dialog.getNumConditions();
            while (cond < n) {
                Item state = (Item)this.getStateForCondition(dialog, cond);
                if (state.equals(oldItem)) {
                    this.setStateForCondition(dialog, cond, newItem);
                }
                ++cond;
            }
        }
    }

    public Object clone() {
        SelectOne clone = (SelectOne)super.clone();
        Iterator i = clone.getItems().iterator();
        while (i.hasNext()) {
            Item newItem = (Item)i.next();
            Item oldItem = (Item)newItem.getCloneSourceIfAlive();
            clone.replaceStates(oldItem, newItem);
        }
        return clone;
    }

    public static class Item
    extends Select.Item {
        private static final Map2D defaultInsets = new Map2D();

        static {
            PNode defaultView = RadioButton.createTempView();
            PBounds bounds = defaultView.getBounds();
            PPath captionPath = (PPath)defaultView.getChild(1);
            Rectangle2D captionPathBounds = captionPath.getPathReference().getBounds2D();
            PAffineTransform captionPathTransform = captionPath.getTransform();
            Rectangle2D captionPathBoundsInItemCoords = GeomLib.transformRectangle(captionPathTransform, captionPathBounds);
            Insets2D visualFullInsets = new Insets2D(captionPathBoundsInItemCoords.getY() - ((RectangularShape)bounds).getY(), captionPathBoundsInItemCoords.getX() - ((RectangularShape)bounds).getX(), bounds.getMaxY() - captionPathBoundsInItemCoords.getMaxY(), bounds.getMaxX() - captionPathBoundsInItemCoords.getMaxX());
            Insets2D emptyInsets = new Insets2D(0.0, 0.0, 0.0, 0.0);
            Iterator i = Damask.getSupportedDeviceTypes().iterator();
            while (i.hasNext()) {
                DeviceType aDeviceType = (DeviceType)i.next();
                Iterator j = Select.getSupportedStyles().iterator();
                while (j.hasNext()) {
                    Select.Style aStyle = (Select.Style)j.next();
                    defaultInsets.put(aDeviceType, aStyle, emptyInsets);
                }
            }
            defaultInsets.put(DeviceType.DESKTOP, Select.FULL, visualFullInsets);
            defaultInsets.put(DeviceType.SMARTPHONE, Select.FULL, visualFullInsets);
        }

        public Item(Content content) {
            super(content);
            this.init();
        }

        public Item(Item item, DeviceType deviceType) {
            super(item, deviceType);
            this.init();
        }

        private void init() {
            ControlVoiceHandler voiceHandler = new ControlVoiceHandler();
            this.getContent().addControlVoiceListener(voiceHandler);
        }

        public Component createCopy(DeviceType deviceType) {
            return new Item(this, deviceType);
        }

        public Insets2D getDefaultInsets(DeviceType deviceType, Select.Style style) {
            return (Insets2D)defaultInsets.get(deviceType, style);
        }

        protected void autoPositionForVoice() {
        }

        protected void setupVoiceResponses() {
        }

        protected void updateVoiceDisplayProperties() {
        }

        public Object clone() {
            Item clone = (Item)super.clone();
            if (this.getContent() != null) {
                clone.setContent((Content)this.getContent().clone());
                ControlVoiceHandler cloneVoiceHandler = clone.new ControlVoiceHandler();
                clone.getContent().addControlVoiceListener(cloneVoiceHandler);
            }
            return clone;
        }

        private class ControlVoiceHandler
        implements ControlVoiceListener {
            ControlVoiceHandler() {
            }

            public void promptTextChanged(ControlVoiceEvent e) {
                if (e.getControl() == Item.this.getContent() && Item.this.getParent() != null) {
                    SelectOne parent = (SelectOne)Item.this.getParent();
                    parent.setVoiceResponseText(parent.getItems().indexOf(Item.this), Item.this.getContent().getVoicePromptText());
                }
            }

            public void promptBoundsChanged(ControlVoiceEvent e) {
            }

            public void responseSourceChanged(ControlVoiceEvent e) {
            }

            public void responseDestChanged(ControlVoiceEvent e) {
            }

            public void responseLineChanged(ControlVoiceEvent e) {
            }

            public void responseTextChanged(ControlVoiceEvent e) {
            }
        }
    }
}

