/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.component;

import edu.berkeley.guir.damask.Damask;
import edu.berkeley.guir.damask.DamaskUtils;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.component.Component;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.component.Insets2D;
import edu.berkeley.guir.damask.component.Select;
import edu.berkeley.guir.damask.component.Trigger;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.damask.event.ControlVoiceEvent;
import edu.berkeley.guir.damask.event.ControlVoiceListener;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.visual.component.CheckBox;
import edu.berkeley.guir.lib.awt.geom.GeomLib;
import edu.berkeley.guir.lib.collection.Map2D;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SelectMany
extends Select {
    public SelectMany(DeviceType deviceType) {
        super(deviceType);
        if (this.isVisibleToDeviceType(DeviceType.VOICE)) {
            this.setStyle(DeviceType.VOICE, Select.FULL);
        }
    }

    public SelectMany(SelectMany selectMany, DeviceType deviceType) {
        super(selectMany, deviceType);
        Iterator i = selectMany.getItems().iterator();
        while (i.hasNext()) {
            Item item = (Item)i.next();
            Item newItem = new Item(item, deviceType);
            this.addItem(newItem);
            this.replaceStates(item, newItem);
        }
    }

    public Object getDefaultState() {
        return Collections.EMPTY_SET;
    }

    public Component createCopy(DeviceType deviceType) {
        return new SelectMany(this, deviceType);
    }

    private void replaceStates(Item oldItem, Item newItem) {
        Iterator i = this.getDialogsWithState().iterator();
        while (i.hasNext()) {
            Dialog dialog = (Dialog)i.next();
            int cond = 0;
            int n = dialog.getNumConditions();
            while (cond < n) {
                Set state = (Set)this.getStateForCondition(dialog, cond);
                boolean wasRemoved = state.remove(oldItem);
                if (wasRemoved) {
                    state.add(newItem);
                }
                ++cond;
            }
        }
    }

    public Object clone() {
        SelectMany clone = (SelectMany)super.clone();
        Iterator i = clone.getItems().iterator();
        while (i.hasNext()) {
            Item newItem = (Item)i.next();
            Item oldItem = (Item)newItem.getCloneSourceIfAlive();
            clone.replaceStates(oldItem, newItem);
        }
        return clone;
    }

    protected void autoPositionForVoice() {
    }

    protected void setupVoiceResponses() {
        Iterator i = this.getItems().iterator();
        while (i.hasNext()) {
            Item item = (Item)i.next();
            item.setupVoiceResponses();
        }
    }

    public void addItem(int index, Select.Item item) {
        PageRegion voiceRegion;
        super.addItem(index, item);
        if (item.isVisibleToDeviceType(DeviceType.VOICE) && (voiceRegion = this.getPageRegion(DeviceType.VOICE)) != null) {
            Control prevControl = DamaskUtils.getPreviousLowLevelControl(voiceRegion, item);
            if (prevControl != null) {
                prevControl.setupVoiceResponses();
            }
            item.setupVoiceResponses();
            Control nextControl = DamaskUtils.getNextLowLevelControl(voiceRegion, item);
            if (nextControl instanceof Trigger) {
                ((Trigger)nextControl).updateVoiceResponseText();
            }
        }
    }

    public Select.Item removeItem(int index) {
        Control nextVoiceControl;
        Control prevVoiceControl;
        Item item = (Item)this.getItems().get(index);
        if (item.isVisibleToDeviceType(DeviceType.VOICE)) {
            PageRegion voiceRegion = this.getPageRegion(DeviceType.VOICE);
            if (voiceRegion != null) {
                prevVoiceControl = DamaskUtils.getPreviousLowLevelControl(voiceRegion, item);
                nextVoiceControl = DamaskUtils.getNextLowLevelControl(voiceRegion, item);
            } else {
                prevVoiceControl = null;
                nextVoiceControl = null;
            }
        } else {
            prevVoiceControl = null;
            nextVoiceControl = null;
        }
        super.removeItem(index);
        if (prevVoiceControl != null) {
            prevVoiceControl.setupVoiceResponses();
        }
        if (nextVoiceControl instanceof Trigger) {
            ((Trigger)nextVoiceControl).updateVoiceResponseText();
        }
        return item;
    }

    public static class Item
    extends Select.Item {
        private static final Map2D defaultInsets = new Map2D();
        private final ControlVoiceListener contentVoiceHandler = new ContentHandler();
        private final List responseText = new ArrayList();

        static {
            PNode defaultView = CheckBox.createTempView();
            PBounds bounds = defaultView.getBounds();
            PPath captionPath = (PPath)defaultView.getChild(1);
            Rectangle2D captionPathBounds = captionPath.getPathReference().getBounds2D();
            PAffineTransform captionPathTransform = captionPath.getTransform();
            Rectangle2D captionPathBoundsInItemCoords = GeomLib.transformRectangle(captionPathTransform, captionPathBounds);
            Insets2D visualFullInsets = new Insets2D(captionPathBoundsInItemCoords.getY() - ((RectangularShape)bounds).getY(), captionPathBoundsInItemCoords.getX() - ((RectangularShape)bounds).getX(), bounds.getMaxY() - captionPathBoundsInItemCoords.getMaxY(), bounds.getMaxX() - captionPathBoundsInItemCoords.getMaxX());
            Insets2D emptyInsets = new Insets2D(0.0, 0.0, 0.0, 0.0);
            Iterator i = Damask.getSupportedDeviceTypes().iterator();
            while (i.hasNext()) {
                DeviceType aDeviceType = (DeviceType)i.next();
                Iterator j = Select.getSupportedStyles().iterator();
                while (j.hasNext()) {
                    Select.Style aStyle = (Select.Style)j.next();
                    defaultInsets.put(aDeviceType, aStyle, emptyInsets);
                }
            }
            defaultInsets.put(DeviceType.DESKTOP, Select.FULL, visualFullInsets);
            defaultInsets.put(DeviceType.SMARTPHONE, Select.FULL, visualFullInsets);
        }

        public Item(Content content) {
            super(content);
            this.init();
        }

        public Item(Item item, DeviceType deviceType) {
            super(item, deviceType);
            this.init();
        }

        private void init() {
            if (this.isVisibleToDeviceType(DeviceType.VOICE)) {
                this.updateVoicePromptText();
                this.responseText.add("Yes");
                this.responseText.add("No");
                this.setVoiceResponseTextList(this.responseText);
                this.getContent().addControlVoiceListener(this.contentVoiceHandler);
            }
        }

        public void dispose() {
            if (this.isVisibleToDeviceType(DeviceType.VOICE)) {
                this.getContent().removeControlVoiceListener(this.contentVoiceHandler);
            }
        }

        public Component createCopy(DeviceType deviceType) {
            return new Item(this, deviceType);
        }

        public Insets2D getDefaultInsets(DeviceType deviceType, Select.Style style) {
            return (Insets2D)defaultInsets.get(deviceType, style);
        }

        protected void autoPositionForVoice() {
            this.getContent().setTextSize(DeviceType.VOICE, DeviceType.VOICE.getDefaultFontSize());
            this.setVoicePromptBounds(DamaskAppUtils.getRenderedTextBounds(this.getContent().getVoicePromptText(), DeviceType.VOICE.getDefaultFontSize()));
            this.placeVoicePromptUnderPreviousPrompt();
        }

        protected void setupVoiceResponses() {
            this.setupVoiceResponsesForControlWithPromptAndResponse();
        }

        protected void updateVoiceDisplayProperties() {
            this.setVoicePromptBounds(DamaskAppUtils.getRenderedTextBounds(this.getContent().getVoicePromptText(), DeviceType.VOICE.getDefaultFontSize()));
        }

        protected void updateVoicePromptText() {
            this.setVoicePromptText(this.getContent().getVoicePromptText());
        }

        public void setVoiceResponseText(int index, String text) {
            super.setVoiceResponseText(index, text);
        }

        public void setVoiceResponseTextList(List textList) {
            super.setVoiceResponseTextList(textList);
        }

        private class ContentHandler
        implements ControlVoiceListener {
            ContentHandler() {
            }

            public void promptTextChanged(ControlVoiceEvent e) {
                if (e.getControl() == Item.this.getContent()) {
                    Item.this.updateVoicePromptText();
                    Item.this.updateVoiceDisplayProperties();
                }
            }

            public void promptBoundsChanged(ControlVoiceEvent e) {
            }

            public void responseSourceChanged(ControlVoiceEvent e) {
            }

            public void responseDestChanged(ControlVoiceEvent e) {
            }

            public void responseLineChanged(ControlVoiceEvent e) {
            }

            public void responseTextChanged(ControlVoiceEvent e) {
            }
        }
    }
}

