/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.component;

import edu.berkeley.guir.damask.Damask;
import edu.berkeley.guir.damask.DamaskUtils;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.component.Insets2D;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.damask.event.ContentEvent;
import edu.berkeley.guir.damask.event.ContentListener;
import edu.berkeley.guir.damask.event.ElementContainerListener;
import edu.berkeley.guir.damask.event.ElementContainerSource;
import edu.berkeley.guir.damask.event.InteractionElementEvent;
import edu.berkeley.guir.damask.event.InteractionElementListener;
import edu.berkeley.guir.damask.view.visual.component.ComboBox;
import edu.berkeley.guir.damask.view.visual.component.ListBox;
import edu.berkeley.guir.lib.awt.geom.GeomLib;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class Select
extends Control {
    private List items = new ArrayList();
    private ElementContainerSource containerSource = new ElementContainerSource();
    private Map styles = new HashMap();
    private ItemHandler itemHandler = new ItemHandler();
    private static final Rectangle2D DEFAULT_VISUAL_COMPACT_BOUNDS = ListBox.createTempView().getBounds();
    private static final Rectangle2D DEFAULT_VISUAL_MINIMAL_BOUNDS = ComboBox.createTempView().getBounds();
    public static final Style FULL = new Style("full");
    public static final Style COMPACT = new Style("compact");
    public static final Style MINIMAL = new Style("minimal");
    private static final Style[] VALUES = new Style[]{MINIMAL, COMPACT, FULL};

    protected Select(DeviceType deviceType) {
        super(deviceType);
        Iterator i = Damask.getSupportedDeviceTypes().iterator();
        while (i.hasNext()) {
            DeviceType aDeviceType = (DeviceType)i.next();
            this.styles.put(aDeviceType, FULL);
        }
    }

    protected Select(Select select, DeviceType deviceType) {
        super(select, deviceType);
        this.styles = new HashMap(select.styles);
    }

    protected void autoPositionForDesktop() {
        Style phoneStyle = (Style)this.styles.get(DeviceType.SMARTPHONE);
        if (phoneStyle != null) {
            this.setStyle(DeviceType.DESKTOP, phoneStyle);
        }
        if (this.getStyle(DeviceType.DESKTOP) == COMPACT) {
            this.setBounds(DeviceType.DESKTOP, DEFAULT_VISUAL_COMPACT_BOUNDS);
        } else if (this.getStyle(DeviceType.DESKTOP) == MINIMAL) {
            this.setBounds(DeviceType.DESKTOP, DEFAULT_VISUAL_MINIMAL_BOUNDS);
        }
        this.placeAfterAllControls(DeviceType.DESKTOP);
    }

    protected void autoPositionForSmartphone() {
        Style desktopStyle = (Style)this.styles.get(DeviceType.DESKTOP);
        if (desktopStyle != null) {
            this.setStyle(DeviceType.SMARTPHONE, desktopStyle);
        }
        if (this.getStyle(DeviceType.SMARTPHONE) == COMPACT) {
            this.setBounds(DeviceType.SMARTPHONE, DEFAULT_VISUAL_COMPACT_BOUNDS);
        } else if (this.getStyle(DeviceType.SMARTPHONE) == MINIMAL) {
            this.setBounds(DeviceType.SMARTPHONE, DEFAULT_VISUAL_MINIMAL_BOUNDS);
        }
        this.placeAfterAllControls(DeviceType.SMARTPHONE);
    }

    public Style getStyle(DeviceType deviceType) {
        deviceType.verifyTypeIsNotAll();
        DamaskUtils.checkValidArgument(this.isVisibleToDeviceType(deviceType), this + " supports " + this.getDeviceType() + ", not " + deviceType);
        Style style = (Style)this.styles.get(deviceType);
        return style;
    }

    public void setStyle(DeviceType deviceType, Style style) {
        DamaskUtils.checkValidArgument(this.isVisibleToDeviceType(deviceType), this + " supports " + this.getDeviceType() + ", not " + deviceType);
        Iterator i = deviceType.getSpecificDeviceTypes().iterator();
        while (i.hasNext()) {
            DeviceType aDeviceType = (DeviceType)i.next();
            this.styles.put(aDeviceType, style);
        }
    }

    public final void addItem(Item item) {
        this.addItem(this.items.size(), item);
    }

    public void addItem(int index, Item item) {
        PageRegion voiceRegion = this.getPageRegion(DeviceType.VOICE);
        if (voiceRegion != null && voiceRegion.getControls().indexOf(this) != -1) {
            voiceRegion.prepareLayoutVoiceControls();
        }
        this.items.add(index, item);
        item.setParent(this);
        Iterator i = this.getDeviceTypesVisibleTo().iterator();
        while (i.hasNext()) {
            DeviceType aDeviceType = (DeviceType)i.next();
            PageRegion aRegion = this.getPageRegion(aDeviceType);
            if (aRegion == null) continue;
            item.setPageRegion(aDeviceType, aRegion);
        }
        item.addInteractionElementListener(this.itemHandler);
        this.fireElementAdded(index, item);
        this.updateBounds(this.getDeviceType());
        if (voiceRegion != null && voiceRegion.getControls().indexOf(this) != -1) {
            voiceRegion.layoutVoiceControls();
        }
    }

    public List getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public Item removeItem(int index) {
        PageRegion voiceRegion = this.getPageRegion(DeviceType.VOICE);
        if (voiceRegion != null && voiceRegion.getControls().indexOf(this) != -1) {
            voiceRegion.prepareLayoutVoiceControls();
        }
        Item item = (Item)this.items.remove(index);
        item.removeInteractionElementListener(this.itemHandler);
        this.fireElementRemoved(index, item);
        this.updateBounds(this.getDeviceType());
        if (voiceRegion != null && voiceRegion.getControls().indexOf(this) != -1) {
            voiceRegion.layoutVoiceControls();
        }
        return item;
    }

    public final boolean removeItem(Item item) {
        int index = this.items.indexOf(item);
        if (index != -1) {
            this.removeItem(index);
            return true;
        }
        return false;
    }

    public void setPageRegion(DeviceType aDeviceType, PageRegion aRegion) {
        super.setPageRegion(aDeviceType, aRegion);
        Iterator i = this.getItems().iterator();
        while (i.hasNext()) {
            Item item = (Item)i.next();
            item.setPageRegion(aDeviceType, aRegion);
        }
    }

    public Content getContent() {
        return null;
    }

    public void addElementContainerListener(ElementContainerListener listener) {
        this.containerSource.addElementContainerListener(listener);
    }

    public void removeElementContainerListener(ElementContainerListener listener) {
        this.containerSource.removeElementContainerListener(listener);
    }

    protected void fireElementAdded(int index, Item item) {
        this.containerSource.fireElementAdded(this, DeviceType.ALL, index, item);
    }

    protected void fireElementRemoved(int index, Item item) {
        this.containerSource.fireElementRemoved(this, DeviceType.ALL, index, item);
    }

    public Object clone() {
        Select clone = (Select)super.clone();
        clone.containerSource = new ElementContainerSource();
        clone.itemHandler = clone.new ItemHandler();
        clone.items = new ArrayList();
        Iterator i = this.items.iterator();
        while (i.hasNext()) {
            Item item = (Item)i.next();
            clone.addItem((Item)item.clone());
        }
        clone.styles = new HashMap(this.styles);
        return clone;
    }

    public Item getItemBefore(DeviceType pageDeviceType, DeviceType newControlDeviceType, AffineTransform newControlTransform, Rectangle2D newControlBounds) {
        return (Item)DamaskUtils.getControlBefore(pageDeviceType, this.getItems().iterator(), newControlDeviceType, newControlTransform, newControlBounds);
    }

    private void updateBounds(DeviceType deviceType) {
        Iterator i = deviceType.getSpecificDeviceTypes().iterator();
        while (i.hasNext()) {
            DeviceType aDeviceType = (DeviceType)i.next();
            if (this.getStyle(aDeviceType) != FULL) continue;
            Rectangle2D newBounds = null;
            Iterator j = this.getItems().iterator();
            while (j.hasNext()) {
                Item item = (Item)j.next();
                Rectangle2D itemBounds = item.getBoundsInParentCoords(aDeviceType);
                if (itemBounds == null) continue;
                if (newBounds == null) {
                    newBounds = itemBounds;
                    continue;
                }
                Rectangle2D.union(newBounds, itemBounds, newBounds);
            }
            if (newBounds == null) continue;
            this.setBounds(aDeviceType, newBounds);
        }
    }

    public AffineTransform getTransform(DeviceType deviceType) {
        if (this.getStyle(deviceType) == FULL) {
            return new AffineTransform();
        }
        return super.getTransform(deviceType);
    }

    public static List getSupportedStyles() {
        return Arrays.asList(VALUES);
    }

    private class ItemHandler
    implements InteractionElementListener {
        ItemHandler() {
        }

        private void reshape(DeviceType deviceType) {
            Rectangle2D prevItemBounds = null;
            Iterator i = Select.this.getItems().iterator();
            while (i.hasNext()) {
                Item item = (Item)i.next();
                AffineTransform itemTransform = item.getTransform(deviceType);
                Rectangle2D itemBounds = item.getBoundsInParentCoords(deviceType);
                if (itemBounds != null && prevItemBounds != null && itemBounds.getMinY() < prevItemBounds.getMaxY()) {
                    AffineTransform translateY = AffineTransform.getTranslateInstance(0.0, prevItemBounds.getMaxY() - itemBounds.getMinY());
                    itemTransform.preConcatenate(translateY);
                    item.setTransform(deviceType, itemTransform);
                    GeomLib.transformRectangle(translateY, itemBounds);
                }
                prevItemBounds = itemBounds;
            }
        }

        public void elementBoundsUpdated(InteractionElementEvent e) {
            if (Select.this.getStyle(e.getDeviceType()) != FULL) {
                this.reshape(e.getDeviceType());
            }
            Select.this.updateBounds(e.getDeviceType());
        }

        public void elementTransformUpdated(InteractionElementEvent e) {
            Select.this.updateBounds(e.getDeviceType());
        }

        public void elementBorderUpdated(InteractionElementEvent e) {
        }
    }

    public static class Style {
        private String name;

        private Style(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static abstract class Item
    extends Control {
        private Content content;
        private Select parent = null;
        private Map insetsForDevice = new HashMap();

        public Item(Content content) {
            super(content.getDeviceType());
            this.content = content;
            this.init();
        }

        public Item(Item item, DeviceType deviceType) {
            super(item, deviceType);
            this.content = new Content(item.getContent(), deviceType);
            Iterator i = this.content.getDeviceType().getSpecificDeviceTypes().iterator();
            while (i.hasNext()) {
                DeviceType aDeviceType = (DeviceType)i.next();
                this.insetsForDevice.put(aDeviceType, item.insetsForDevice.get(aDeviceType));
            }
            this.init();
        }

        private void init() {
            ContentHandler contentHandler = new ContentHandler();
            this.content.addInteractionElementListener(contentHandler);
            this.content.addContentEventListener(contentHandler);
        }

        public Control getControlBefore(DeviceType deviceType) {
            List items = this.getParent().getItems();
            int index = items.indexOf(this);
            if (index == 0) {
                return null;
            }
            return (Control)items.get(index - 1);
        }

        public Control getControlAfter(DeviceType deviceType) {
            List items = this.getParent().getItems();
            int index = items.indexOf(this);
            if (index == items.size() - 1) {
                return null;
            }
            return (Control)items.get(index + 1);
        }

        protected void autoPositionForDesktop() {
            Rectangle2D fullBounds = this.content.getFullSizeBounds(this.content.getPreferredDisplayMode(DeviceType.DESKTOP));
            Insets2D insets = this.getContentInsets(DeviceType.DESKTOP);
            this.content.setBounds(DeviceType.DESKTOP, new Rectangle2D.Double(fullBounds.getX() + insets.getLeft(), fullBounds.getY() + insets.getTop(), fullBounds.getWidth(), fullBounds.getHeight()));
            this.updateBounds(DeviceType.DESKTOP);
            Select parent = this.getParent();
            if (parent == null || parent.getStyle(DeviceType.DESKTOP) == FULL) {
                this.placeAfterAllControls(DeviceType.DESKTOP);
            }
        }

        protected void autoPositionForSmartphone() {
            Rectangle2D fullBounds = this.content.getFullSizeBounds(this.content.getPreferredDisplayMode(DeviceType.SMARTPHONE));
            Insets2D insets = this.getContentInsets(DeviceType.SMARTPHONE);
            this.content.setBounds(DeviceType.SMARTPHONE, new Rectangle2D.Double(fullBounds.getX() + insets.getLeft(), fullBounds.getY() + insets.getTop(), fullBounds.getWidth(), fullBounds.getHeight()));
            this.updateBounds(DeviceType.SMARTPHONE);
            Select parent = this.getParent();
            if (parent == null || parent.getStyle(DeviceType.SMARTPHONE) == FULL) {
                this.placeAfterAllControls(DeviceType.SMARTPHONE);
            }
        }

        public Content getContent() {
            return this.content;
        }

        protected void setContent(Content content) {
            this.content = content;
        }

        public Select getParent() {
            return this.parent;
        }

        protected void setParent(Select parent) {
            this.parent = parent;
        }

        public Page getPage(DeviceType deviceType) {
            if (this.parent == null) {
                return null;
            }
            return this.parent.getPage(deviceType);
        }

        public void setPageRegion(DeviceType deviceType, PageRegion region) {
            PageRegion oldRegion = this.getPageRegion(deviceType);
            if (oldRegion == region) {
                return;
            }
            if (this.getContentInsets(deviceType) == null) {
                this.setContentInsets(deviceType, this.getDefaultInsets(deviceType, this.getParent().getStyle(deviceType)));
            }
            super.setPageRegion(deviceType, region);
        }

        public abstract Insets2D getDefaultInsets(DeviceType var1, Style var2);

        public Insets2D getContentInsets(DeviceType deviceType) {
            deviceType.verifyTypeIsNotAll();
            return (Insets2D)this.insetsForDevice.get(deviceType);
        }

        public void setContentInsets(DeviceType deviceType, double top, double left, double bottom, double right) {
            this.setContentInsets(deviceType, new Insets2D(top, left, bottom, right));
        }

        public void setContentInsets(DeviceType deviceType, Insets2D insets) {
            Iterator i = deviceType.getSpecificDeviceTypes().iterator();
            while (i.hasNext()) {
                DeviceType aDeviceType = (DeviceType)i.next();
                this.insetsForDevice.put(aDeviceType, insets);
            }
        }

        private void updateBounds(DeviceType deviceType) {
            Content content = this.getContent();
            Iterator i = deviceType.getSpecificDeviceTypes().iterator();
            while (i.hasNext()) {
                DeviceType aDeviceType = (DeviceType)i.next();
                if (aDeviceType == DeviceType.VOICE) {
                    this.updateVoiceDisplayProperties();
                    continue;
                }
                Rectangle2D contentBounds = content.getBoundsInParentCoords(aDeviceType);
                Insets2D insets = this.getContentInsets(aDeviceType);
                if (insets == null) {
                    insets = new Insets2D(0.0, 0.0, 0.0, 0.0);
                }
                this.setBounds(aDeviceType, new Rectangle2D.Double(contentBounds.getX() - insets.getLeft(), contentBounds.getY() - insets.getTop(), contentBounds.getWidth() + insets.getLeft() + insets.getRight(), contentBounds.getHeight() + insets.getTop() + insets.getBottom()));
            }
        }

        protected abstract void updateVoiceDisplayProperties();

        public Object clone() {
            Item clone = (Item)super.clone();
            clone.parent = null;
            if (this.content != null) {
                clone.content = (Content)this.content.clone();
                ContentHandler cloneContentHandler = clone.new ContentHandler();
                clone.content.addInteractionElementListener(cloneContentHandler);
                clone.content.addContentEventListener(cloneContentHandler);
            }
            clone.insetsForDevice = new HashMap(this.insetsForDevice);
            return clone;
        }

        public Object getDefaultState() {
            return Boolean.FALSE;
        }

        public String toString() {
            return String.valueOf(super.toString()) + " - " + this.content.contentsToString();
        }

        private class ContentHandler
        implements InteractionElementListener,
        ContentListener {
            ContentHandler() {
            }

            public void elementBoundsUpdated(InteractionElementEvent e) {
                if (e.getElement() == Item.this.getContent()) {
                    Item.this.updateBounds(e.getDeviceType());
                }
            }

            public void elementTransformUpdated(InteractionElementEvent e) {
                if (e.getElement() == Item.this.getContent()) {
                    Item.this.updateBounds(e.getDeviceType());
                }
            }

            public void elementBorderUpdated(InteractionElementEvent e) {
            }

            public void preferredDisplayModeChanged(ContentEvent e) {
                if (e.getContent() == Item.this.getContent()) {
                    Item.this.updateBounds(e.getDeviceType());
                }
            }

            public void strokeAdded(ContentEvent e) {
                if (e.getContent() == Item.this.getContent()) {
                    Item.this.updateBounds(e.getDeviceType());
                }
            }

            public void strokeRemoved(ContentEvent e) {
                if (e.getContent() == Item.this.getContent()) {
                    Item.this.updateBounds(e.getDeviceType());
                }
            }

            public void strokesChanged(ContentEvent e) {
                if (e.getContent() == Item.this.getContent()) {
                    Item.this.updateBounds(e.getDeviceType());
                }
            }

            public void textChanged(ContentEvent e) {
                if (e.getContent() == Item.this.getContent()) {
                    Item.this.updateBounds(e.getDeviceType());
                }
            }

            public void voiceTextChanged(ContentEvent e) {
                if (e.getContent() == Item.this.getContent()) {
                    Item.this.updateBounds(e.getDeviceType());
                }
            }

            public void imageChanged(ContentEvent e) {
                if (e.getContent() == Item.this.getContent()) {
                    Item.this.updateBounds(e.getDeviceType());
                }
            }

            public void promptTextIsSyncedWithText(ContentEvent e) {
            }

            public void promptTextIsUnsyncedWithText(ContentEvent e) {
            }
        }
    }
}

