/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.component;

import edu.berkeley.guir.damask.DamaskUtils;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.Direction;
import edu.berkeley.guir.damask.InteractionGraph;
import edu.berkeley.guir.damask.component.Component;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.component.SelectOne;
import edu.berkeley.guir.damask.component.Trigger;
import edu.berkeley.guir.damask.connection.Connection;
import edu.berkeley.guir.damask.connection.ConnectionDest;
import edu.berkeley.guir.damask.connection.ConnectionSource;
import edu.berkeley.guir.damask.connection.NavConnection;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.damask.event.ConnectionDestEventSource;
import edu.berkeley.guir.damask.event.ConnectionDestListener;
import edu.berkeley.guir.damask.event.ConnectionEvent;
import edu.berkeley.guir.damask.event.ConnectionListener;
import edu.berkeley.guir.damask.event.ConnectionSourceEventSource;
import edu.berkeley.guir.damask.event.ConnectionSourceListener;
import edu.berkeley.guir.damask.event.ControlEventSource;
import edu.berkeley.guir.damask.event.ControlListener;
import edu.berkeley.guir.damask.event.ControlVoiceEvent;
import edu.berkeley.guir.damask.event.ControlVoiceEventSource;
import edu.berkeley.guir.damask.event.ControlVoiceListener;
import edu.berkeley.guir.damask.event.ElementContainerEvent;
import edu.berkeley.guir.damask.event.ElementContainerListener;
import edu.berkeley.guir.damask.event.InteractionElementEvent;
import edu.berkeley.guir.damask.event.InteractionElementListener;
import edu.berkeley.guir.damask.pattern.PatternInstance;
import edu.berkeley.guir.damask.pattern.PatternInstanceMember;
import edu.berkeley.guir.damask.userevent.DamaskUserEvent;
import edu.berkeley.guir.damask.view.DamaskAppExceptionHandler;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.lib.awt.geom.GeomLib;
import edu.berkeley.guir.lib.util.StringLib;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class Control
extends Component
implements ConnectionSource,
ConnectionDest,
PatternInstanceMember {
    private Set outNavConnections = new HashSet();
    private Set inNavConnections = new HashSet();
    private Map regions = new HashMap();
    private Set patternInstances = new HashSet();
    private ControlEventSource eventSource = new ControlEventSource();
    private ConnectionSourceEventSource connectionSourceEventSource = new ConnectionSourceEventSource();
    private ConnectionDestEventSource connectionDestEventSource = new ConnectionDestEventSource();
    private ControlVoiceEventSource voiceEventSource = new ControlVoiceEventSource();
    private Map conditionStates = new HashMap();
    private Map conditionSignificance = new HashMap();
    private Rectangle2D voicePromptBounds = null;
    private String voicePromptText = null;
    private Map voiceResponseLines = new TreeMap();
    private Control voiceResponseSource = null;
    private Map voiceResponseDests = new TreeMap();
    private Control nextVoiceControl = null;
    private List voiceResponseText = new ArrayList();
    private VoiceResponseEndpointHandler responseEndpointHandler = new VoiceResponseEndpointHandler();
    private ConnectionHandler connectionHandler = new ConnectionHandler();
    private ElementContainerListener pageRegionHandler = new PageRegionHandler();

    public Control(DeviceType deviceType) {
        super(deviceType);
    }

    public Control(Control control, DeviceType deviceType) {
        super(control, deviceType);
        Control.copyStates(control, this);
        if (deviceType.getSpecificDeviceTypes().contains(DeviceType.VOICE) && control.getVoicePromptBounds() != null) {
            this.voicePromptBounds = (Rectangle2D)control.getVoicePromptBounds().clone();
        }
        this.voicePromptText = control.voicePromptText;
        Iterator i = this.voiceResponseLines.keySet().iterator();
        while (i.hasNext()) {
            Integer key = (Integer)i.next();
            this.voiceResponseLines.put(key, control.voiceResponseLines.get(key));
        }
        this.voiceResponseText = new ArrayList(control.voiceResponseText);
    }

    public void dispose() {
        super.dispose();
        Iterator i = new HashSet(this.patternInstances).iterator();
        while (i.hasNext()) {
            PatternInstance instance = (PatternInstance)i.next();
            instance.remove(this);
        }
    }

    protected final void autoPosition(DeviceType deviceType) {
        deviceType.verifyTypeIsNotAll();
        if (deviceType == DeviceType.VOICE) {
            if (this.getVoicePromptBounds() == null) {
                this.autoPositionForVoice();
            }
        } else if (this.getBounds(deviceType) == null) {
            if (deviceType == DeviceType.DESKTOP) {
                this.autoPositionForDesktop();
            } else if (deviceType == DeviceType.SMARTPHONE) {
                this.autoPositionForSmartphone();
            }
        }
    }

    protected abstract void autoPositionForDesktop();

    protected abstract void autoPositionForSmartphone();

    protected abstract void autoPositionForVoice();

    protected abstract void setupVoiceResponses();

    public PageRegion getPageRegion(DeviceType deviceType) {
        deviceType.verifyTypeIsNotAll();
        return (PageRegion)this.regions.get(deviceType);
    }

    public void setPageRegion(DeviceType deviceType, PageRegion region) {
        deviceType.verifyTypeIsNotAll();
        PageRegion oldRegion = (PageRegion)this.regions.get(deviceType);
        if (oldRegion == region) {
            return;
        }
        this.regions.put(deviceType, region);
        Dialog newDialog = region == null ? null : region.getPage().getDialog();
        if (deviceType == DeviceType.VOICE) {
            if (this.getVoiceResponseSource() != null) {
                this.setVoiceResponseSource(null);
            }
            if (oldRegion != null) {
                oldRegion.removeElementContainerListener(this.pageRegionHandler);
                int i = 0;
                int n = oldRegion.getPage().getDialog().getNumConditions();
                while (i < n) {
                    this.setVoiceResponseDest(i, null);
                    this.setVoiceResponseLine(i, null);
                    ++i;
                }
            }
            this.voiceResponseLines.clear();
            this.voiceResponseDests.clear();
            if (region != null) {
                region.addElementContainerListener(this.pageRegionHandler);
            }
        }
        if (newDialog != null) {
            this.autoPosition(deviceType);
        }
        if (newDialog == null || !this.conditionStates.containsKey(newDialog)) {
            if (oldRegion != null) {
                Dialog oldDialog = oldRegion.getPage().getDialog();
                this.conditionStates.remove(oldDialog);
                this.conditionSignificance.remove(oldDialog);
            }
            if (newDialog != null) {
                ArrayList<Object> statesList = new ArrayList<Object>();
                ArrayList<Boolean> sigList = new ArrayList<Boolean>();
                this.conditionStates.put(newDialog, statesList);
                this.conditionSignificance.put(newDialog, sigList);
                int i = 0;
                int n = newDialog.getNumConditions();
                while (i < n) {
                    statesList.add(this.getDefaultState());
                    sigList.add(Boolean.FALSE);
                    ++i;
                }
            }
        }
        this.firePageRegionChanged(deviceType);
    }

    public Page getPage(DeviceType deviceType) {
        deviceType.verifyTypeIsNotAll();
        PageRegion pageRegion = this.getPageRegion(deviceType);
        if (pageRegion == null) {
            return null;
        }
        return pageRegion.getPage();
    }

    public Dialog getDialog() {
        Dialog dialog = null;
        Iterator i = this.getDeviceTypesVisibleTo().iterator();
        while (i.hasNext()) {
            DeviceType aDeviceType = (DeviceType)i.next();
            Page page = this.getPage(aDeviceType);
            if (page == null) continue;
            dialog = page.getDialog();
        }
        return dialog;
    }

    public InteractionGraph getInteractionGraph() {
        InteractionGraph graph = null;
        Iterator i = this.getDeviceTypesVisibleTo().iterator();
        while (i.hasNext()) {
            InteractionGraph pageGraph;
            DeviceType deviceType = (DeviceType)i.next();
            Page p = this.getPage(deviceType);
            if (p == null || (pageGraph = p.getInteractionGraph()) == null) continue;
            graph = pageGraph;
            break;
        }
        return graph;
    }

    public Collection getPatternInstanceMemberships() {
        return Collections.unmodifiableCollection(this.patternInstances);
    }

    public void addToPatternInstance(PatternInstance pi) {
        this.patternInstances.add(pi);
    }

    public boolean removeFromPatternInstance(PatternInstance pi) {
        return this.patternInstances.remove(pi);
    }

    public Control getControlBefore(DeviceType deviceType) {
        List controls = this.getPageRegion(deviceType).getControls();
        int index = controls.indexOf(this);
        if (index == 0) {
            return null;
        }
        return (Control)controls.get(index - 1);
    }

    public Control getControlAfter(DeviceType deviceType) {
        List controls = this.getPageRegion(deviceType).getControls();
        int index = controls.indexOf(this);
        if (index == controls.size() - 1) {
            return null;
        }
        return (Control)controls.get(index + 1);
    }

    public void addControlListener(ControlListener listener) {
        this.eventSource.addControlListener(listener);
    }

    public void removeControlListener(ControlListener listener) {
        this.eventSource.removeControlListener(listener);
    }

    protected void fireControlStateChanged(DeviceType deviceType) {
        this.eventSource.fireControlStateChanged(this, deviceType);
    }

    protected void fireControlSignificanceChanged(DeviceType deviceType) {
        this.eventSource.fireControlSignificanceChanged(this, deviceType);
    }

    protected void firePageRegionChanged(DeviceType deviceType) {
        this.eventSource.firePageRegionChanged(this, deviceType);
    }

    public void addConnectionDestListener(ConnectionDestListener listener) {
        this.connectionDestEventSource.addConnectionDestListener(listener);
    }

    public void removeConnectionDestListener(ConnectionDestListener listener) {
        this.connectionDestEventSource.removeConnectionDestListener(listener);
    }

    protected void fireInConnectionAdded(Connection connection) {
        this.connectionDestEventSource.fireInConnectionAdded(this, connection);
    }

    protected void fireInConnectionRemoved(Connection connection) {
        this.connectionDestEventSource.fireInConnectionRemoved(this, connection);
    }

    public void addConnectionSourceListener(ConnectionSourceListener listener) {
        this.connectionSourceEventSource.addConnectionSourceListener(listener);
    }

    public void removeConnectionSourceListener(ConnectionSourceListener listener) {
        this.connectionSourceEventSource.removeConnectionSourceListener(listener);
    }

    protected void fireOutConnectionAdded(Connection connection) {
        this.connectionSourceEventSource.fireOutConnectionAdded(this, connection);
    }

    protected void fireOutConnectionRemoved(Connection connection) {
        this.connectionSourceEventSource.fireOutConnectionRemoved(this, connection);
    }

    public void addControlVoiceListener(ControlVoiceListener listener) {
        this.voiceEventSource.addControlVoiceListener(listener);
    }

    public void removeControlVoiceListener(ControlVoiceListener listener) {
        this.voiceEventSource.removeControlVoiceListener(listener);
    }

    protected void firePromptTextChanged() {
        this.voiceEventSource.firePromptTextChanged(this);
    }

    protected void firePromptBoundsChanged() {
        this.voiceEventSource.firePromptBoundsChanged(this);
    }

    protected void fireResponseSourceChanged() {
        this.voiceEventSource.fireResponseSourceChanged(this);
    }

    protected void fireResponseDestChanged(int condition) {
        this.voiceEventSource.fireResponseDestChanged(this, condition);
    }

    protected void fireResponseLineChanged(int condition) {
        this.voiceEventSource.fireResponseLineChanged(this, condition);
    }

    protected void fireResponseTextChanged() {
        this.voiceEventSource.fireResponseTextChanged(this);
    }

    public abstract Content getContent();

    public Object getDefaultState() {
        return null;
    }

    public boolean isStateSignificantForCondition(Dialog dialog, int condition) {
        return (Boolean)((List)this.conditionSignificance.get(dialog)).get(condition);
    }

    public void setStateSignificantForCondition(Dialog dialog, int condition, boolean significant) {
        ((List)this.conditionSignificance.get(dialog)).set(condition, significant);
        this.fireControlSignificanceChanged(dialog.getDeviceType());
    }

    public Set getDialogsWithState() {
        return Collections.unmodifiableSet(this.conditionStates.keySet());
    }

    public Object getStateForCondition(Dialog dialog, int condition) {
        return ((List)this.conditionStates.get(dialog)).get(condition);
    }

    public void setStateForCondition(Dialog dialog, int condition, Object state) {
        ((List)this.conditionStates.get(dialog)).set(condition, state);
        this.fireControlStateChanged(dialog.getDeviceType());
    }

    public void addCondition(Dialog dialog) {
        ((List)this.conditionStates.get(dialog)).add(this.getDefaultState());
        ((List)this.conditionSignificance.get(dialog)).add(Boolean.FALSE);
    }

    public void addCondition(Dialog dialog, int index) {
        Integer conditionNum;
        ((List)this.conditionStates.get(dialog)).add(index, this.getDefaultState());
        ((List)this.conditionSignificance.get(dialog)).add(index, Boolean.FALSE);
        Iterator i = this.voiceResponseDests.keySet().iterator();
        while (i.hasNext()) {
            conditionNum = (Integer)i.next();
            if (conditionNum < index) continue;
            ConnectionDest dest = (ConnectionDest)this.voiceResponseDests.remove(conditionNum);
            this.voiceResponseDests.put(new Integer(conditionNum + 1), dest);
        }
        i = this.voiceResponseLines.keySet().iterator();
        while (i.hasNext()) {
            conditionNum = (Integer)i.next();
            if (conditionNum < index) continue;
            Line2D line = (Line2D)this.voiceResponseLines.remove(conditionNum);
            this.voiceResponseLines.put(new Integer(conditionNum + 1), line);
        }
    }

    public void removeCondition(Dialog dialog, int index) {
        Integer conditionNum;
        ((List)this.conditionStates.get(dialog)).remove(index);
        ((List)this.conditionSignificance.get(dialog)).remove(index);
        this.voiceResponseLines.remove(new Integer(index));
        this.voiceResponseDests.remove(new Integer(index));
        Iterator i = this.voiceResponseDests.keySet().iterator();
        while (i.hasNext()) {
            conditionNum = (Integer)i.next();
            if (conditionNum <= index) continue;
            ConnectionDest dest = (ConnectionDest)this.voiceResponseDests.remove(conditionNum);
            this.voiceResponseDests.put(new Integer(conditionNum - 1), dest);
        }
        i = this.voiceResponseLines.keySet().iterator();
        while (i.hasNext()) {
            conditionNum = (Integer)i.next();
            if (conditionNum <= index) continue;
            Line2D line = (Line2D)this.voiceResponseLines.remove(conditionNum);
            this.voiceResponseLines.put(new Integer(conditionNum - 1), line);
        }
    }

    protected AffineTransform getGlobalTransform(DeviceType deviceType) {
        Dialog dialog;
        Page page;
        AffineTransform transform = this.getTransform(deviceType);
        PageRegion pageRegion = this.getPageRegion(deviceType);
        if (pageRegion != null) {
            transform.preConcatenate(pageRegion.getTransform());
        }
        if ((page = this.getPage(deviceType)) != null) {
            transform.preConcatenate(page.getTransform());
        }
        if ((dialog = this.getDialog()) != null) {
            transform.preConcatenate(dialog.getTransform(deviceType));
        }
        return transform;
    }

    public Rectangle2D localToGlobal(DeviceType deviceType, Rectangle2D rect) {
        return GeomLib.transformRectangle(this.getGlobalTransform(deviceType), rect);
    }

    public Rectangle2D globalToLocal(DeviceType deviceType, Rectangle2D rect) {
        try {
            return GeomLib.transformRectangle(this.getGlobalTransform(deviceType).createInverse(), rect);
        }
        catch (NoninvertibleTransformException e) {
            DamaskAppExceptionHandler.log(e);
            return null;
        }
    }

    public Rectangle2D localToParent(DeviceType deviceType, Rectangle2D rect) {
        return GeomLib.transformRectangle(this.getTransform(deviceType), rect);
    }

    public Rectangle2D parentToLocal(DeviceType deviceType, Rectangle2D rect) {
        try {
            return GeomLib.transformRectangle(this.getTransform(deviceType).createInverse(), rect);
        }
        catch (NoninvertibleTransformException e) {
            DamaskAppExceptionHandler.log(e);
            return null;
        }
    }

    public Rectangle2D getVoicePromptBounds() {
        if (this.voicePromptBounds == null) {
            return null;
        }
        return (Rectangle2D)this.voicePromptBounds.clone();
    }

    public void setVoicePromptText(String text) {
        this.voicePromptText = text;
        this.firePromptTextChanged();
        this.setVoicePromptBounds(DamaskAppUtils.getRenderedTextBounds(text, DeviceType.VOICE.getDefaultFontSize()));
    }

    public String getVoicePromptText() {
        return this.voicePromptText;
    }

    public void setVoicePromptBounds(Rectangle2D voicePromptBounds) {
        this.voicePromptBounds = voicePromptBounds;
        this.updateVoiceBounds();
        this.firePromptBoundsChanged();
    }

    public Control getVoiceResponseSource() {
        return this.voiceResponseSource;
    }

    protected void setVoiceResponseSource(Control voiceResponseSource) {
        if (this.voiceResponseSource == voiceResponseSource) {
            return;
        }
        if (this.voiceResponseSource != null) {
            this.voiceResponseSource.removeInteractionElementListener(this.responseEndpointHandler);
        }
        this.voiceResponseSource = voiceResponseSource;
        if (this.voiceResponseSource != null) {
            this.voiceResponseSource.addInteractionElementListener(this.responseEndpointHandler);
        }
        this.fireResponseSourceChanged();
    }

    public ConnectionDest getVoiceResponseDest(int condition) {
        return (ConnectionDest)this.voiceResponseDests.get(new Integer(condition));
    }

    protected void setVoiceResponseDest(int condition, ConnectionDest responseDest) {
        ConnectionDest oldDest = this.getVoiceResponseDest(condition);
        if (oldDest == responseDest) {
            return;
        }
        if (oldDest != null) {
            oldDest.removeInteractionElementListener(this.responseEndpointHandler);
        }
        this.voiceResponseDests.put(new Integer(condition), responseDest);
        if (responseDest != null) {
            responseDest.addInteractionElementListener(this.responseEndpointHandler);
        }
        this.fireResponseDestChanged(condition);
    }

    private void updateVoiceResponseDestFromConnection(NavConnection connection) {
        this.setVoiceResponseDest(connection.getCondition(), connection.getDest(DeviceType.VOICE));
    }

    public Line2D getVoiceResponseLine(int condition) {
        if (condition >= this.voiceResponseLines.size()) {
            return null;
        }
        Line2D line = (Line2D)this.voiceResponseLines.get(new Integer(condition));
        if (line == null) {
            return null;
        }
        return (Line2D)line.clone();
    }

    public Map getVoiceResponseLines() {
        HashMap<Integer, Object> result = new HashMap<Integer, Object>();
        Iterator i = this.voiceResponseLines.keySet().iterator();
        while (i.hasNext()) {
            Integer condition;
            Line2D line = (Line2D)this.voiceResponseLines.get(condition = (Integer)i.next());
            result.put(condition, line == null ? null : line.clone());
        }
        return result;
    }

    public void setVoiceResponseLine(int condition, Line2D voiceResponseLine) {
        this.voiceResponseLines.put(new Integer(condition), voiceResponseLine == null ? null : voiceResponseLine.clone());
        this.updateVoiceBounds();
        this.fireResponseLineChanged(condition);
    }

    public List getVoiceResponseTextList() {
        return new ArrayList(this.voiceResponseText);
    }

    public Rectangle2D getVoiceResponseTextListBounds() {
        StringBuffer b = new StringBuffer();
        Iterator i = this.voiceResponseText.iterator();
        while (i.hasNext()) {
            String s = (String)i.next();
            b.append(s);
            if (!i.hasNext()) continue;
            b.append('\n');
        }
        return DamaskAppUtils.getRenderedTextBounds(b.toString(), DeviceType.VOICE.getDefaultFontSize());
    }

    public String getVoiceResponseText(int index) {
        return (String)this.voiceResponseText.get(index);
    }

    protected void addVoiceResponseText(String text) {
        this.voiceResponseText.add(text);
        this.fireResponseTextChanged();
    }

    protected void addVoiceResponseText(int index, String text) {
        this.voiceResponseText.add(index, text);
        this.fireResponseTextChanged();
    }

    protected void removeVoiceResponseText(int index) {
        this.voiceResponseText.remove(index);
        this.fireResponseTextChanged();
    }

    protected void setVoiceResponseText(int index, String text) {
        this.voiceResponseText.set(index, text);
        this.fireResponseTextChanged();
    }

    protected void setVoiceResponseTextList(List textList) {
        this.voiceResponseText.clear();
        this.voiceResponseText.addAll(textList);
        this.fireResponseTextChanged();
    }

    protected void clearVoiceResponseTextList() {
        this.voiceResponseText.clear();
        this.fireResponseTextChanged();
    }

    private void updateVoiceBounds() {
        if (this.voiceResponseSource == this) {
            this.voiceResponseSource.removeInteractionElementListener(this.responseEndpointHandler);
        }
        Rectangle2D allResponsesBounds = null;
        Iterator i = this.voiceResponseLines.values().iterator();
        while (i.hasNext()) {
            Line2D line = (Line2D)i.next();
            if (line == null) continue;
            if (allResponsesBounds == null) {
                allResponsesBounds = line.getBounds2D();
                continue;
            }
            Rectangle2D.union(allResponsesBounds, line.getBounds2D(), allResponsesBounds);
        }
        if (this.voicePromptBounds == null && allResponsesBounds == null) {
            this.setBounds(DeviceType.VOICE, null);
        } else if (this.voicePromptBounds == null) {
            this.setBounds(DeviceType.VOICE, allResponsesBounds);
        } else if (allResponsesBounds == null) {
            this.setBounds(DeviceType.VOICE, (Rectangle2D)this.voicePromptBounds.clone());
        } else {
            this.setBounds(DeviceType.VOICE, this.voicePromptBounds.createUnion(allResponsesBounds));
        }
        if (this.voiceResponseSource == this) {
            this.voiceResponseSource.addInteractionElementListener(this.responseEndpointHandler);
        }
    }

    public Collection getOutConnections() {
        return DamaskUtils.unmodifiableCollection(this.outNavConnections);
    }

    public NavConnection getOutConnection(DeviceType connectionOrigDeviceType, boolean forAllDeviceTypes, DamaskUserEvent userEvent, int condition) {
        NavConnection result = null;
        Iterator i = this.getOutConnections().iterator();
        while (i.hasNext()) {
            NavConnection connection = (NavConnection)i.next();
            if (connection.getOrigSpecifiedDeviceType() != connectionOrigDeviceType || connection.isForAllDeviceTypes() != forAllDeviceTypes || !connection.getUserEvent().matches(userEvent) || connection.getCondition() != condition) continue;
            result = connection;
            break;
        }
        return result;
    }

    public NavConnection getOutConnection(DeviceType connectionDeviceType, DamaskUserEvent userEvent, int condition) {
        NavConnection result = null;
        Iterator i = this.getOutConnections().iterator();
        while (i.hasNext()) {
            NavConnection connection = (NavConnection)i.next();
            if (!connection.isVisibleToDeviceType(connectionDeviceType) || !connection.getUserEvent().matches(userEvent) || connection.getCondition() != condition) continue;
            result = connection;
            break;
        }
        return result;
    }

    public void addOutConnection(Connection outConnection) {
        if (!this.outNavConnections.contains(outConnection)) {
            this.outNavConnections.add(outConnection);
            outConnection.addConnectionListener(this.connectionHandler);
            this.fireOutConnectionAdded(outConnection);
        }
    }

    public void removeOutConnection(Connection outConnection) {
        if (this.outNavConnections.contains(outConnection)) {
            this.outNavConnections.remove(outConnection);
            this.fireOutConnectionRemoved(outConnection);
        }
    }

    public Collection getInConnections() {
        return DamaskUtils.unmodifiableCollection(this.inNavConnections);
    }

    public void addInConnection(Connection inConnection) {
        if (!this.inNavConnections.contains(inConnection)) {
            this.inNavConnections.add(inConnection);
            this.fireInConnectionAdded(inConnection);
        }
    }

    public void removeInConnection(Connection inConnection) {
        if (this.inNavConnections.contains(inConnection)) {
            this.inNavConnections.remove(inConnection);
            this.fireInConnectionRemoved(inConnection);
        }
    }

    private static void copyStates(Control source, Control dest) {
        Iterator i = source.conditionStates.keySet().iterator();
        while (i.hasNext()) {
            Dialog dialog = (Dialog)i.next();
            dest.conditionStates.put(dialog, new ArrayList((List)source.conditionStates.get(dialog)));
            dest.conditionSignificance.put(dialog, new ArrayList((List)source.conditionSignificance.get(dialog)));
        }
    }

    public Object clone() {
        Control clone = (Control)super.clone();
        clone.outNavConnections = new HashSet();
        clone.inNavConnections = new HashSet();
        clone.regions = new HashMap();
        clone.patternInstances = new HashSet();
        clone.eventSource = new ControlEventSource();
        clone.conditionStates = new HashMap();
        clone.conditionSignificance = new HashMap();
        clone.voiceEventSource = new ControlVoiceEventSource();
        clone.voicePromptText = this.voicePromptText;
        if (this.voicePromptBounds != null) {
            clone.voicePromptBounds = (Rectangle2D)this.voicePromptBounds.clone();
        }
        clone.voiceResponseDests = new TreeMap();
        clone.voiceResponseLines = new TreeMap();
        Iterator i = this.voiceResponseLines.keySet().iterator();
        while (i.hasNext()) {
            Integer key = (Integer)i.next();
            clone.voiceResponseLines.put(key, this.voiceResponseLines.get(key));
        }
        clone.voiceResponseSource = null;
        clone.voiceResponseText = new ArrayList(this.voiceResponseText);
        clone.responseEndpointHandler = new VoiceResponseEndpointHandler();
        clone.connectionHandler = new ConnectionHandler();
        clone.pageRegionHandler = new PageRegionHandler();
        Control.copyStates(this, clone);
        return clone;
    }

    public String toLongString(int indentLevel, DeviceType deviceType) {
        StringBuffer sb = new StringBuffer();
        sb.append(StringLib.spaces(indentLevel * DamaskUtils.INDENT_SPACES));
        sb.append(this.toString());
        sb.append(": ");
        if (this.isVisibleToDeviceType(DeviceType.DESKTOP)) {
            sb.append("Desktop [bounds=" + this.getBounds(DeviceType.DESKTOP) + ", transform=" + this.getTransform(DeviceType.DESKTOP) + "] ");
        }
        if (this.isVisibleToDeviceType(DeviceType.SMARTPHONE)) {
            sb.append("Smartphone [bounds=" + this.getBounds(DeviceType.SMARTPHONE) + ", transform=" + this.getTransform(DeviceType.SMARTPHONE) + "] ");
        }
        if (this.isVisibleToDeviceType(DeviceType.VOICE)) {
            sb.append("Voice [promptBounds=" + this.getVoicePromptBounds() + ", transform=" + this.getTransform(DeviceType.VOICE) + "] ");
        }
        return sb.toString();
    }

    public String toLongString() {
        return this.toLongString(0, DeviceType.ALL);
    }

    protected void placeAfterAllControls(DeviceType deviceType) {
        PageRegion targetRegion = this.getPageRegion(deviceType);
        double controlBoundsMaxY = 0.0;
        Iterator i = targetRegion.getControls().iterator();
        while (i.hasNext()) {
            Control targetRegionControl = (Control)i.next();
            if (targetRegionControl == this) continue;
            controlBoundsMaxY = Math.max(controlBoundsMaxY, targetRegionControl.getBoundsInParentCoords(deviceType).getMaxY());
        }
        this.setTransform(deviceType, AffineTransform.getTranslateInstance(0.0, controlBoundsMaxY + 5.0));
    }

    protected void placeAfterPrevControl(DeviceType deviceType) {
        Rectangle2D controlBeforeBoundsInParentCoords;
        Control controlBefore;
        Control controlAfter = DamaskUtils.getNextLowLevelControl(this.getPageRegion(deviceType), this);
        Rectangle2D controlAfterBoundsInParentCoords = null;
        if (controlAfter != null) {
            controlAfterBoundsInParentCoords = controlAfter.getBoundsInParentCoords(deviceType);
        }
        AffineTransform newTransform = controlAfterBoundsInParentCoords != null ? AffineTransform.getTranslateInstance(controlAfterBoundsInParentCoords.getX(), controlAfterBoundsInParentCoords.getY()) : ((controlBefore = DamaskUtils.getPreviousLowLevelControl(this.getPageRegion(deviceType), this)) != null ? ((controlBeforeBoundsInParentCoords = controlBefore.getBoundsInParentCoords(deviceType)) != null ? AffineTransform.getTranslateInstance(controlBeforeBoundsInParentCoords.getX(), controlBeforeBoundsInParentCoords.getMaxY()) : new AffineTransform()) : new AffineTransform());
        this.setTransform(deviceType, newTransform);
    }

    protected void placeVoicePromptUnderPreviousPrompt() {
        Page page;
        int pageIndex;
        Control controlBefore = DamaskUtils.getPreviousLowLevelControl(this.getPageRegion(DeviceType.VOICE), this);
        if (controlBefore == null && (pageIndex = (page = this.getPage(DeviceType.VOICE)).getDialog().getPages(DeviceType.VOICE).indexOf(page) - 1) > 0) {
            page = page.getDialog().getPage(DeviceType.VOICE, pageIndex);
            List controls = page.getRegion(Direction.CENTER).getControls();
            while (controls.isEmpty() && pageIndex > 0) {
                page = page.getDialog().getPage(DeviceType.VOICE, --pageIndex);
                controls = page.getRegion(Direction.CENTER).getControls();
            }
            if (!controls.isEmpty()) {
                controlBefore = (Control)controls.get(controls.size() - 1);
            }
        }
        if (controlBefore == null) {
            this.setTransform(DeviceType.VOICE, new AffineTransform());
        } else if (controlBefore instanceof Content || controlBefore instanceof Trigger || controlBefore instanceof SelectOne) {
            Control prevControlWithPrompt = DamaskUtils.getPreviousControlWithPrompt(this.getPageRegion(DeviceType.VOICE), this);
            if (prevControlWithPrompt == null) {
                this.setTransform(DeviceType.VOICE, new AffineTransform());
            } else {
                Rectangle2D prevPromptBoundsInParent = prevControlWithPrompt.localToParent(DeviceType.VOICE, prevControlWithPrompt.getVoicePromptBounds());
                this.setTransform(DeviceType.VOICE, AffineTransform.getTranslateInstance(prevPromptBoundsInParent.getMinX(), prevPromptBoundsInParent.getMaxY() + 225.0));
            }
        } else {
            Line2D responseLine = controlBefore.getVoiceResponseLine(0);
            if (responseLine != null && this.getVoicePromptBounds() != null) {
                this.setTransform(DeviceType.VOICE, AffineTransform.getTranslateInstance(responseLine.getX2() - this.getVoicePromptBounds().getWidth() / 2.0, responseLine.getY2()));
            } else {
                this.setTransform(DeviceType.VOICE, new AffineTransform());
            }
        }
    }

    protected void redirectResponseToNextPrompt() {
        Control controlAfter = DamaskUtils.getNextControlWithPrompt(this.getPageRegion(DeviceType.VOICE), this);
        Control responseSource = this.getVoiceResponseSource();
        Rectangle2D balloonBounds = this.getVoiceResponseTextListBounds();
        if (responseSource == null && controlAfter == null) {
            this.setVoiceResponseLine(0, new Line2D.Double(balloonBounds.getWidth() / 2.0, 0.0, balloonBounds.getWidth() / 2.0, Math.max(225.0, balloonBounds.getHeight() + 40.0)));
            this.setVoiceResponseDest(0, null);
        } else {
            Rectangle2D sourceBounds = responseSource == null ? null : this.globalToLocal(DeviceType.VOICE, responseSource.localToGlobal(DeviceType.VOICE, responseSource.getVoicePromptBounds()));
            if (controlAfter == null) {
                this.setVoiceResponseLine(0, new Line2D.Double(sourceBounds.getCenterX(), sourceBounds.getCenterY(), sourceBounds.getCenterX(), sourceBounds.getCenterY() + Math.max(225.0, balloonBounds.getHeight() + 40.0)));
                this.setVoiceResponseDest(0, null);
            } else {
                double startY;
                double startX;
                Rectangle2D controlAfterPromptBounds = this.globalToLocal(DeviceType.VOICE, controlAfter.localToGlobal(DeviceType.VOICE, controlAfter.getVoicePromptBounds()));
                if (sourceBounds == null) {
                    startX = controlAfterPromptBounds.getCenterX();
                    startY = controlAfterPromptBounds.getCenterY() - Math.max(225.0, balloonBounds.getHeight() + 40.0);
                } else {
                    startX = sourceBounds.getCenterX();
                    startY = sourceBounds.getCenterY();
                }
                this.setVoiceResponseLine(0, new Line2D.Double(startX, startY, controlAfterPromptBounds.getCenterX(), controlAfterPromptBounds.getCenterY()));
                this.setVoiceResponseDest(0, controlAfter);
            }
        }
    }

    protected void reanchorSubsequentResponsesToThisPrompt() {
        List voiceRegionControls = this.getPageRegion(DeviceType.VOICE).getControls();
        int thisIndex = voiceRegionControls.indexOf(this);
        Rectangle2D promptBoundsInGlobalCoords = this.localToGlobal(DeviceType.VOICE, this.getVoicePromptBounds());
        ListIterator i = voiceRegionControls.listIterator(thisIndex + 1);
        while (i.hasNext()) {
            Control aNextControl = (Control)i.next();
            if (aNextControl.getVoicePromptBounds() != null) break;
            int j = 0;
            int n = this.getDialog().getNumConditions();
            while (j < n) {
                Line2D response = aNextControl.getVoiceResponseLine(j);
                if (response != null) {
                    Rectangle2D promptBoundsInANextControlCoords = aNextControl.globalToLocal(DeviceType.VOICE, promptBoundsInGlobalCoords);
                    aNextControl.setVoiceResponseLine(j, new Line2D.Double(promptBoundsInANextControlCoords.getCenterX(), promptBoundsInANextControlCoords.getCenterY(), response.getX2(), response.getY2()));
                    aNextControl.setVoiceResponseSource(this);
                }
                ++j;
            }
        }
    }

    protected void setupVoiceResponsesForControlWithPromptAndResponse() {
        Control controlAfter = DamaskUtils.getNextLowLevelControl(this.getPageRegion(DeviceType.VOICE), this);
        if (controlAfter instanceof Trigger) {
            this.setVoiceResponseLine(0, null);
            this.reanchorSubsequentResponsesToThisPrompt();
        } else {
            this.setVoiceResponseSource(this);
            this.redirectResponseToNextPrompt();
        }
    }

    protected void setupVoiceResponseForControlWithResponseOnly() {
        Control prevControlWithPrompt = DamaskUtils.getPreviousControlWithPrompt(this.getPageRegion(DeviceType.VOICE), this);
        Control nextControl = DamaskUtils.getNextLowLevelControl(this.getPageRegion(DeviceType.VOICE), this);
        if (prevControlWithPrompt == null && nextControl == null) {
            Rectangle2D balloonBounds = DamaskAppUtils.getRenderedTextBounds(StringLib.join(this.getVoiceResponseTextList(), "\n"), DeviceType.VOICE.getDefaultFontSize());
            this.setVoiceResponseLine(0, new Line2D.Double(balloonBounds.getWidth() / 2.0, 0.0, balloonBounds.getWidth() / 2.0, Math.max(225.0, balloonBounds.getHeight() + 40.0)));
            this.setVoiceResponseSource(null);
            this.setVoiceResponseDest(0, null);
        } else if (nextControl instanceof Trigger) {
            this.setVoiceResponseLine(0, null);
            this.setVoiceResponseSource(null);
            this.setVoiceResponseDest(0, null);
        } else {
            this.setVoiceResponseSource(prevControlWithPrompt);
            this.redirectResponseToNextPrompt();
        }
    }

    public Rectangle2D getVoiceResponseDestBounds() {
        return this.getVoicePromptBounds();
    }

    private void recalculateVoiceResponseLines() {
        int i = 0;
        int n = this.getDialog().getNumConditions();
        while (i < n) {
            this.recalculateVoiceResponseLine(i);
            ++i;
        }
    }

    private void recalculateVoiceResponseLine(int i) {
        Line2D oldLine = this.getVoiceResponseLine(i);
        Control source = this.getVoiceResponseSource();
        ConnectionDest dest = this.getVoiceResponseDest(i);
        if (oldLine == null) {
            return;
        }
        double dx = oldLine.getX2() - oldLine.getX1();
        double dy = oldLine.getY2() - oldLine.getY1();
        Rectangle2D sourcePromptBounds = source != null ? this.globalToLocal(DeviceType.VOICE, source.localToGlobal(DeviceType.VOICE, source.getVoicePromptBounds())) : null;
        Rectangle2D destPromptBounds = dest != null ? this.globalToLocal(DeviceType.VOICE, dest.localToGlobal(DeviceType.VOICE, dest.getVoiceResponseDestBounds())) : null;
        if (source != null || dest != null) {
            if (source == null) {
                double destAnchorY;
                double destAnchorX;
                if (dy >= 0.0) {
                    destAnchorX = destPromptBounds.getX() + 0.25 * destPromptBounds.getWidth();
                    destAnchorY = destPromptBounds.getY() + 0.75 * destPromptBounds.getHeight();
                } else {
                    destAnchorX = destPromptBounds.getX() + 0.75 * destPromptBounds.getWidth();
                    destAnchorY = destPromptBounds.getY() + 0.25 * destPromptBounds.getHeight();
                }
                this.setVoiceResponseLine(i, new Line2D.Double(destAnchorX - dx, destAnchorY - dy, destAnchorX, destAnchorY));
            } else if (dest == null) {
                double sourceAnchorY;
                double sourceAnchorX;
                if (dy >= 0.0) {
                    sourceAnchorX = sourcePromptBounds.getX() + 0.25 * sourcePromptBounds.getWidth();
                    sourceAnchorY = sourcePromptBounds.getY() + 0.75 * sourcePromptBounds.getHeight();
                } else {
                    sourceAnchorX = sourcePromptBounds.getX() + 0.75 * sourcePromptBounds.getWidth();
                    sourceAnchorY = sourcePromptBounds.getY() + 0.25 * sourcePromptBounds.getHeight();
                }
                this.setVoiceResponseLine(i, new Line2D.Double(sourceAnchorX, sourceAnchorY, sourceAnchorX + dx, sourceAnchorY + dy));
            } else {
                double fracY;
                double fracX;
                if (destPromptBounds.getCenterY() >= sourcePromptBounds.getCenterY()) {
                    fracX = 0.25;
                    fracY = 0.75;
                } else {
                    fracX = 0.75;
                    fracY = 0.25;
                }
                this.setVoiceResponseLine(i, new Line2D.Double(sourcePromptBounds.getX() + fracX * sourcePromptBounds.getWidth(), sourcePromptBounds.getY() + fracY * sourcePromptBounds.getHeight(), destPromptBounds.getX() + fracX * destPromptBounds.getWidth(), destPromptBounds.getY() + fracY * destPromptBounds.getHeight()));
            }
        }
    }

    private class VoiceResponseEndpointHandler
    implements InteractionElementListener,
    ControlVoiceListener {
        VoiceResponseEndpointHandler() {
        }

        public void elementBoundsUpdated(InteractionElementEvent e) {
        }

        public void elementTransformUpdated(InteractionElementEvent e) {
            if (e.getDeviceType() == DeviceType.VOICE) {
                Control.this.recalculateVoiceResponseLines();
            }
        }

        public void elementBorderUpdated(InteractionElementEvent e) {
        }

        public void promptTextChanged(ControlVoiceEvent e) {
        }

        public void promptBoundsChanged(ControlVoiceEvent e) {
            Control.this.recalculateVoiceResponseLines();
        }

        public void responseSourceChanged(ControlVoiceEvent e) {
        }

        public void responseDestChanged(ControlVoiceEvent e) {
        }

        public void responseLineChanged(ControlVoiceEvent e) {
        }

        public void responseTextChanged(ControlVoiceEvent e) {
        }
    }

    private class ConnectionHandler
    implements ConnectionListener {
        ConnectionHandler() {
        }

        public void sourceChanged(ConnectionEvent e) {
        }

        public void destChanged(ConnectionEvent e) {
            if (e.getDeviceType() == DeviceType.VOICE) {
                Control.this.updateVoiceResponseDestFromConnection((NavConnection)e.getConnection());
                Control.this.recalculateVoiceResponseLine(((NavConnection)e.getConnection()).getCondition());
            }
        }

        public void shapeChanged(ConnectionEvent e) {
        }

        public void userEventChanged(ConnectionEvent e) {
        }

        public void conditionChanged(ConnectionEvent e) {
        }
    }

    private class PageRegionHandler
    implements ElementContainerListener {
        PageRegionHandler() {
        }

        public void elementAdded(ElementContainerEvent e) {
            PageRegion voiceRegion = Control.this.getPageRegion(DeviceType.VOICE);
            if (voiceRegion != null && voiceRegion.getControls().indexOf(Control.this) != -1) {
                if (e.getElement() == Control.this) {
                    Control.this.setupVoiceResponses();
                    Control.this.nextVoiceControl = voiceRegion.getNextControl(Control.this);
                } else {
                    Control newNext = voiceRegion.getNextControl(Control.this);
                    if (e.getElement() == newNext) {
                        Control.this.setupVoiceResponses();
                        Control.this.nextVoiceControl = newNext;
                    }
                }
            }
        }

        public void elementRemoved(ElementContainerEvent e) {
            PageRegion voiceRegion = Control.this.getPageRegion(DeviceType.VOICE);
            if (voiceRegion != null && voiceRegion.getControls().indexOf(Control.this) != -1 && e.getElement() == Control.this.nextVoiceControl) {
                Control.this.setupVoiceResponses();
                Control.this.nextVoiceControl = voiceRegion.getNextControl(Control.this);
            }
        }
    }
}

