/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.component;

import edu.berkeley.guir.damask.Damask;
import edu.berkeley.guir.damask.DamaskUtils;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.component.Component;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.event.ContentEventSource;
import edu.berkeley.guir.damask.event.ContentListener;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.lib.collection.Map2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Content
extends Control {
    public static final DisplayMode INK = new DisplayMode("Ink");
    public static final DisplayMode TEXT = new DisplayMode("Text");
    public static final DisplayMode IMAGE = new DisplayMode("Picture");
    private static final DisplayMode[] SUPPORTED_DISPLAY_MODES = new DisplayMode[]{INK, TEXT, IMAGE};
    private static final int DEFAULT_FONT_SIZE = DamaskAppUtils.getDefaultFont().getSize();
    private String text = "";
    private boolean syncPromptTextWithText = true;
    private Map textSize = new HashMap();
    private List strokes = new ArrayList();
    private BufferedImage image = null;
    private Map fullSize = new HashMap();
    private Map2D stretchX = new Map2D();
    private Map2D stretchY = new Map2D();
    private Map preferredDisplayMode = new HashMap();
    private ContentEventSource contentEventSource = new ContentEventSource();

    public static Collection getSupportedDisplayModes() {
        return Collections.unmodifiableCollection(Arrays.asList(SUPPORTED_DISPLAY_MODES));
    }

    public Content(DeviceType deviceType) {
        super(deviceType);
        this.init();
    }

    public Content(Content content, DeviceType deviceType) {
        super(content, deviceType);
        this.init();
        Content.copyData(content, this);
    }

    public Content(DeviceType deviceType, String text) {
        this(deviceType);
        this.text = text;
        this.setFullSizeBounds(TEXT, DamaskAppUtils.getRenderedTextBounds(text, DEFAULT_FONT_SIZE));
        if (this.isVisibleToDeviceType(DeviceType.VOICE)) {
            super.setVoicePromptText(text);
        }
    }

    public Content(DeviceType deviceType, GeneralPath stroke) {
        this(deviceType);
        this.strokes.add(stroke);
        this.setFullSizeBounds(INK, stroke.getBounds2D());
        if (this.isVisibleToDeviceType(DeviceType.VOICE)) {
            super.setVoicePromptText("Text");
        }
    }

    public Content(DeviceType deviceType, Collection strokes) {
        this(deviceType);
        this.strokes = new ArrayList(strokes);
        this.setFullSizeBounds(INK, DamaskAppUtils.getUnionBounds(strokes));
        if (this.isVisibleToDeviceType(DeviceType.VOICE)) {
            super.setVoicePromptText("Text");
        }
    }

    public Content(DeviceType deviceType, BufferedImage image) {
        this(deviceType);
        this.image = image;
        this.setFullSizeBounds(IMAGE, new Rectangle2D.Double(image.getMinX(), image.getMinY(), image.getWidth(), image.getHeight()));
        if (this.isVisibleToDeviceType(DeviceType.VOICE)) {
            super.setVoicePromptText("Text");
        }
    }

    private void init() {
        int defaultFontSize = DamaskAppUtils.getDefaultFont().getSize();
        Iterator i = Damask.getSupportedDeviceTypes().iterator();
        while (i.hasNext()) {
            DeviceType aDeviceType = (DeviceType)i.next();
            this.textSize.put(aDeviceType, new Integer(defaultFontSize));
        }
    }

    public Collection getStrokes() {
        return this.strokes;
    }

    public void setStrokes(Collection strokes) {
        this.strokes = new ArrayList(strokes);
        this.setFullSizeBounds(INK, DamaskAppUtils.getUnionBounds(strokes));
        this.fireStrokesChanged();
    }

    public void addStroke(GeneralPath stroke) {
        this.strokes.add(stroke);
        Rectangle2D oldFullSizeBounds = this.getFullSizeBounds(INK);
        if (oldFullSizeBounds == null) {
            this.setFullSizeBounds(INK, stroke.getBounds2D());
        } else {
            this.setFullSizeBounds(INK, stroke.getBounds2D().createUnion(oldFullSizeBounds));
        }
        this.fireStrokeAdded(stroke);
    }

    public void removeStroke(GeneralPath stroke) {
        int index = this.strokes.indexOf(stroke);
        if (index != -1) {
            this.strokes.remove(stroke);
            this.setFullSizeBounds(INK, DamaskAppUtils.getUnionBounds(this.strokes));
            this.fireStrokeRemoved(stroke);
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
        this.setFullSizeBounds(TEXT, DamaskAppUtils.getRenderedTextBounds(this.text, DEFAULT_FONT_SIZE));
        this.fireTextChanged();
        if (this.isVisibleToDeviceType(DeviceType.VOICE) && this.syncPromptTextWithText) {
            super.setVoicePromptText(string);
        }
    }

    public void setVoicePromptText(String text) {
        if (this.syncPromptTextWithText) {
            this.setText(text);
        } else {
            super.setVoicePromptText(text);
        }
    }

    public boolean isPromptTextSyncedWithText() {
        return this.syncPromptTextWithText;
    }

    public void setPromptTextSyncedWithText(boolean flag) {
        this.syncPromptTextWithText = flag;
        if (flag) {
            this.firePromptTextIsSyncedWithText();
        } else {
            this.firePromptTextIsUnsyncedWithText();
        }
    }

    public boolean isVoicePlaceholder() {
        return this.getDeviceType() == DeviceType.VOICE && this.syncPromptTextWithText && this.text.length() == 0;
    }

    public int getTextSize(DeviceType deviceType) {
        deviceType.verifyTypeIsNotAll();
        return (Integer)this.textSize.get(deviceType);
    }

    public void setTextSize(DeviceType deviceType, int size) {
        Rectangle2D fullBounds = this.getFullSizeBounds(TEXT);
        Rectangle2D newBounds = DamaskAppUtils.getRenderedTextBounds(this.text, size);
        double scaleX = fullBounds == null || fullBounds.getWidth() == 0.0 ? 1.0 : newBounds.getWidth() / fullBounds.getWidth();
        double scaleY = fullBounds == null || fullBounds.getHeight() == 0.0 ? 1.0 : newBounds.getHeight() / fullBounds.getHeight();
        Iterator i = deviceType.getSpecificDeviceTypes().iterator();
        while (i.hasNext()) {
            DeviceType aDeviceType = (DeviceType)i.next();
            this.textSize.put(aDeviceType, new Integer(size));
            this.setStretchX(aDeviceType, TEXT, scaleX);
            this.setStretchY(aDeviceType, TEXT, scaleY);
            if (aDeviceType == DeviceType.VOICE) {
                this.setVoicePromptBounds(newBounds);
            } else if (this.getPreferredDisplayMode(aDeviceType) == TEXT) {
                super.setBounds(aDeviceType, newBounds);
            }
            this.fireTextChanged();
        }
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
        this.setFullSizeBounds(IMAGE, new Rectangle2D.Double(image.getMinX(), image.getMinY(), image.getWidth(), image.getHeight()));
        this.fireImageChanged();
    }

    public DisplayMode getPreferredDisplayMode(DeviceType deviceType) {
        deviceType.verifyTypeIsNotAll();
        DisplayMode result = (DisplayMode)this.preferredDisplayMode.get(deviceType);
        if (result == null) {
            result = this.getImage() != null ? IMAGE : (this.getText().length() != 0 ? TEXT : INK);
            this.preferredDisplayMode.put(deviceType, result);
        }
        return result;
    }

    public void setPreferredDisplayMode(DeviceType deviceType, DisplayMode displayMode) {
        Iterator i = deviceType.getSpecificDeviceTypes().iterator();
        while (i.hasNext()) {
            DeviceType aDeviceType = (DeviceType)i.next();
            DisplayMode oldMode = this.getPreferredDisplayMode(aDeviceType);
            this.preferredDisplayMode.put(aDeviceType, displayMode);
            this.firePreferredDisplayModeChanged(aDeviceType, oldMode);
            Rectangle2D fullBounds = this.getFullSizeBounds(displayMode);
            if (fullBounds != null) {
                super.setBounds(aDeviceType, new Rectangle2D.Double(fullBounds.getX(), fullBounds.getY(), fullBounds.getWidth() * this.getStretchX(aDeviceType, displayMode), fullBounds.getHeight() * this.getStretchY(aDeviceType, displayMode)));
                continue;
            }
            super.setBounds(aDeviceType, new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0));
        }
    }

    public Content getContent() {
        return this;
    }

    private double getStretchX(DeviceType deviceType, DisplayMode mode) {
        Double result = (Double)this.stretchX.get(deviceType, mode);
        return result;
    }

    private double getStretchY(DeviceType deviceType, DisplayMode mode) {
        Double result = (Double)this.stretchY.get(deviceType, mode);
        return result;
    }

    private void setStretchX(DeviceType deviceType, DisplayMode mode, double value) {
        this.stretchX.put(deviceType, mode, new Double(value));
    }

    private void setStretchY(DeviceType deviceType, DisplayMode mode, double value) {
        this.stretchY.put(deviceType, mode, new Double(value));
    }

    public Rectangle2D getFullSizeBounds(DisplayMode displayMode) {
        return (Rectangle2D)this.fullSize.get(displayMode);
    }

    protected void setFullSizeBounds(DisplayMode displayMode, Rectangle2D fullSizeBounds) {
        Rectangle2D oldFullSizeBounds = this.getFullSizeBounds(displayMode);
        this.fullSize.put(displayMode, fullSizeBounds);
        Iterator i = this.getDeviceTypesVisibleTo().iterator();
        while (i.hasNext()) {
            DeviceType aDeviceType = (DeviceType)i.next();
            Rectangle2D oldBounds = this.getBounds(aDeviceType);
            if (oldBounds != null && oldFullSizeBounds != null && !oldFullSizeBounds.isEmpty()) {
                double stretchXForADeviceType = this.getStretchX(aDeviceType, displayMode);
                double stretchYForADeviceType = this.getStretchY(aDeviceType, displayMode);
                Rectangle2D.Double newBounds = new Rectangle2D.Double(oldBounds.getX() + (fullSizeBounds.getX() - oldFullSizeBounds.getX()) * stretchXForADeviceType, oldBounds.getY() + (fullSizeBounds.getY() - oldFullSizeBounds.getY()) * stretchYForADeviceType, fullSizeBounds.getWidth() * stretchXForADeviceType, fullSizeBounds.getHeight() * stretchYForADeviceType);
                if (this.getPreferredDisplayMode(aDeviceType) != displayMode) continue;
                super.setBounds(aDeviceType, newBounds);
                continue;
            }
            this.setStretchX(aDeviceType, displayMode, 1.0);
            this.setStretchY(aDeviceType, displayMode, 1.0);
        }
    }

    public void setBoundsWithoutStretching(DeviceType deviceType, Rectangle2D newBounds) {
        super.setBounds(deviceType, newBounds);
    }

    public void setBounds(DeviceType deviceType, Rectangle2D newBounds) {
        Iterator i = deviceType.getSpecificDeviceTypes().iterator();
        while (i.hasNext()) {
            DeviceType aDeviceType = (DeviceType)i.next();
            DisplayMode displayMode = this.getPreferredDisplayMode(aDeviceType);
            Rectangle2D fullBounds = this.getFullSizeBounds(displayMode);
            if (newBounds == null) {
                this.stretchX.put(aDeviceType, displayMode, null);
                this.stretchY.put(aDeviceType, displayMode, null);
                continue;
            }
            if (fullBounds != null) {
                if (fullBounds.getWidth() == 0.0) {
                    this.setStretchX(aDeviceType, displayMode, 1.0);
                } else {
                    this.setStretchX(aDeviceType, displayMode, newBounds.getWidth() / fullBounds.getWidth());
                }
                if (fullBounds.getHeight() == 0.0) {
                    this.setStretchY(aDeviceType, displayMode, 1.0);
                    continue;
                }
                this.setStretchY(aDeviceType, displayMode, newBounds.getHeight() / fullBounds.getHeight());
                continue;
            }
            this.setStretchX(aDeviceType, displayMode, 1.0);
            this.setStretchY(aDeviceType, displayMode, 1.0);
        }
        super.setBounds(deviceType, newBounds);
    }

    public void addContentEventListener(ContentListener listener) {
        this.contentEventSource.addContentListener(listener);
    }

    public void removeContentEventListener(ContentListener listener) {
        this.contentEventSource.removeContentListener(listener);
    }

    protected void fireStrokeAdded(GeneralPath path) {
        this.contentEventSource.fireStrokeAdded(this, path);
    }

    protected void fireStrokeRemoved(GeneralPath path) {
        this.contentEventSource.fireStrokeRemoved(this, path);
    }

    protected void fireStrokesChanged() {
        this.contentEventSource.fireStrokesChanged(this);
    }

    protected void fireTextChanged() {
        this.contentEventSource.fireTextChanged(this);
    }

    protected void fireImageChanged() {
        this.contentEventSource.fireImageChanged(this);
    }

    protected void firePreferredDisplayModeChanged(DeviceType deviceType, DisplayMode oldMode) {
        this.contentEventSource.firePreferredDisplayModeChanged(this, deviceType, oldMode, this.getPreferredDisplayMode(deviceType));
    }

    protected void firePromptTextIsSyncedWithText() {
        this.contentEventSource.firePromptTextIsSyncedWithText(this);
    }

    protected void firePromptTextIsUnsyncedWithText() {
        this.contentEventSource.firePromptTextIsUnsyncedWithText(this);
    }

    protected void autoPositionForDesktop() {
        this.setBounds(DeviceType.DESKTOP, this.getFullSizeBounds(this.getPreferredDisplayMode(DeviceType.DESKTOP)));
        this.placeAfterAllControls(DeviceType.DESKTOP);
    }

    protected void autoPositionForSmartphone() {
        Rectangle2D newBounds = this.getFullSizeBounds(this.getPreferredDisplayMode(DeviceType.SMARTPHONE));
        if (newBounds.getHeight() > (double)DeviceType.SMARTPHONE.getPreferredContentHeight()) {
            double frac = (double)DeviceType.SMARTPHONE.getPreferredContentHeight() / newBounds.getHeight();
            newBounds = new Rectangle2D.Double(newBounds.getX(), newBounds.getY(), newBounds.getWidth() * frac, newBounds.getHeight() * frac);
        }
        this.setBounds(DeviceType.SMARTPHONE, newBounds);
        this.placeAfterAllControls(DeviceType.SMARTPHONE);
    }

    protected void autoPositionForVoice() {
        this.setTextSize(DeviceType.VOICE, DeviceType.VOICE.getDefaultFontSize());
        this.setVoicePromptBounds(DamaskAppUtils.getRenderedTextBounds(this.getVoicePromptText(), DeviceType.VOICE.getDefaultFontSize()));
        this.placeVoicePromptUnderPreviousPrompt();
    }

    protected void setupVoiceResponses() {
        Control controlAfter = DamaskUtils.getNextLowLevelControl(this.getPageRegion(DeviceType.VOICE), this);
        if (controlAfter != null && controlAfter.getVoicePromptBounds() != null) {
            this.createEmptyResponseToNextPrompt();
        } else {
            this.setVoiceResponseLine(0, null);
            this.setVoiceResponseSource(null);
            this.setVoiceResponseDest(0, null);
            this.reanchorSubsequentResponsesToThisPrompt();
        }
    }

    private void createEmptyResponseToNextPrompt() {
        Control controlAfter = DamaskUtils.getNextLowLevelControl(this.getPageRegion(DeviceType.VOICE), this);
        Rectangle2D controlAfterBoundsInParent = controlAfter.getBoundsInParentCoords(DeviceType.VOICE);
        Rectangle2D controlAfterBoundsInNewControl = this.parentToLocal(DeviceType.VOICE, controlAfterBoundsInParent);
        this.setVoiceResponseLine(0, new Line2D.Double(this.getVoicePromptBounds().getCenterX(), this.getVoicePromptBounds().getCenterY(), controlAfterBoundsInNewControl.getCenterX(), controlAfterBoundsInNewControl.getCenterY()));
        this.setVoiceResponseSource(this);
        this.setVoiceResponseDest(0, controlAfter);
    }

    private static void copyData(Content source, Content dest) {
        if (source.image != null) {
            dest.image = new BufferedImage(source.image.getWidth(), source.image.getHeight(), source.image.getType());
            source.image.copyData(dest.image.getRaster());
        }
        dest.strokes = new ArrayList();
        Iterator i = source.strokes.iterator();
        while (i.hasNext()) {
            GeneralPath stroke = (GeneralPath)i.next();
            dest.strokes.add(stroke.clone());
        }
        dest.text = source.text;
        dest.textSize = new HashMap(source.textSize);
        dest.fullSize = new HashMap(source.fullSize);
        dest.stretchX = new Map2D(source.stretchX);
        dest.stretchY = new Map2D(source.stretchY);
        dest.preferredDisplayMode = new HashMap(source.preferredDisplayMode);
        dest.contentEventSource = new ContentEventSource();
    }

    public Object clone() {
        Content clone = (Content)super.clone();
        Content.copyData(this, clone);
        return clone;
    }

    public Component createCopy(DeviceType deviceType) {
        return new Content(this, deviceType);
    }

    public String contentsToString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.text);
        if (this.strokes != null) {
            sb.append(" (sketch)");
        }
        if (this.image != null) {
            sb.append(" (image)");
        }
        return sb.toString();
    }

    public String toString() {
        return String.valueOf(super.toString()) + " - " + this.contentsToString();
    }

    public static class DisplayMode {
        private String name;

        private DisplayMode(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

