/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.component;

import edu.berkeley.guir.damask.DamaskUtils;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.InteractionElement;
import edu.berkeley.guir.damask.InteractionGraph;
import edu.berkeley.guir.damask.component.Component;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.damask.event.ElementContainerListener;
import edu.berkeley.guir.damask.event.ElementContainerSource;
import edu.berkeley.guir.damask.event.GroupEventSource;
import edu.berkeley.guir.damask.event.GroupListener;
import edu.berkeley.guir.lib.awt.geom.GeomLib;
import edu.berkeley.guir.lib.util.StringLib;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ComponentGroup
extends Component {
    private Set components = new HashSet();
    private Map boundsInPageRegion = new HashMap();
    private Map transformInPageRegion = new HashMap();
    private Dialog dialog = null;
    private ElementContainerSource containerEventSource = new ElementContainerSource();
    private GroupEventSource groupEventSource = new GroupEventSource();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.component.ComponentGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ComponentGroup(DeviceType deviceType) {
        super(deviceType);
    }

    public ComponentGroup(ComponentGroup group, DeviceType deviceType) {
        super(group, deviceType);
        Iterator i = group.getPageRegions(deviceType).iterator();
        while (i.hasNext()) {
            PageRegion region = (PageRegion)i.next();
            this.setBoundsInPageRegion(region, group.getBoundsInPageRegion(region));
            this.setTransformInPageRegion(region, group.getTransformInPageRegion(region));
        }
    }

    public void dispose() {
        super.dispose();
        Iterator i = this.components.iterator();
        while (i.hasNext()) {
            Component c = (Component)i.next();
            this.remove(c);
        }
    }

    protected void autoPosition() {
        HashMap<PageRegion, Rectangle2D> newBoundsForRegion = new HashMap<PageRegion, Rectangle2D>();
        PageRegion userSpecRegion = null;
        int numSpecedDevices = 0;
        Iterator i = this.getDeviceTypesVisibleTo().iterator();
        while (i.hasNext()) {
            DeviceType aDeviceType = (DeviceType)i.next();
            Set regions = this.getPageRegions(aDeviceType);
            if (regions.isEmpty()) continue;
            userSpecRegion = (PageRegion)regions.iterator().next();
            ++numSpecedDevices;
        }
        if (numSpecedDevices == this.getDeviceTypesVisibleTo().size()) {
            return;
        }
        Control controlBefore = this.dialog.getControlBefore(userSpecRegion, this.getDeviceType(), this.getTransformInPageRegion(userSpecRegion), this.getBoundsInPageRegion(userSpecRegion));
        Iterator<Object> i2 = this.getDeviceTypesVisibleTo().iterator();
        while (i2.hasNext()) {
            DeviceType aDeviceType = (DeviceType)i2.next();
            if (!this.getPageRegions(aDeviceType).isEmpty()) continue;
            Set children = this.getChildren(aDeviceType);
            if (children.isEmpty()) {
                double groupY;
                double groupX;
                PageRegion aRegion = DamaskUtils.getCorrespondingRegion(userSpecRegion, controlBefore, aDeviceType);
                if (controlBefore == null) {
                    groupX = 0.0;
                    groupY = 0.0;
                } else {
                    Rectangle2D controlBeforeBounds = controlBefore.getBoundsInParentCoords(aDeviceType);
                    groupX = controlBeforeBounds.getX();
                    groupY = controlBeforeBounds.getY();
                }
                newBoundsForRegion.put(aRegion, new Rectangle2D.Double(groupX, groupY, aDeviceType.getGroupDefaultWidth(), aDeviceType.getGroupDefaultHeight()));
                continue;
            }
            Iterator j = children.iterator();
            while (j.hasNext()) {
                PageRegion regionForChild;
                Component child = (Component)j.next();
                if (child instanceof Control) {
                    Control childControl = (Control)child;
                    Rectangle2D childControlBounds = childControl.getBoundsInParentCoords(aDeviceType);
                    regionForChild = childControl.getPageRegion(aDeviceType);
                    Rectangle2D bounds = (Rectangle2D)newBoundsForRegion.get(regionForChild);
                    if (bounds == null) {
                        bounds = childControlBounds;
                    } else {
                        Rectangle2D.union(bounds, childControlBounds, bounds);
                    }
                    newBoundsForRegion.put(regionForChild, bounds);
                    continue;
                }
                ComponentGroup childGroup = (ComponentGroup)child;
                Iterator k = childGroup.getPageRegions(aDeviceType).iterator();
                while (k.hasNext()) {
                    regionForChild = (PageRegion)k.next();
                    Rectangle2D childGroupBounds = GeomLib.transformRectangle(childGroup.getTransformInPageRegion(regionForChild), childGroup.getBoundsInPageRegion(regionForChild));
                    Rectangle2D bounds = (Rectangle2D)newBoundsForRegion.get(regionForChild);
                    if (bounds == null) {
                        bounds = childGroupBounds;
                    } else {
                        Rectangle2D.union(bounds, childGroupBounds, bounds);
                    }
                    newBoundsForRegion.put(regionForChild, bounds);
                }
            }
        }
        i2 = newBoundsForRegion.keySet().iterator();
        while (i2.hasNext()) {
            PageRegion region = (PageRegion)i2.next();
            this.setBoundsInPageRegion(region, (Rectangle2D)newBoundsForRegion.get(region));
            this.setTransformInPageRegion(region, new AffineTransform());
        }
    }

    public Set getChildren() {
        return new HashSet(this.components);
    }

    public Set getChildren(DeviceType deviceType) {
        HashSet<Component> result = new HashSet<Component>();
        Iterator i = this.components.iterator();
        while (i.hasNext()) {
            Component component = (Component)i.next();
            if (!component.isVisibleToDeviceType(deviceType)) continue;
            result.add(component);
        }
        return result;
    }

    public void add(Component child) {
        DamaskUtils.checkValidArgument(this.isVisibleToDeviceType(child.getDeviceType()), child + " with device type " + child.getDeviceType() + " cannot be added to " + this + " with device type " + this.getDeviceType());
        ComponentGroup oldGroup = child.getGroup();
        if (oldGroup != null) {
            oldGroup.remove(child);
        }
        this.components.add(child);
        child.setGroup(this);
        Iterator i = child.getDeviceTypesVisibleTo().iterator();
        while (i.hasNext()) {
            DeviceType aDeviceType = (DeviceType)i.next();
            this.fireElementAdded(aDeviceType, -1, child);
        }
    }

    public boolean remove(Component child) {
        boolean wasRemoved = this.components.remove(child);
        if (wasRemoved) {
            child.setGroup(null);
            Iterator i = child.getDeviceTypesVisibleTo().iterator();
            while (i.hasNext()) {
                DeviceType aDeviceType = (DeviceType)i.next();
                this.fireElementRemoved(aDeviceType, -1, child);
            }
        }
        return wasRemoved;
    }

    public int size(DeviceType deviceType) {
        return this.getChildren(deviceType).size();
    }

    public Dialog getDialog() {
        return this.dialog;
    }

    public void setDialog(Dialog dialog) {
        this.dialog = dialog;
        this.autoPosition();
    }

    public InteractionGraph getInteractionGraph() {
        Dialog d = this.getDialog();
        if (d != null) {
            return d.getInteractionGraph();
        }
        return null;
    }

    public Set getPageRegions() {
        return new HashSet(this.boundsInPageRegion.keySet());
    }

    public Set getPageRegions(DeviceType deviceType) {
        if (deviceType == DeviceType.ALL) {
            return this.getPageRegions();
        }
        TreeSet<PageRegion> result = new TreeSet<PageRegion>(new PageRegionComparator());
        Iterator i = this.boundsInPageRegion.keySet().iterator();
        while (i.hasNext()) {
            PageRegion region = (PageRegion)i.next();
            if (region.getDeviceType() != deviceType) continue;
            result.add(region);
        }
        return result;
    }

    public Rectangle2D getBoundsInPageRegion(PageRegion pageRegion) {
        Rectangle2D bounds = (Rectangle2D)this.boundsInPageRegion.get(pageRegion);
        if (bounds == null) {
            return null;
        }
        return (Rectangle2D)bounds.clone();
    }

    public void setBoundsInPageRegion(PageRegion pageRegion, Rectangle2D bounds) {
        if (bounds == null) {
            this.boundsInPageRegion.remove(pageRegion);
        } else {
            this.boundsInPageRegion.put(pageRegion, bounds);
        }
        this.fireElementBoundsUpdated(pageRegion);
    }

    public Rectangle2D getBounds(DeviceType deviceType) {
        throw new UnsupportedOperationException("Use getBoundsInPageRegion()");
    }

    public void setBounds(DeviceType deviceType, Rectangle2D newBounds) {
        throw new UnsupportedOperationException("Use setBoundsInPageRegion()");
    }

    public AffineTransform getTransformInPageRegion(PageRegion pageRegion) {
        AffineTransform transform = (AffineTransform)this.transformInPageRegion.get(pageRegion);
        if (transform == null) {
            return null;
        }
        return (AffineTransform)transform.clone();
    }

    public void setTransformInPageRegion(PageRegion pageRegion, AffineTransform transform) {
        if (transform == null) {
            this.transformInPageRegion.remove(pageRegion);
        } else {
            this.transformInPageRegion.put(pageRegion, transform);
        }
        this.fireElementTransformUpdated(pageRegion);
    }

    public AffineTransform getTransform(DeviceType deviceType) {
        throw new UnsupportedOperationException("Use getTransformInPageRegion()");
    }

    public void setTransform(DeviceType deviceType, AffineTransform newTransform) {
        throw new UnsupportedOperationException("Use setTransformInPageRegion()");
    }

    public void addGroupListener(GroupListener listener) {
        this.groupEventSource.addGroupListener(listener);
    }

    public void removeGroupListener(GroupListener listener) {
        this.groupEventSource.removeGroupListener(listener);
    }

    private void fireElementAdded(DeviceType deviceType, int index, InteractionElement e) {
        this.containerEventSource.fireElementAdded(this, deviceType, index, e);
    }

    private void fireElementRemoved(DeviceType deviceType, int index, InteractionElement e) {
        this.containerEventSource.fireElementRemoved(this, deviceType, index, e);
    }

    protected void fireElementTransformUpdated(PageRegion region) {
        this.groupEventSource.fireElementTransformUpdated(this, region);
    }

    public void addElementContainerListener(ElementContainerListener listener) {
        this.containerEventSource.addElementContainerListener(listener);
    }

    public void removeElementContainerListener(ElementContainerListener listener) {
        this.containerEventSource.removeElementContainerListener(listener);
    }

    private void fireElementBoundsUpdated(PageRegion region) {
        this.groupEventSource.fireElementBoundsUpdated(this, region);
    }

    public Component createCopy(DeviceType deviceType) {
        return new ComponentGroup(this, deviceType);
    }

    public Object clone() {
        return this.clone(new HashMap());
    }

    public Object clone(Map elementClones) {
        ComponentGroup clone = (ComponentGroup)super.clone();
        clone.boundsInPageRegion = new HashMap(this.boundsInPageRegion);
        clone.transformInPageRegion = new HashMap(this.transformInPageRegion);
        clone.containerEventSource = new ElementContainerSource();
        clone.groupEventSource = new GroupEventSource();
        clone.components = new HashSet();
        Iterator i = this.components.iterator();
        while (i.hasNext()) {
            Component component = (Component)i.next();
            if (component instanceof ComponentGroup) {
                clone.components.add(((ComponentGroup)component).clone(elementClones));
                continue;
            }
            Control control = (Control)component;
            Control controlClone = (Control)elementClones.get(control);
            if (controlClone == null) continue;
            clone.components.add(controlClone);
        }
        return clone;
    }

    public String toLongString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.toString());
        sb.append('\n');
        sb.append(this.components.toString());
        return sb.toString();
    }

    public String toLongString(int indentLevel, DeviceType deviceType) {
        if (!$assertionsDisabled && deviceType == DeviceType.ALL) {
            throw new AssertionError((Object)"Device cannot be ALL");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(StringLib.spaces(indentLevel * DamaskUtils.INDENT_SPACES));
        sb.append(this.toString());
        sb.append('\n');
        sb.append(StringLib.spaces((indentLevel + 1) * DamaskUtils.INDENT_SPACES));
        sb.append(this.components.toString());
        return sb.toString();
    }

    private static class PageRegionComparator
    implements Comparator {
        PageRegionComparator() {
        }

        private int getPageNumber(PageRegion region) {
            Page page = region.getPage();
            return page.getDialog().getPages(page.getDeviceType()).indexOf(page);
        }

        public int compare(Object o1, Object o2) {
            int p2;
            if (!(o1 instanceof PageRegion)) {
                throw new ClassCastException("o1 must be of type PageRegion, not " + (o1 == null ? null : o1.getClass()));
            }
            if (!(o2 instanceof PageRegion)) {
                throw new ClassCastException("o2 must be of type PageRegion, not " + (o2 == null ? null : o2.getClass()));
            }
            int p1 = this.getPageNumber((PageRegion)o1);
            if (p1 < (p2 = this.getPageNumber((PageRegion)o2))) {
                return -1;
            }
            if (p1 == p2) {
                return 0;
            }
            return 1;
        }
    }
}

