/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.component;

import edu.berkeley.guir.damask.AbstractInteractionElement;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.component.ComponentGroup;
import edu.berkeley.guir.damask.dialog.Dialog;
import java.util.HashSet;
import java.util.Set;

public abstract class Component
extends AbstractInteractionElement {
    private String name = "";
    private ComponentGroup group = null;
    private DeviceType deviceType;

    public Component(DeviceType deviceType) {
        this.deviceType = deviceType;
    }

    public Component(Component component, DeviceType deviceType) {
        super(component);
        this.name = component.getName();
        this.deviceType = deviceType;
    }

    public void dispose() {
        this.setGroup(null);
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public Set getDeviceTypesVisibleTo() {
        return new HashSet(this.getDeviceType().getSpecificDeviceTypes());
    }

    public boolean isForAllDeviceTypes() {
        return this.getDeviceType() == DeviceType.ALL;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public abstract Dialog getDialog();

    public ComponentGroup getGroup() {
        return this.group;
    }

    protected void setGroup(ComponentGroup group) {
        this.group = group;
    }

    public abstract String toLongString(int var1, DeviceType var2);

    public abstract Component createCopy(DeviceType var1);

    public Object clone() {
        Component clone = (Component)super.clone();
        this.group = null;
        return clone;
    }
}

