/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.command;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.command.ModifyGraphCommand;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.damask.pattern.PatternInstance;
import edu.berkeley.guir.lib.satin.command.UndoableCommand;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class UngroupStrokesCommand
extends UndoableCommand
implements ModifyGraphCommand {
    private final Content content;
    private Dialog dialog;
    private final Map contentPositions = new HashMap();
    private final Map scaleX = new HashMap();
    private final Map scaleY = new HashMap();
    private final List newContents = new ArrayList();
    private final Set contentPatternInstances = new HashSet();

    public UngroupStrokesCommand(Content content) {
        this.content = content;
    }

    public String getPresentationName() {
        return "Ungroup strokes in " + this.content;
    }

    public boolean canRedo() {
        return true;
    }

    public void run() {
        this.dialog = this.content.getDialog();
        Rectangle2D contentFullBounds = this.content.getFullSizeBounds(Content.INK);
        Iterator j = this.content.getDeviceTypesVisibleTo().iterator();
        while (j.hasNext()) {
            DeviceType aDeviceType = (DeviceType)j.next();
            PageRegion aRegion = this.content.getPageRegion(aDeviceType);
            this.contentPositions.put(aRegion, new Integer(aRegion.getControls().indexOf(this.content)));
            Rectangle2D bounds = this.content.getBounds(aDeviceType);
            this.scaleX.put(aDeviceType, new Double(bounds.getWidth() / contentFullBounds.getWidth()));
            this.scaleY.put(aDeviceType, new Double(bounds.getHeight() / contentFullBounds.getHeight()));
        }
        DeviceType deviceType = this.content.getDeviceType();
        Iterator i = this.content.getStrokes().iterator();
        while (i.hasNext()) {
            GeneralPath stroke = (GeneralPath)i.next();
            GeneralPath newStroke = (GeneralPath)stroke.clone();
            Rectangle2D strokeFullBounds = stroke.getBounds2D();
            newStroke.transform(AffineTransform.getTranslateInstance(-strokeFullBounds.getX(), -strokeFullBounds.getY()));
            newStroke.transform(AffineTransform.getTranslateInstance(-contentFullBounds.getX(), -contentFullBounds.getY()));
            Content newContent = new Content(deviceType, newStroke);
            Iterator j2 = deviceType.getSpecificDeviceTypes().iterator();
            while (j2.hasNext()) {
                DeviceType aDeviceType = (DeviceType)j2.next();
                double scaleXForADeviceType = (Double)this.scaleX.get(aDeviceType);
                double scaledRelativeX = (strokeFullBounds.getX() - contentFullBounds.getX()) * scaleXForADeviceType;
                double scaleYForADeviceType = (Double)this.scaleY.get(aDeviceType);
                double scaledRelativeY = (strokeFullBounds.getY() - contentFullBounds.getY()) * scaleYForADeviceType;
                newContent.setBounds(aDeviceType, new Rectangle2D.Double(0.0, 0.0, strokeFullBounds.getWidth() * scaleXForADeviceType, strokeFullBounds.getHeight() * scaleYForADeviceType));
                Rectangle2D contentBoundsInParentCoords = this.content.getBoundsInParentCoords(aDeviceType);
                newContent.setTransform(aDeviceType, AffineTransform.getTranslateInstance(scaledRelativeX + contentBoundsInParentCoords.getX(), scaledRelativeY + contentBoundsInParentCoords.getY()));
            }
            this.newContents.add(newContent);
        }
        this.redo();
    }

    public void redo() {
        this.contentPatternInstances.clear();
        this.contentPatternInstances.addAll(this.content.getPatternInstanceMemberships());
        ListIterator i = this.newContents.listIterator(this.newContents.size());
        while (i.hasPrevious()) {
            Content newContent = (Content)i.previous();
            this.dialog.addControl(this.contentPositions, newContent);
            Iterator j = this.contentPatternInstances.iterator();
            while (j.hasNext()) {
                PatternInstance instance = (PatternInstance)j.next();
                instance.add(newContent);
            }
        }
        this.dialog.removeControl(this.content);
        Iterator j = this.contentPatternInstances.iterator();
        while (j.hasNext()) {
            PatternInstance instance = (PatternInstance)j.next();
            instance.remove(this.content);
        }
    }

    public void undo() {
        Iterator i = this.newContents.iterator();
        while (i.hasNext()) {
            Content newContent = (Content)i.next();
            this.dialog.removeControl(newContent);
            Iterator j = this.contentPatternInstances.iterator();
            while (j.hasNext()) {
                PatternInstance instance = (PatternInstance)j.next();
                instance.remove(newContent);
            }
        }
        this.dialog.addControl(this.contentPositions, this.content);
        Iterator j = this.contentPatternInstances.iterator();
        while (j.hasNext()) {
            PatternInstance instance = (PatternInstance)j.next();
            instance.add(this.content);
        }
    }
}

