/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.command;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.Direction;
import edu.berkeley.guir.damask.command.ModifyGraphCommand;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.lib.satin.command.UndoableCommand;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Iterator;

public class SplitPageCommand
extends UndoableCommand
implements ModifyGraphCommand {
    private final Page page;
    private Rectangle2D pageOldBounds;
    private final Collection controlsInNewPage;
    private final double splitY;

    public SplitPageCommand(Page page, Collection controlsInNewPage, double splitY) {
        this.page = page;
        this.controlsInNewPage = controlsInNewPage;
        this.splitY = splitY;
    }

    public String getPresentationName() {
        return "Split " + this.page + " from " + this.controlsInNewPage;
    }

    public boolean canRedo() {
        return true;
    }

    public void run() {
        Page page2 = this.page.split(this.controlsInNewPage);
        if (this.page.getDeviceType() != DeviceType.VOICE) {
            PageRegion pageCenter = this.page.getRegion(Direction.CENTER);
            double dh = pageCenter.getBounds().getHeight() - this.splitY;
            this.pageOldBounds = this.page.getBounds();
            this.page.setBounds(new Rectangle2D.Double(this.pageOldBounds.getX(), this.pageOldBounds.getY(), this.pageOldBounds.getWidth(), this.pageOldBounds.getHeight() - dh));
            Rectangle2D page2OldBounds = page2.getBounds();
            page2.setBounds(new Rectangle2D.Double(page2OldBounds.getX(), page2OldBounds.getY(), this.pageOldBounds.getWidth(), this.pageOldBounds.getHeight() - this.splitY));
            DeviceType page2DeviceType = page2.getDeviceType();
            Iterator i = this.controlsInNewPage.iterator();
            while (i.hasNext()) {
                Control control = (Control)i.next();
                AffineTransform transform = control.getTransform(page2DeviceType);
                transform.translate(0.0, -this.splitY);
                control.setTransform(page2DeviceType, transform);
            }
        }
    }

    public void redo() {
        this.run();
    }

    public void undo() {
        this.page.mergeWithAdjacent();
        this.page.setBounds(this.pageOldBounds);
        DeviceType pageDeviceType = this.page.getDeviceType();
        if (pageDeviceType != DeviceType.VOICE) {
            Iterator i = this.controlsInNewPage.iterator();
            while (i.hasNext()) {
                Control control = (Control)i.next();
                AffineTransform transform = control.getTransform(pageDeviceType);
                transform.translate(0.0, this.splitY);
                control.setTransform(pageDeviceType, transform);
            }
        }
    }
}

