/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.command;

import edu.berkeley.guir.damask.DamaskUtils;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.command.AddComponentToGroupCommand;
import edu.berkeley.guir.damask.command.AddConnectionCommand;
import edu.berkeley.guir.damask.command.AddControlCommand;
import edu.berkeley.guir.damask.command.AddGroupCommand;
import edu.berkeley.guir.damask.command.AddItemCommand;
import edu.berkeley.guir.damask.command.ModifyGraphMacroCommand;
import edu.berkeley.guir.damask.command.RemoveConnectionCommand;
import edu.berkeley.guir.damask.command.RemoveGroupCommand;
import edu.berkeley.guir.damask.component.Component;
import edu.berkeley.guir.damask.component.ComponentGroup;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.component.Select;
import edu.berkeley.guir.damask.component.SelectMany;
import edu.berkeley.guir.damask.component.SelectOne;
import edu.berkeley.guir.damask.connection.Connection;
import edu.berkeley.guir.damask.connection.NavConnection;
import edu.berkeley.guir.damask.dialog.PageRegion;
import java.util.HashSet;
import java.util.Iterator;

public class SplitComponentIntoDeviceSpecificVersionsCommand
extends ModifyGraphMacroCommand {
    private final Component component;
    private final DeviceType targetDeviceType;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SplitComponentIntoDeviceSpecificVersionsCommand(Component component, DeviceType targetDeviceType) {
        this.component = component;
        this.targetDeviceType = targetDeviceType;
        if (component instanceof Control) {
            this.splitControlIntoDeviceSpecificControls((Control)component, targetDeviceType);
        } else {
            this.splitGroupIntoDeviceSpecificGroups((ComponentGroup)component, targetDeviceType);
        }
    }

    private Control splitControlIntoDeviceSpecificControls(Control control, DeviceType targetDeviceType) {
        DamaskUtils.checkValidArgument(control.getDeviceType() == DeviceType.ALL, "Device type of " + control + " must be ALL, not " + control.getDeviceType());
        Iterator i = control.getOutConnections().iterator();
        while (i.hasNext()) {
            Connection outConnection = (Connection)i.next();
            this.addCommand(new RemoveConnectionCommand(outConnection, false));
        }
        Control newControl = (Control)control.createCopy(targetDeviceType);
        PageRegion targetRegion = control.getPageRegion(targetDeviceType);
        ComponentGroup targetGroup = control.getGroup();
        if (newControl instanceof Select.Item) {
            Class<?> selectClass;
            Select.Item newItem = (Select.Item)newControl;
            if (newItem instanceof SelectOne.Item) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("edu.berkeley.guir.damask.component.SelectOne");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                selectClass = clazz;
            } else {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("edu.berkeley.guir.damask.component.SelectMany");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                selectClass = clazz;
            }
            Select selectToAddTo = DamaskUtils.findExistingSelect(targetRegion, targetGroup, newItem.getDeviceType(), selectClass, Select.FULL);
            if (selectToAddTo == null) {
                Select newSelect = newItem instanceof SelectOne.Item ? new SelectOne(targetDeviceType) : new SelectMany(targetDeviceType);
                newSelect.addItem(newItem);
                this.addCommand(new AddControlCommand(targetRegion, (Control)newSelect));
                if (targetGroup != null) {
                    this.addCommand(new AddComponentToGroupCommand(targetGroup, newControl));
                }
            } else {
                this.addCommand(new AddItemCommand(selectToAddTo, newItem));
            }
        } else {
            this.addCommand(new AddControlCommand(targetRegion, newControl));
            if (targetGroup != null) {
                this.addCommand(new AddComponentToGroupCommand(targetGroup, newControl));
            }
        }
        DamaskUtils.addCommandsForRemovingControlToMacroCommand(this, control);
        Iterator j = control.getOutConnections().iterator();
        while (j.hasNext()) {
            NavConnection connection = (NavConnection)j.next();
            this.addCommand(new AddConnectionCommand(targetDeviceType, false, newControl, connection.getUserEvent(), connection.getCondition(), connection.getConnectionDest(targetDeviceType), connection.getShape(targetDeviceType)));
        }
        return newControl;
    }

    private ComponentGroup splitGroupIntoDeviceSpecificGroups(ComponentGroup group, DeviceType targetDeviceType) {
        DamaskUtils.checkValidArgument(group.getDeviceType() == DeviceType.ALL, "Device type of " + group + " must be ALL, not " + group.getDeviceType());
        ComponentGroup newGroup = (ComponentGroup)group.createCopy(targetDeviceType);
        PageRegion targetRegion = (PageRegion)newGroup.getPageRegions(targetDeviceType).iterator().next();
        ComponentGroup targetGroup = group.getGroup();
        this.addCommand(new AddGroupCommand(targetRegion.getPage().getDialog(), newGroup));
        if (targetGroup != null) {
            this.addCommand(new AddComponentToGroupCommand(targetGroup, newGroup));
        }
        Iterator i = group.getChildren().iterator();
        while (i.hasNext()) {
            Component child = (Component)i.next();
            HashSet<Component> childrenToAdd = new HashSet<Component>();
            if (child.getDeviceType() == DeviceType.ALL) {
                if (child instanceof Control) {
                    childrenToAdd.add(this.splitControlIntoDeviceSpecificControls((Control)child, targetDeviceType));
                } else {
                    childrenToAdd.add(this.splitGroupIntoDeviceSpecificGroups((ComponentGroup)child, targetDeviceType));
                }
            } else {
                childrenToAdd.add(child);
            }
            Iterator j = childrenToAdd.iterator();
            while (j.hasNext()) {
                Component newChild = (Component)j.next();
                this.addCommand(new AddComponentToGroupCommand(newGroup, newChild));
            }
        }
        this.addCommand(new RemoveGroupCommand(group));
        return newGroup;
    }

    public String getPresentationName() {
        return "Convert device-all " + this.component + " into " + this.targetDeviceType;
    }
}

