/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.command;

import edu.berkeley.guir.damask.command.ModifyGraphCommand;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.lib.satin.command.UndoableCommand;
import java.awt.geom.Line2D;

public class SetVoiceResponseLineCommand
extends UndoableCommand
implements ModifyGraphCommand {
    private final Control control;
    private final int condition;
    private final Line2D newLine;
    private final Line2D oldLine;

    public SetVoiceResponseLineCommand(Control control, int condition, Line2D newLine) {
        this.control = control;
        this.condition = condition;
        this.newLine = newLine;
        this.oldLine = control.getVoiceResponseLine(condition);
    }

    public String getPresentationName() {
        return "Set response line of " + this.control + " for condition " + this.condition + ": " + this.oldLine + "->" + this.newLine;
    }

    public boolean canRedo() {
        return true;
    }

    public void run() {
        this.control.setVoiceResponseLine(this.condition, this.newLine);
    }

    public void redo() {
        this.run();
    }

    public void undo() {
        this.control.setVoiceResponseLine(this.condition, this.oldLine);
    }
}

