/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.command;

import edu.berkeley.guir.damask.command.ModifyGraphCommand;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.lib.satin.command.UndoableCommand;

public class SetVoicePromptTextCommand
extends UndoableCommand
implements ModifyGraphCommand {
    private String oldText;
    private final String newText;
    private final Content content;

    public SetVoicePromptTextCommand(Content content, String newText) {
        this.content = content;
        this.newText = newText;
    }

    public String getPresentationName() {
        return "Set voice prompt of content " + this.content + " to " + this.newText;
    }

    public boolean canRedo() {
        return true;
    }

    public void run() {
        this.oldText = this.content.getVoicePromptText();
        this.content.setVoicePromptText(this.newText);
    }

    public void redo() {
        this.run();
    }

    public void undo() {
        this.content.setVoicePromptText(this.oldText);
    }
}

