/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.command;

import edu.berkeley.guir.damask.command.ModifyGraphCommand;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.lib.satin.command.UndoableCommand;
import java.awt.geom.Rectangle2D;

public class SetVoicePromptBoundsCommand
extends UndoableCommand
implements ModifyGraphCommand {
    private final Control control;
    private final Rectangle2D newVoicePromptBounds;
    private final Rectangle2D oldVoicePromptBounds;

    public SetVoicePromptBoundsCommand(Control control, Rectangle2D newVoicePromptBounds) {
        this.control = control;
        this.newVoicePromptBounds = newVoicePromptBounds;
        this.oldVoicePromptBounds = control.getVoicePromptBounds();
    }

    public String getPresentationName() {
        return "Set bounds of voice prompt of " + this.control + ": " + this.oldVoicePromptBounds + "->" + this.newVoicePromptBounds;
    }

    public boolean canRedo() {
        return true;
    }

    public void run() {
        this.control.setVoicePromptBounds(this.newVoicePromptBounds);
    }

    public void redo() {
        this.run();
    }

    public void undo() {
        this.control.setVoicePromptBounds(this.oldVoicePromptBounds);
    }
}

