/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.command;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.InteractionElement;
import edu.berkeley.guir.damask.command.ModifyGraphCommand;
import edu.berkeley.guir.damask.component.ComponentGroup;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.lib.satin.command.UndoableCommand;
import java.awt.geom.AffineTransform;

public class SetTransformCommand
extends UndoableCommand
implements ModifyGraphCommand {
    private final InteractionElement element;
    private final DeviceType deviceType;
    private final PageRegion region;
    private final AffineTransform newTransform;
    private final AffineTransform oldTransform;

    public SetTransformCommand(InteractionElement element, DeviceType deviceType, AffineTransform newTransform) {
        this.element = element;
        this.deviceType = deviceType;
        this.region = null;
        this.newTransform = newTransform;
        this.oldTransform = element.getTransform(deviceType);
    }

    public SetTransformCommand(ComponentGroup group, PageRegion region, AffineTransform newTransform) {
        this.element = group;
        this.deviceType = null;
        this.region = region;
        this.newTransform = newTransform;
        this.oldTransform = group.getTransformInPageRegion(region);
    }

    public String getPresentationName() {
        if (this.element instanceof ComponentGroup) {
            ComponentGroup group = (ComponentGroup)this.element;
            return "Set transform of " + group + " in " + this.region + ": " + this.oldTransform + "->" + this.newTransform;
        }
        return "Set transform of " + this.element + " for " + this.deviceType + ": " + this.oldTransform + "->" + this.newTransform;
    }

    public boolean canRedo() {
        return true;
    }

    public void run() {
        if (this.element instanceof ComponentGroup) {
            ((ComponentGroup)this.element).setTransformInPageRegion(this.region, this.newTransform);
        } else {
            this.element.setTransform(this.deviceType, this.newTransform);
        }
    }

    public void redo() {
        this.run();
    }

    public void undo() {
        if (this.element instanceof ComponentGroup) {
            ((ComponentGroup)this.element).setTransformInPageRegion(this.region, this.oldTransform);
        } else {
            this.element.setTransform(this.deviceType, this.oldTransform);
        }
    }
}

