/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.command;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.command.ModifyGraphCommand;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.lib.satin.command.UndoableCommand;

public class SetTextSizeCommand
extends UndoableCommand
implements ModifyGraphCommand {
    private final Content content;
    private final DeviceType deviceType;
    private final int newSize;
    private final int oldSize;

    public SetTextSizeCommand(Content content, DeviceType deviceType, int size) {
        this.content = content;
        this.deviceType = deviceType;
        this.newSize = size;
        this.oldSize = content.getTextSize(deviceType);
    }

    public String getPresentationName() {
        return "Set text size of " + this.content + " for " + this.deviceType + ": " + this.oldSize + "->" + this.newSize;
    }

    public boolean canRedo() {
        return true;
    }

    public void run() {
        this.content.setTextSize(this.deviceType, this.newSize);
    }

    public void redo() {
        this.run();
    }

    public void undo() {
        this.content.setTextSize(this.deviceType, this.oldSize);
    }
}

