/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.command;

import edu.berkeley.guir.damask.command.ModifyGraphCommand;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.lib.satin.command.UndoableCommand;

public class SetPageIndexCommand
extends UndoableCommand
implements ModifyGraphCommand {
    private final Page page;
    private final int newIndex;
    private int oldIndex;

    public SetPageIndexCommand(Page page, int newIndex) {
        this.page = page;
        this.newIndex = newIndex;
    }

    public String getPresentationName() {
        return "Set index of " + this.page + " to " + this.newIndex;
    }

    public boolean canRedo() {
        return true;
    }

    public void run() {
        Dialog dialog = this.page.getDialog();
        this.oldIndex = dialog.indexOf(this.page);
        dialog.setIndex(this.newIndex, this.page);
    }

    public void redo() {
        this.run();
    }

    public void undo() {
        this.page.getDialog().setIndex(this.oldIndex, this.page);
    }
}

