/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.command;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.InteractionElement;
import edu.berkeley.guir.damask.command.ModifyGraphCommand;
import edu.berkeley.guir.lib.satin.command.UndoableCommand;
import java.awt.geom.Point2D;

public class SetLocationCommand
extends UndoableCommand
implements ModifyGraphCommand {
    private final InteractionElement element;
    private final DeviceType deviceType;
    private final Point2D newLocation;
    private final Point2D oldLocation;

    public SetLocationCommand(InteractionElement element, DeviceType deviceType, Point2D newLocation) {
        this.element = element;
        this.deviceType = deviceType;
        this.newLocation = newLocation;
        this.oldLocation = element.getLocation(deviceType);
    }

    public String getPresentationName() {
        return "Set location of " + this.element + ": " + this.oldLocation + "->" + this.newLocation;
    }

    public boolean canRedo() {
        return true;
    }

    public void run() {
        this.element.setLocation(this.deviceType, this.newLocation);
    }

    public void redo() {
        this.run();
    }

    public void undo() {
        this.element.setLocation(this.deviceType, this.oldLocation);
    }
}

