/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.command;

import edu.berkeley.guir.damask.command.ModifyGraphCommand;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.lib.satin.command.UndoableCommand;

public class SetInsetCommand
extends UndoableCommand
implements ModifyGraphCommand {
    private final PageRegion region;
    private final int oldInset;
    private final int newInset;

    public SetInsetCommand(PageRegion region, int newInset) {
        this.region = region;
        this.newInset = newInset;
        this.oldInset = region.getInset();
    }

    public String getPresentationName() {
        return "Set inset of " + this.region + ": " + this.oldInset + "->" + this.newInset;
    }

    public boolean canRedo() {
        return true;
    }

    public void run() {
        this.region.setInset(this.newInset);
    }

    public void redo() {
        this.run();
    }

    public void undo() {
        this.region.setInset(this.oldInset);
    }
}

