/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.command;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.InteractionGraph;
import edu.berkeley.guir.damask.command.ModifyGraphCommand;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.lib.satin.command.UndoableCommand;

public class SetHomePageCommand
extends UndoableCommand
implements ModifyGraphCommand {
    private final InteractionGraph graph;
    private final DeviceType deviceType;
    private final Page newHomePage;
    private final Page oldHomePage;

    public SetHomePageCommand(InteractionGraph graph, DeviceType deviceType, Page homePage) {
        this.graph = graph;
        this.deviceType = deviceType;
        this.newHomePage = homePage;
        this.oldHomePage = graph.getHomePage(deviceType);
    }

    public String getPresentationName() {
        return "Set home page of " + this.graph + ": " + this.oldHomePage + "->" + this.newHomePage;
    }

    public boolean canRedo() {
        return true;
    }

    public void run() {
        this.graph.setHomePage(this.deviceType, this.newHomePage);
    }

    public void redo() {
        this.run();
    }

    public void undo() {
        this.graph.setHomePage(this.deviceType, this.oldHomePage);
    }
}

