/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.command;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.command.ModifyGraphCommand;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.lib.satin.command.UndoableCommand;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SetContentDisplayModeCommand
extends UndoableCommand
implements ModifyGraphCommand {
    private final Content content;
    private final DeviceType deviceType;
    private final Map oldDisplayModes = new HashMap();
    private final Content.DisplayMode newDisplayMode;

    public SetContentDisplayModeCommand(Content content, DeviceType deviceType, Content.DisplayMode displayMode) {
        this.content = content;
        this.deviceType = deviceType;
        this.newDisplayMode = displayMode;
        Iterator i = deviceType.getSpecificDeviceTypes().iterator();
        while (i.hasNext()) {
            DeviceType aDeviceType = (DeviceType)i.next();
            this.oldDisplayModes.put(aDeviceType, content.getPreferredDisplayMode(aDeviceType));
        }
    }

    public String getPresentationName() {
        return "Set display mode of " + this.content + " for " + this.deviceType + " to " + this.newDisplayMode;
    }

    public boolean canRedo() {
        return true;
    }

    public void run() {
        this.content.setPreferredDisplayMode(this.deviceType, this.newDisplayMode);
    }

    public void redo() {
        this.run();
    }

    public void undo() {
        Iterator i = this.deviceType.getSpecificDeviceTypes().iterator();
        while (i.hasNext()) {
            DeviceType aDeviceType = (DeviceType)i.next();
            this.content.setPreferredDisplayMode(aDeviceType, (Content.DisplayMode)this.oldDisplayModes.get(aDeviceType));
        }
    }
}

