/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.command;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.InteractionElement;
import edu.berkeley.guir.damask.command.ModifyGraphCommand;
import edu.berkeley.guir.damask.component.ComponentGroup;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.lib.satin.command.UndoableCommand;
import java.awt.geom.Rectangle2D;

public class SetBoundsCommand
extends UndoableCommand
implements ModifyGraphCommand {
    private final InteractionElement element;
    private final DeviceType deviceType;
    private final PageRegion region;
    private final Rectangle2D newBounds;
    private final Rectangle2D oldBounds;

    public SetBoundsCommand(InteractionElement element, DeviceType deviceType, Rectangle2D newBounds) {
        this.element = element;
        this.deviceType = deviceType;
        this.region = null;
        this.newBounds = newBounds;
        this.oldBounds = element.getBounds(deviceType);
    }

    public SetBoundsCommand(ComponentGroup group, PageRegion region, Rectangle2D newBounds) {
        this.element = group;
        this.deviceType = null;
        this.region = region;
        this.newBounds = newBounds;
        this.oldBounds = group.getBoundsInPageRegion(region);
    }

    public String getPresentationName() {
        if (this.element instanceof ComponentGroup) {
            ComponentGroup group = (ComponentGroup)this.element;
            return "Set bounds of " + group + " in " + this.region + ": " + this.oldBounds + "->" + this.newBounds;
        }
        return "Set bounds of " + this.element + " for " + this.deviceType + ": " + this.oldBounds + "->" + this.newBounds;
    }

    public boolean canRedo() {
        return true;
    }

    public void run() {
        if (this.element instanceof ComponentGroup) {
            ((ComponentGroup)this.element).setBoundsInPageRegion(this.region, this.newBounds);
        } else {
            this.element.setBounds(this.deviceType, this.newBounds);
        }
    }

    public void redo() {
        this.run();
    }

    public void undo() {
        if (this.element instanceof ComponentGroup) {
            ((ComponentGroup)this.element).setBoundsInPageRegion(this.region, this.oldBounds);
        } else {
            this.element.setBounds(this.deviceType, this.oldBounds);
        }
    }
}

