/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.command;

import edu.berkeley.guir.damask.DamaskUtils;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.command.AddComponentToGroupCommand;
import edu.berkeley.guir.damask.command.AddConnectionCommand;
import edu.berkeley.guir.damask.command.ModifyGraphCommand;
import edu.berkeley.guir.damask.command.ModifyGraphMacroCommand;
import edu.berkeley.guir.damask.command.RemoveConnectionCommand;
import edu.berkeley.guir.damask.command.RemoveGroupCommand;
import edu.berkeley.guir.damask.component.Component;
import edu.berkeley.guir.damask.component.ComponentGroup;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.connection.Connection;
import edu.berkeley.guir.damask.connection.ConnectionDest;
import edu.berkeley.guir.damask.connection.NavConnection;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.lib.satin.command.Command;
import edu.berkeley.guir.lib.satin.command.MacroCommand;
import edu.berkeley.guir.lib.satin.command.UndoableCommand;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ReplaceComponentWithDeviceAllVersionCommand
extends UndoableCommand
implements ModifyGraphCommand {
    private final Command realCommand;
    private final Component component;

    public ReplaceComponentWithDeviceAllVersionCommand(Component component) {
        this.component = component;
        this.realCommand = component instanceof Control ? new ReplaceControlWithDeviceAllVersionCommand((Control)component) : new ReplaceGroupWithDeviceAllVersionCommand((ComponentGroup)component);
    }

    public String getPresentationName() {
        return "Change device-specific " + this.component + " into device-all";
    }

    public boolean canRedo() {
        return true;
    }

    public void run() {
        this.realCommand.execute();
    }

    public void redo() {
        this.realCommand.redo();
    }

    public void undo() {
        this.realCommand.undo();
    }

    private static class ReplaceControlWithDeviceAllVersionCommand
    extends ModifyGraphMacroCommand {
        private Control newControl;

        ReplaceControlWithDeviceAllVersionCommand(Control control) {
            DamaskUtils.checkValidArgument(control.getDialog().getDeviceType() == DeviceType.ALL, "The dialog of " + control + ", " + control.getDialog() + ", must be ALL, not " + control.getDialog().getDeviceType());
            DeviceType origControlDeviceType = control.getDeviceType();
            if (origControlDeviceType == DeviceType.ALL) {
                return;
            }
            Iterator i = control.getOutConnections().iterator();
            while (i.hasNext()) {
                Page destPage;
                Connection connection = (Connection)i.next();
                ConnectionDest dest = connection.getConnectionDest(origControlDeviceType);
                if (dest instanceof Page && (destPage = (Page)dest).getDialog().getDeviceType() != DeviceType.ALL) {
                    throw new IllegalArgumentException("The destination of " + connection + ", " + connection.getConnectionDest(origControlDeviceType) + ", must be ALL, not " + control.getDialog().getDeviceType());
                }
                this.addCommand(new RemoveConnectionCommand(connection, false));
            }
            this.newControl = (Control)control.createCopy(DeviceType.ALL);
            PageRegion targetRegion = control.getPageRegion(origControlDeviceType);
            ComponentGroup targetGroup = control.getGroup();
            if (targetGroup != null && targetGroup.getDeviceType() != DeviceType.ALL) {
                targetGroup = null;
            }
            DamaskUtils.addCommandsForAddingComponentToMacroCommand(this, this.newControl, targetRegion, targetGroup, false, false);
            DamaskUtils.addCommandsForRemovingControlToMacroCommand(this, control);
            Iterator i2 = control.getOutConnections().iterator();
            while (i2.hasNext()) {
                NavConnection connection = (NavConnection)i2.next();
                this.addCommand(new AddConnectionCommand(origControlDeviceType, true, this.newControl, connection.getUserEvent(), connection.getCondition(), connection.getConnectionDest(origControlDeviceType), connection.getShape(origControlDeviceType)));
            }
        }

        public Control getNewControl() {
            return this.newControl;
        }
    }

    private static class ReplaceGroupWithDeviceAllVersionCommand
    extends UndoableCommand
    implements ModifyGraphCommand {
        private final ComponentGroup group;
        private final MacroCommand replaceControlCommands = new MacroCommand();
        private final MacroCommand addControlCommands = new MacroCommand();
        private final MacroCommand replaceGroupCommands = new MacroCommand();
        private final Map newControls = new HashMap();

        public ReplaceGroupWithDeviceAllVersionCommand(ComponentGroup group) {
            this.group = group;
        }

        private void replaceControlsInGroupWithDeviceAllVersion(ComponentGroup group) {
            Dialog dialog = group.getDialog();
            DamaskUtils.checkValidArgument(dialog.getDeviceType() == DeviceType.ALL, "The dialog of " + group + ", " + dialog + ", must be ALL, not " + dialog.getDeviceType());
            Iterator i = group.getChildren().iterator();
            while (i.hasNext()) {
                Component child = (Component)i.next();
                if (child instanceof Control) {
                    Control childControl = (Control)child;
                    ReplaceControlWithDeviceAllVersionCommand replaceCommand = new ReplaceControlWithDeviceAllVersionCommand(childControl);
                    this.newControls.put(childControl, replaceCommand.getNewControl());
                    this.replaceControlCommands.addCommand(replaceCommand);
                    continue;
                }
                this.replaceControlsInGroupWithDeviceAllVersion((ComponentGroup)child);
            }
        }

        private ComponentGroup addControlsToNewGroup(ComponentGroup group) {
            Dialog dialog = group.getDialog();
            DamaskUtils.checkValidArgument(dialog.getDeviceType() == DeviceType.ALL, "The dialog of " + group + ", " + dialog + ", must be ALL, not " + dialog.getDeviceType());
            ComponentGroup newGroup = (ComponentGroup)group.createCopy(DeviceType.ALL);
            Iterator i = group.getChildren().iterator();
            while (i.hasNext()) {
                Component child = (Component)i.next();
                if (child instanceof Control) {
                    Control newChildControl = (Control)this.newControls.get(child);
                    newGroup.add(newChildControl);
                    continue;
                }
                ComponentGroup childGroup = (ComponentGroup)child;
                ComponentGroup newChildGroup = this.addControlsToNewGroup(childGroup);
                newGroup.add(newChildGroup);
            }
            return newGroup;
        }

        private void replaceGroupWithDeviceAllVersion(ComponentGroup newGroup) {
            DeviceType origGroupDeviceType = this.group.getDeviceType();
            PageRegion targetRegion = (PageRegion)this.group.getPageRegions(origGroupDeviceType).iterator().next();
            DamaskUtils.addCommandsForAddingComponentToMacroCommand(this.replaceGroupCommands, newGroup, targetRegion, this.group.getGroup(), false, false);
            Iterator i = newGroup.getChildren().iterator();
            while (i.hasNext()) {
                Component newChild = (Component)i.next();
                if (newChild instanceof Control) {
                    this.addControlCommands.addCommand(new AddComponentToGroupCommand(newGroup, newChild));
                    continue;
                }
                this.replaceGroupWithDeviceAllVersion((ComponentGroup)newChild);
                this.addControlCommands.addCommand(new AddComponentToGroupCommand(newGroup, newChild));
            }
            this.replaceGroupCommands.addCommand(new RemoveGroupCommand(this.group));
        }

        public String getPresentationName() {
            return "Add control to page";
        }

        public boolean canRedo() {
            return true;
        }

        public void run() {
            if (this.group.getDeviceType() == DeviceType.ALL) {
                return;
            }
            this.replaceControlsInGroupWithDeviceAllVersion(this.group);
            this.replaceControlCommands.execute();
            ComponentGroup newGroup = this.addControlsToNewGroup(this.group);
            this.replaceGroupWithDeviceAllVersion(newGroup);
            this.replaceGroupCommands.execute();
            this.addControlCommands.execute();
        }

        public void redo() {
            this.replaceControlCommands.redo();
            this.replaceGroupCommands.redo();
            this.addControlCommands.redo();
        }

        public void undo() {
            this.addControlCommands.undo();
            this.replaceGroupCommands.undo();
            this.replaceControlCommands.undo();
        }
    }
}

