/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.command;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.InteractionGraph;
import edu.berkeley.guir.damask.command.ModifyGraphCommand;
import edu.berkeley.guir.damask.command.RemoveDialogCommand;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.dialog.TemplateDialog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RemoveTemplateCommand
extends RemoveDialogCommand
implements ModifyGraphCommand {
    private final InteractionGraph graph;
    private final TemplateDialog template;
    private final Map pagesWithTemplate = new HashMap();

    public RemoveTemplateCommand(TemplateDialog template) {
        super(template);
        this.graph = template.getInteractionGraph();
        this.template = template;
    }

    public String getPresentationName() {
        return "Remove template " + this.template;
    }

    public boolean canRedo() {
        return true;
    }

    public void run() {
        this.saveConnections();
        this.pagesWithTemplate.clear();
        Iterator i = this.graph.getDialogs().iterator();
        while (i.hasNext()) {
            Dialog dialog = (Dialog)i.next();
            Iterator j = dialog.getDeviceTypesVisibleTo().iterator();
            while (j.hasNext()) {
                DeviceType deviceType = (DeviceType)j.next();
                Iterator k = dialog.getPages(deviceType).iterator();
                while (k.hasNext()) {
                    Page page = (Page)k.next();
                    Iterator m = page.getTemplates().iterator();
                    while (m.hasNext()) {
                        Page pageTemplate = (Page)m.next();
                        if (pageTemplate.getDialog() != this.template) continue;
                        ArrayList<Page> removedTemplates = (ArrayList<Page>)this.pagesWithTemplate.get(page);
                        if (removedTemplates == null) {
                            removedTemplates = new ArrayList<Page>();
                            this.pagesWithTemplate.put(page, removedTemplates);
                        }
                        removedTemplates.add(pageTemplate);
                    }
                }
            }
        }
        this.graph.removeTemplate(this.template);
    }

    public void redo() {
        this.run();
    }

    public void undo() {
        this.graph.addTemplate(this.template);
        this.restoreConnections();
        Iterator i = this.pagesWithTemplate.keySet().iterator();
        while (i.hasNext()) {
            Page page = (Page)i.next();
            List templates = (List)this.pagesWithTemplate.get(page);
            Iterator j = templates.iterator();
            while (j.hasNext()) {
                Page template = (Page)j.next();
                page.addTemplate(template);
            }
        }
    }
}

