/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.command;

import edu.berkeley.guir.damask.command.ModifyGraphCommand;
import edu.berkeley.guir.damask.component.Select;
import edu.berkeley.guir.lib.satin.command.UndoableCommand;

public class RemoveItemCommand
extends UndoableCommand
implements ModifyGraphCommand {
    private final Select control;
    private final Select.Item item;
    private int index;

    public RemoveItemCommand(Select control, Select.Item item) {
        this.control = control;
        this.item = item;
    }

    public String getPresentationName() {
        return "Remove " + this.item + " from " + this.control;
    }

    public boolean canRedo() {
        return true;
    }

    public void run() {
        this.index = this.control.getItems().indexOf(this.item);
        if (this.index != -1) {
            this.control.removeItem(this.item);
        }
    }

    public void redo() {
        this.run();
    }

    public void undo() {
        if (this.index != -1) {
            this.control.addItem(this.index, this.item);
        }
    }
}

