/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.command;

import edu.berkeley.guir.damask.command.ModifyGraphCommand;
import edu.berkeley.guir.damask.component.ComponentGroup;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.lib.satin.command.UndoableCommand;

public class RemoveGroupCommand
extends UndoableCommand
implements ModifyGraphCommand {
    private Dialog dialog;
    private final ComponentGroup group;
    private ComponentGroup parentGroup;

    public RemoveGroupCommand(ComponentGroup group) {
        this.group = group;
    }

    public String getPresentationName() {
        return "Remove component group " + this.group;
    }

    public boolean canRedo() {
        return true;
    }

    public void run() {
        this.dialog = this.group.getDialog();
        this.dialog.removeGroup(this.group);
        this.parentGroup = this.group.getGroup();
        if (this.parentGroup != null) {
            this.parentGroup.remove(this.group);
        }
    }

    public void redo() {
        this.run();
    }

    public void undo() {
        this.dialog.addGroup(this.group);
        if (this.parentGroup != null) {
            this.parentGroup.add(this.group);
        }
    }
}

