/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.command;

import edu.berkeley.guir.damask.Damask;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.InteractionGraph;
import edu.berkeley.guir.damask.command.ConnectionInfo;
import edu.berkeley.guir.damask.command.ModifyGraphCommand;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.component.Trigger;
import edu.berkeley.guir.damask.connection.Connection;
import edu.berkeley.guir.damask.connection.NavConnection;
import edu.berkeley.guir.damask.connection.OrgConnection;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.lib.satin.command.UndoableCommand;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class RemoveDialogCommand
extends UndoableCommand
implements ModifyGraphCommand {
    private final InteractionGraph graph;
    private final Dialog dialog;
    private final Map oldHomePages = new HashMap();
    private final Set connectionInfos = new HashSet();
    private final Map origInNavConnectionTriggers = new HashMap();

    public RemoveDialogCommand(Dialog dialog) {
        this.graph = dialog.getInteractionGraph();
        this.dialog = dialog;
    }

    public String getPresentationName() {
        return "Remove dialog " + this.dialog;
    }

    public boolean canRedo() {
        return true;
    }

    protected void saveConnections() {
        this.connectionInfos.clear();
        this.origInNavConnectionTriggers.clear();
        HashSet<Connection> connections = new HashSet<Connection>();
        Iterator<Object> i = this.dialog.getDeviceTypesVisibleTo().iterator();
        while (i.hasNext()) {
            DeviceType deviceType = (DeviceType)i.next();
            Iterator j = this.dialog.getPages(deviceType).iterator();
            while (j.hasNext()) {
                Connection connection;
                Page page = (Page)j.next();
                Iterator k = page.getInConnections().iterator();
                while (k.hasNext()) {
                    Trigger trigger;
                    Control source;
                    connection = (Connection)k.next();
                    connections.add(connection);
                    this.connectionInfos.add(new ConnectionInfo(connection));
                    if (!(connection instanceof NavConnection) || !((source = (Control)connection.getConnectionSource(deviceType)) instanceof Trigger) || (trigger = (Trigger)source).getStyle(deviceType) != Trigger.HYPERLINK) continue;
                    this.origInNavConnectionTriggers.put(trigger, null);
                }
                k = page.getOutConnections().iterator();
                while (k.hasNext()) {
                    connection = (OrgConnection)k.next();
                    connections.add(connection);
                    this.connectionInfos.add(new ConnectionInfo(connection));
                }
                k = page.getRegions().iterator();
                while (k.hasNext()) {
                    PageRegion region = (PageRegion)k.next();
                    Iterator m = region.getControls().iterator();
                    while (m.hasNext()) {
                        NavConnection connection2;
                        Control control = (Control)m.next();
                        Iterator n = control.getInConnections().iterator();
                        while (n.hasNext()) {
                            connection2 = (NavConnection)n.next();
                            connections.add(connection2);
                            this.connectionInfos.add(new ConnectionInfo(connection2));
                        }
                        n = control.getOutConnections().iterator();
                        while (n.hasNext()) {
                            connection2 = (NavConnection)n.next();
                            connections.add(connection2);
                            this.connectionInfos.add(new ConnectionInfo(connection2));
                        }
                    }
                }
            }
        }
        i = connections.iterator();
        while (i.hasNext()) {
            Connection connection = (Connection)i.next();
            connection.getInteractionGraph().remove(connection);
            connection.dispose();
        }
        i = this.origInNavConnectionTriggers.keySet().iterator();
        while (i.hasNext()) {
            Trigger source = (Trigger)i.next();
            Content sourceContent = (Content)source.getContent().clone();
            this.origInNavConnectionTriggers.put(source, sourceContent);
            Iterator j = source.getDeviceTypesVisibleTo().iterator();
            while (j.hasNext()) {
                DeviceType aDeviceType = (DeviceType)j.next();
                sourceContent.setBounds(aDeviceType, source.getBounds(aDeviceType));
                sourceContent.setTransform(aDeviceType, source.getTransform(aDeviceType));
            }
            source.getDialog().addControlAfter(source, sourceContent);
            source.getDialog().removeControl(source);
        }
    }

    protected void restoreConnections() {
        Iterator<Object> i = this.origInNavConnectionTriggers.keySet().iterator();
        while (i.hasNext()) {
            Trigger source = (Trigger)i.next();
            Content sourceContent = (Content)this.origInNavConnectionTriggers.get(source);
            sourceContent.getDialog().addControlAfter(sourceContent, source);
            sourceContent.getDialog().removeControl(sourceContent);
        }
        i = this.connectionInfos.iterator();
        while (i.hasNext()) {
            ConnectionInfo connectionInfo = (ConnectionInfo)i.next();
            Connection connection = connectionInfo.createConnection();
            this.graph.add(connection);
        }
    }

    public void run() {
        this.saveConnections();
        Iterator i = Damask.getSupportedDeviceTypes().iterator();
        while (i.hasNext()) {
            DeviceType aDeviceType = (DeviceType)i.next();
            Page homePage = this.graph.getHomePage(aDeviceType);
            if (homePage == null || homePage.getDialog() != this.dialog) continue;
            this.oldHomePages.put(aDeviceType, homePage);
        }
        this.graph.remove(this.dialog);
    }

    public void redo() {
        this.run();
    }

    public void undo() {
        this.graph.add(this.dialog);
        this.restoreConnections();
        Iterator i = Damask.getSupportedDeviceTypes().iterator();
        while (i.hasNext()) {
            DeviceType aDeviceType = (DeviceType)i.next();
            Page oldHomePage = (Page)this.oldHomePages.get(aDeviceType);
            if (oldHomePage == null) continue;
            this.graph.setHomePage(aDeviceType, oldHomePage);
        }
    }
}

