/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.command;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.command.ConnectionInfo;
import edu.berkeley.guir.damask.command.ModifyGraphCommand;
import edu.berkeley.guir.damask.component.ComponentGroup;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.connection.Connection;
import edu.berkeley.guir.damask.connection.NavConnection;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.lib.satin.command.UndoableCommand;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class RemoveControlCommand
extends UndoableCommand
implements ModifyGraphCommand {
    private final Control control;
    private Dialog dialog;
    private ComponentGroup group;
    private final Map pageRegions = new HashMap();
    private final Set connectionInfos = new HashSet();

    public RemoveControlCommand(Control control) {
        this.control = control;
    }

    public String getPresentationName() {
        return "Remove control " + this.control;
    }

    public boolean canRedo() {
        return true;
    }

    public void run() {
        this.dialog = this.control.getDialog();
        this.pageRegions.clear();
        this.connectionInfos.clear();
        this.connectionInfos.addAll(ConnectionInfo.createSet(this.control.getInConnections()));
        this.connectionInfos.addAll(ConnectionInfo.createSet(this.control.getOutConnections()));
        Iterator i = this.control.getDeviceTypesVisibleTo().iterator();
        while (i.hasNext()) {
            DeviceType deviceType = (DeviceType)i.next();
            PageRegion region = this.control.getPageRegion(deviceType);
            this.pageRegions.put(region, new Integer(region.getControls().indexOf(this.control)));
        }
        HashSet connections = new HashSet();
        connections.addAll(this.control.getInConnections());
        connections.addAll(this.control.getOutConnections());
        Iterator i2 = connections.iterator();
        while (i2.hasNext()) {
            Connection connection = (Connection)i2.next();
            connection.getInteractionGraph().remove(connection);
            connection.dispose();
        }
        this.dialog.removeControl(this.control);
        this.group = this.control.getGroup();
        if (this.group != null) {
            this.group.remove(this.control);
        }
    }

    public void redo() {
        this.run();
    }

    public void undo() {
        this.dialog.addControl(this.pageRegions, this.control);
        if (this.group != null) {
            this.group.add(this.control);
        }
        Iterator i = this.connectionInfos.iterator();
        while (i.hasNext()) {
            ConnectionInfo connectionInfo = (ConnectionInfo)i.next();
            NavConnection connection = (NavConnection)connectionInfo.createConnection();
            this.control.getInteractionGraph().add(connection);
        }
    }
}

